/* vi: set sw=4 ts=4: */
/*
 * getresuid() for uClibc
 *
 * Copyright (C) 2000-2006 Erik Andersen <andersen@uclibc.org>
 *
 * Licensed under the LGPL v2.1, see the file COPYING.LIB in this tarball.
 */

#include "syscalls.h"
#include <unistd.h>

#ifdef __NR_getresuid
# define __NR___syscall_getresuid __NR_getresuid
static inline _syscall3(int, __syscall_getresuid, __kernel_uid_t *, ruid,
		  __kernel_uid_t *, euid, __kernel_uid_t *, suid);

int getresuid(uid_t * ruid, uid_t * euid, uid_t * suid)
{
	int result;
	__kernel_uid_t k_ruid, k_euid, k_suid;

	result = __syscall_getresuid(&k_ruid, &k_euid, &k_suid);
	if (result == 0) {
		*ruid = (uid_t) k_ruid;
		*euid = (uid_t) k_euid;
		*suid = (uid_t) k_suid;
	}
	return result;
}
#endif
