/*!**********************************************************************
*!
*! FILE NAME: hwregs_def.h
*!
*! DESCRIPTION: Template file for register field default values used by
*!              the init_shadow() function defined in hwregs.c
*!              For each field in each register select a default value
*!              from the listed set of valid values.
*!              Only write only registers need default values.
*!              This file is included in hwregs.h
*!
*! FUNCTIONS: none
*!
*! NOTE: This file is automatically generated, do _not_ edit.
*!       Created: Thu Oct  3 01:21:27 2002
*!       By:      Id: shadow_gen,v 1.14 2002/10/02 20:31:22 hp Exp 
*!       From:    /n/asic/projects/etrax_ng/doc/work/etrax_ng_regs.rd 1.168
*!                /n/asic/projects/etrax_ng/include//hwregs.ctrl 1.3
*!
*! NOTE: There are default constants for all write only registers described
*!       in /n/asic/projects/etrax_ng/doc/work/etrax_ng_regs.rd.
*!       Since one physical register may have several logical names you
*!       only need default constants for those registers that are
*!       initiated in init_shadow(). This is done by the 
*!       'USE_GROUP__group-name' macros in this file.
*!       
*!       As an example, in Etrax100 the following logical registers are
*!       all the same physical register at address 0xb0000044:
*!
*!         R_ATA_CONFIG
*!         R_PAR0_CONFIG
*!         R_SCSI0_CTRL
*!         R_SHARED_RAM_ADDR
*!
*!----------------------------------------------------------------------
*! HISTORY
*!
*! DATE           NAME                 CHANGES
*! ----           ----                 -------
*! Apr 01 1998    Jan Bengtsson        Initial version
*!----------------------------------------------------------------------
*!
*! (C) Copyright 1998, Axis Communications AB, LUND, SWEDEN
*!
*!**********************************************************************/
/* %Z% %M% %I% %G% */

#ifndef __HWREGS_DEF_H__
#define __HWREGS_DEF_H__

/********************** INCLUDE FILES SECTION **************************/

/********************** CONSTANT AND MACRO SECTION *********************/

/*
** To use shadow registers for a register_group, define the following
** macros to TRUE in a project specific file.
*/

#ifndef USE_GROUP__Serial_port_registers
#define USE_GROUP__Serial_port_registers 1
#endif

#ifndef USE_GROUP__ATA_interface_registers
#define USE_GROUP__ATA_interface_registers 1
#endif

#ifndef USE_GROUP__Bus_interface_configuration_registers
#define USE_GROUP__Bus_interface_configuration_registers 1
#endif

#ifndef USE_GROUP__Timer_registers
#define USE_GROUP__Timer_registers 1
#endif

#ifndef USE_GROUP__DMA_registers
#define USE_GROUP__DMA_registers 1
#endif

#ifndef USE_GROUP__External_DMA_registers
#define USE_GROUP__External_DMA_registers 1
#endif

#ifndef USE_GROUP__General_config_registers
#define USE_GROUP__General_config_registers 1
#endif

#ifndef USE_GROUP__Interrupt_mask_and_status_registers
#define USE_GROUP__Interrupt_mask_and_status_registers 1
#endif

#ifndef USE_GROUP__MMU_registers
#define USE_GROUP__MMU_registers 1
#endif

#ifndef USE_GROUP__Network_interface_registers
#define USE_GROUP__Network_interface_registers 1
#endif

#ifndef USE_GROUP__Parallel_printer_port_registers
#define USE_GROUP__Parallel_printer_port_registers 1
#endif

#ifndef USE_GROUP__General_port_configuration_registers
#define USE_GROUP__General_port_configuration_registers 1
#endif

#ifndef USE_GROUP__SCSI_registers
#define USE_GROUP__SCSI_registers 1
#endif

#ifndef USE_GROUP__Shared_RAM_interface_registers
#define USE_GROUP__Shared_RAM_interface_registers 1
#endif

#ifndef USE_GROUP__Test_mode_registers
#define USE_GROUP__Test_mode_registers 1
#endif

#ifndef USE_GROUP__Syncrounous_serial_port_registers
#define USE_GROUP__Syncrounous_serial_port_registers 1
#endif

#ifndef USE_GROUP__USB_interface_control_registers
#define USE_GROUP__USB_interface_control_registers 1
#endif


/*
** Default values for register  R_ALT_SER_BAUDRATE
*/

/* timer normal extern prescale */
#ifndef R_ALT_SER_BAUDRATE__ser3_tr__DEFAULT
#define R_ALT_SER_BAUDRATE__ser3_tr__DEFAULT timer
#endif

/* timer normal extern prescale */
#ifndef R_ALT_SER_BAUDRATE__ser3_rec__DEFAULT
#define R_ALT_SER_BAUDRATE__ser3_rec__DEFAULT timer
#endif

/* timer normal extern prescale */
#ifndef R_ALT_SER_BAUDRATE__ser2_tr__DEFAULT
#define R_ALT_SER_BAUDRATE__ser2_tr__DEFAULT timer
#endif

/* timer normal extern prescale */
#ifndef R_ALT_SER_BAUDRATE__ser2_rec__DEFAULT
#define R_ALT_SER_BAUDRATE__ser2_rec__DEFAULT timer
#endif

/* timer normal extern prescale */
#ifndef R_ALT_SER_BAUDRATE__ser1_tr__DEFAULT
#define R_ALT_SER_BAUDRATE__ser1_tr__DEFAULT timer
#endif

/* timer normal extern prescale */
#ifndef R_ALT_SER_BAUDRATE__ser1_rec__DEFAULT
#define R_ALT_SER_BAUDRATE__ser1_rec__DEFAULT timer
#endif

/* timer normal extern prescale */
#ifndef R_ALT_SER_BAUDRATE__ser0_tr__DEFAULT
#define R_ALT_SER_BAUDRATE__ser0_tr__DEFAULT timer
#endif

/* timer normal extern prescale */
#ifndef R_ALT_SER_BAUDRATE__ser0_rec__DEFAULT
#define R_ALT_SER_BAUDRATE__ser0_rec__DEFAULT timer
#endif

/*
** Default values for register  R_ATA_CONFIG
*/

/* off on */
#ifndef R_ATA_CONFIG__enable__DEFAULT
#define R_ATA_CONFIG__enable__DEFAULT off
#endif

/*  0 - 31 */
#ifndef R_ATA_CONFIG__dma_strobe__DEFAULT
#define R_ATA_CONFIG__dma_strobe__DEFAULT 0
#endif

/*  0 - 31 */
#ifndef R_ATA_CONFIG__dma_hold__DEFAULT
#define R_ATA_CONFIG__dma_hold__DEFAULT 0
#endif

/*  0 - 31 */
#ifndef R_ATA_CONFIG__pio_setup__DEFAULT
#define R_ATA_CONFIG__pio_setup__DEFAULT 0
#endif

/*  0 - 31 */
#ifndef R_ATA_CONFIG__pio_strobe__DEFAULT
#define R_ATA_CONFIG__pio_strobe__DEFAULT 0
#endif

/*  0 - 31 */
#ifndef R_ATA_CONFIG__pio_hold__DEFAULT
#define R_ATA_CONFIG__pio_hold__DEFAULT 0
#endif

/*
** Default values for register  R_ATA_CTRL_DATA
*/

/*  0 - 3 */
#ifndef R_ATA_CTRL_DATA__sel__DEFAULT
#define R_ATA_CTRL_DATA__sel__DEFAULT 0
#endif

/* inactive active */
#ifndef R_ATA_CTRL_DATA__cs1__DEFAULT
#define R_ATA_CTRL_DATA__cs1__DEFAULT inactive
#endif

/* inactive active */
#ifndef R_ATA_CTRL_DATA__cs0__DEFAULT
#define R_ATA_CTRL_DATA__cs0__DEFAULT inactive
#endif

/*  0 - 7 */
#ifndef R_ATA_CTRL_DATA__addr__DEFAULT
#define R_ATA_CTRL_DATA__addr__DEFAULT 0
#endif

/* write read */
#ifndef R_ATA_CTRL_DATA__rw__DEFAULT
#define R_ATA_CTRL_DATA__rw__DEFAULT write
#endif

/* dma register */
#ifndef R_ATA_CTRL_DATA__src_dst__DEFAULT
#define R_ATA_CTRL_DATA__src_dst__DEFAULT dma
#endif

/* pio dma */
#ifndef R_ATA_CTRL_DATA__handsh__DEFAULT
#define R_ATA_CTRL_DATA__handsh__DEFAULT pio
#endif

/* off on */
#ifndef R_ATA_CTRL_DATA__multi__DEFAULT
#define R_ATA_CTRL_DATA__multi__DEFAULT off
#endif

/* word byte */
#ifndef R_ATA_CTRL_DATA__dma_size__DEFAULT
#define R_ATA_CTRL_DATA__dma_size__DEFAULT word
#endif

/*  0 - 0xffff */
#ifndef R_ATA_CTRL_DATA__data__DEFAULT
#define R_ATA_CTRL_DATA__data__DEFAULT 0
#endif

/*
** Default values for register  R_BUS_CONFIG
*/

/* bwe cwe */
#ifndef R_BUS_CONFIG__sram_type__DEFAULT
#define R_BUS_CONFIG__sram_type__DEFAULT bwe
#endif

/* burst32 burst16 */
#ifndef R_BUS_CONFIG__dma_burst__DEFAULT
#define R_BUS_CONFIG__dma_burst__DEFAULT burst32
#endif

/* ext norm */
#ifndef R_BUS_CONFIG__pcs4_7_wr__DEFAULT
#define R_BUS_CONFIG__pcs4_7_wr__DEFAULT ext
#endif

/* ext norm */
#ifndef R_BUS_CONFIG__pcs0_3_wr__DEFAULT
#define R_BUS_CONFIG__pcs0_3_wr__DEFAULT ext
#endif

/* ext norm */
#ifndef R_BUS_CONFIG__sram_wr__DEFAULT
#define R_BUS_CONFIG__sram_wr__DEFAULT ext
#endif

/* ext norm */
#ifndef R_BUS_CONFIG__flash_wr__DEFAULT
#define R_BUS_CONFIG__flash_wr__DEFAULT ext
#endif

/* bw16 bw32 */
#ifndef R_BUS_CONFIG__pcs4_7_bw__DEFAULT
#define R_BUS_CONFIG__pcs4_7_bw__DEFAULT bw16
#endif

/* bw16 bw32 */
#ifndef R_BUS_CONFIG__pcs0_3_bw__DEFAULT
#define R_BUS_CONFIG__pcs0_3_bw__DEFAULT bw16
#endif

/* bw16 bw32 */
#ifndef R_BUS_CONFIG__sram_bw__DEFAULT
#define R_BUS_CONFIG__sram_bw__DEFAULT bw16
#endif

/* bw16 bw32 */
#ifndef R_BUS_CONFIG__flash_bw__DEFAULT
#define R_BUS_CONFIG__flash_bw__DEFAULT bw16
#endif

/*
** Default values for register  R_CLOCK_PRESCALE
*/

/*  0 - 0xffff */
#ifndef R_CLOCK_PRESCALE__ser_presc__DEFAULT
#define R_CLOCK_PRESCALE__ser_presc__DEFAULT 0
#endif

/*  0 - 0xffff */
#ifndef R_CLOCK_PRESCALE__tim_presc__DEFAULT
#define R_CLOCK_PRESCALE__tim_presc__DEFAULT 0
#endif

/*
** Default values for register  R_DMA_CH0_CLR_INTR
*/

/* do dont */
#ifndef R_DMA_CH0_CLR_INTR__clr_eop__DEFAULT
#define R_DMA_CH0_CLR_INTR__clr_eop__DEFAULT do
#endif

/* do dont */
#ifndef R_DMA_CH0_CLR_INTR__clr_descr__DEFAULT
#define R_DMA_CH0_CLR_INTR__clr_descr__DEFAULT do
#endif

/*
** Default values for register  R_DMA_CH1_CLR_INTR
*/

/* do dont */
#ifndef R_DMA_CH1_CLR_INTR__clr_eop__DEFAULT
#define R_DMA_CH1_CLR_INTR__clr_eop__DEFAULT do
#endif

/* do dont */
#ifndef R_DMA_CH1_CLR_INTR__clr_descr__DEFAULT
#define R_DMA_CH1_CLR_INTR__clr_descr__DEFAULT do
#endif

/*
** Default values for register  R_DMA_CH2_CLR_INTR
*/

/* do dont */
#ifndef R_DMA_CH2_CLR_INTR__clr_eop__DEFAULT
#define R_DMA_CH2_CLR_INTR__clr_eop__DEFAULT do
#endif

/* do dont */
#ifndef R_DMA_CH2_CLR_INTR__clr_descr__DEFAULT
#define R_DMA_CH2_CLR_INTR__clr_descr__DEFAULT do
#endif

/*
** Default values for register  R_DMA_CH3_CLR_INTR
*/

/* do dont */
#ifndef R_DMA_CH3_CLR_INTR__clr_eop__DEFAULT
#define R_DMA_CH3_CLR_INTR__clr_eop__DEFAULT do
#endif

/* do dont */
#ifndef R_DMA_CH3_CLR_INTR__clr_descr__DEFAULT
#define R_DMA_CH3_CLR_INTR__clr_descr__DEFAULT do
#endif

/*
** Default values for register  R_DMA_CH4_CLR_INTR
*/

/* do dont */
#ifndef R_DMA_CH4_CLR_INTR__clr_eop__DEFAULT
#define R_DMA_CH4_CLR_INTR__clr_eop__DEFAULT do
#endif

/* do dont */
#ifndef R_DMA_CH4_CLR_INTR__clr_descr__DEFAULT
#define R_DMA_CH4_CLR_INTR__clr_descr__DEFAULT do
#endif

/*
** Default values for register  R_DMA_CH5_CLR_INTR
*/

/* do dont */
#ifndef R_DMA_CH5_CLR_INTR__clr_eop__DEFAULT
#define R_DMA_CH5_CLR_INTR__clr_eop__DEFAULT do
#endif

/* do dont */
#ifndef R_DMA_CH5_CLR_INTR__clr_descr__DEFAULT
#define R_DMA_CH5_CLR_INTR__clr_descr__DEFAULT do
#endif

/*
** Default values for register  R_DMA_CH6_CLR_INTR
*/

/* do dont */
#ifndef R_DMA_CH6_CLR_INTR__clr_eop__DEFAULT
#define R_DMA_CH6_CLR_INTR__clr_eop__DEFAULT do
#endif

/* do dont */
#ifndef R_DMA_CH6_CLR_INTR__clr_descr__DEFAULT
#define R_DMA_CH6_CLR_INTR__clr_descr__DEFAULT do
#endif

/*
** Default values for register  R_DMA_CH7_CLR_INTR
*/

/* do dont */
#ifndef R_DMA_CH7_CLR_INTR__clr_eop__DEFAULT
#define R_DMA_CH7_CLR_INTR__clr_eop__DEFAULT do
#endif

/* do dont */
#ifndef R_DMA_CH7_CLR_INTR__clr_descr__DEFAULT
#define R_DMA_CH7_CLR_INTR__clr_descr__DEFAULT do
#endif

/*
** Default values for register  R_DMA_CH8_CLR_INTR
*/

/* do dont */
#ifndef R_DMA_CH8_CLR_INTR__clr_eop__DEFAULT
#define R_DMA_CH8_CLR_INTR__clr_eop__DEFAULT do
#endif

/* do dont */
#ifndef R_DMA_CH8_CLR_INTR__clr_descr__DEFAULT
#define R_DMA_CH8_CLR_INTR__clr_descr__DEFAULT do
#endif

/*
** Default values for register  R_DMA_CH8_SUB0_CLR_INTR
*/

/* do dont */
#ifndef R_DMA_CH8_SUB0_CLR_INTR__clr_descr__DEFAULT
#define R_DMA_CH8_SUB0_CLR_INTR__clr_descr__DEFAULT do
#endif

/*
** Default values for register  R_DMA_CH8_SUB1_CLR_INTR
*/

/* do dont */
#ifndef R_DMA_CH8_SUB1_CLR_INTR__clr_descr__DEFAULT
#define R_DMA_CH8_SUB1_CLR_INTR__clr_descr__DEFAULT do
#endif

/*
** Default values for register  R_DMA_CH8_SUB2_CLR_INTR
*/

/* do dont */
#ifndef R_DMA_CH8_SUB2_CLR_INTR__clr_descr__DEFAULT
#define R_DMA_CH8_SUB2_CLR_INTR__clr_descr__DEFAULT do
#endif

/*
** Default values for register  R_DMA_CH8_SUB3_CLR_INTR
*/

/* do dont */
#ifndef R_DMA_CH8_SUB3_CLR_INTR__clr_descr__DEFAULT
#define R_DMA_CH8_SUB3_CLR_INTR__clr_descr__DEFAULT do
#endif

/*
** Default values for register  R_DMA_CH9_CLR_INTR
*/

/* do dont */
#ifndef R_DMA_CH9_CLR_INTR__clr_eop__DEFAULT
#define R_DMA_CH9_CLR_INTR__clr_eop__DEFAULT do
#endif

/* do dont */
#ifndef R_DMA_CH9_CLR_INTR__clr_descr__DEFAULT
#define R_DMA_CH9_CLR_INTR__clr_descr__DEFAULT do
#endif

/*
** Default values for register  R_DRAM_CONFIG
*/

/* wmm norm */
#ifndef R_DRAM_CONFIG__wmm1__DEFAULT
#define R_DRAM_CONFIG__wmm1__DEFAULT wmm
#endif

/* wmm norm */
#ifndef R_DRAM_CONFIG__wmm0__DEFAULT
#define R_DRAM_CONFIG__wmm0__DEFAULT wmm
#endif

/*  0 - 7 */
#ifndef R_DRAM_CONFIG__sh1__DEFAULT
#define R_DRAM_CONFIG__sh1__DEFAULT 0
#endif

/*  0 - 7 */
#ifndef R_DRAM_CONFIG__sh0__DEFAULT
#define R_DRAM_CONFIG__sh0__DEFAULT 0
#endif

/* bw16 bw32 */
#ifndef R_DRAM_CONFIG__w__DEFAULT
#define R_DRAM_CONFIG__w__DEFAULT bw16
#endif

/* bank byte */
#ifndef R_DRAM_CONFIG__c__DEFAULT
#define R_DRAM_CONFIG__c__DEFAULT bank
#endif

/* edo fast */
#ifndef R_DRAM_CONFIG__e__DEFAULT
#define R_DRAM_CONFIG__e__DEFAULT edo
#endif

/* bit10 bit20 bit11 bit21 bit12 bit22 bit13 bit23 bit14 bit24 bit15 bit25 bit16 bit26 bit17 bit27 bit18 bit9 bit28 bit19 grp0 bit29 grp1 */
#ifndef R_DRAM_CONFIG__group_sel__DEFAULT
#define R_DRAM_CONFIG__group_sel__DEFAULT bit10
#endif

/*  0 - 7 */
#ifndef R_DRAM_CONFIG__ca1__DEFAULT
#define R_DRAM_CONFIG__ca1__DEFAULT 0
#endif

/* bit10 bit20 bit11 bit21 bit12 bit22 bit13 bit23 bit14 bit24 bit15 bit25 bit16 bit26 bit17 bit27 bit18 bit28 bit19 bit29 bank0 bank1 bit9 */
#ifndef R_DRAM_CONFIG__bank23sel__DEFAULT
#define R_DRAM_CONFIG__bank23sel__DEFAULT bit10
#endif

/*  0 - 7 */
#ifndef R_DRAM_CONFIG__ca0__DEFAULT
#define R_DRAM_CONFIG__ca0__DEFAULT 0
#endif

/* bit10 bit20 bit11 bit21 bit12 bit22 bit13 bit23 bit14 bit24 bit15 bit25 bit16 bit26 bit17 bit27 bit18 bit28 bit19 bit29 bank0 bank1 bit9 */
#ifndef R_DRAM_CONFIG__bank01sel__DEFAULT
#define R_DRAM_CONFIG__bank01sel__DEFAULT bit10
#endif

/*
** Default values for register  R_DRAM_TIMING
*/

/* disable enable */
#ifndef R_DRAM_TIMING__sdram__DEFAULT
#define R_DRAM_TIMING__sdram__DEFAULT disable
#endif

/* e13us disable e52us e8700ns */
#ifndef R_DRAM_TIMING__ref__DEFAULT
#define R_DRAM_TIMING__ref__DEFAULT e13us
#endif

/*  0 - 3 */
#ifndef R_DRAM_TIMING__rp__DEFAULT
#define R_DRAM_TIMING__rp__DEFAULT 0
#endif

/*  0 - 3 */
#ifndef R_DRAM_TIMING__rs__DEFAULT
#define R_DRAM_TIMING__rs__DEFAULT 0
#endif

/*  0 - 3 */
#ifndef R_DRAM_TIMING__rh__DEFAULT
#define R_DRAM_TIMING__rh__DEFAULT 0
#endif

/* ext norm */
#ifndef R_DRAM_TIMING__w__DEFAULT
#define R_DRAM_TIMING__w__DEFAULT ext
#endif

/* ext norm */
#ifndef R_DRAM_TIMING__c__DEFAULT
#define R_DRAM_TIMING__c__DEFAULT ext
#endif

/*  0 - 3 */
#ifndef R_DRAM_TIMING__cz__DEFAULT
#define R_DRAM_TIMING__cz__DEFAULT 0
#endif

/*  0 - 3 */
#ifndef R_DRAM_TIMING__cp__DEFAULT
#define R_DRAM_TIMING__cp__DEFAULT 0
#endif

/*  0 - 3 */
#ifndef R_DRAM_TIMING__cw__DEFAULT
#define R_DRAM_TIMING__cw__DEFAULT 0
#endif

/*
** Default values for register  R_EXT_DMA_0_ADDR
*/

/*  0 - 0xfffffff */
#ifndef R_EXT_DMA_0_ADDR__ext0_addr__DEFAULT
#define R_EXT_DMA_0_ADDR__ext0_addr__DEFAULT 0
#endif

/*
** Default values for register  R_EXT_DMA_0_CMD
*/

/* disable enable */
#ifndef R_EXT_DMA_0_CMD__cnt__DEFAULT
#define R_EXT_DMA_0_CMD__cnt__DEFAULT disable
#endif

/* ahigh alow */
#ifndef R_EXT_DMA_0_CMD__rqpol__DEFAULT
#define R_EXT_DMA_0_CMD__rqpol__DEFAULT ahigh
#endif

/* ahigh alow */
#ifndef R_EXT_DMA_0_CMD__apol__DEFAULT
#define R_EXT_DMA_0_CMD__apol__DEFAULT ahigh
#endif

/* burst handsh */
#ifndef R_EXT_DMA_0_CMD__rq_ack__DEFAULT
#define R_EXT_DMA_0_CMD__rq_ack__DEFAULT burst
#endif

/* dword word byte */
#ifndef R_EXT_DMA_0_CMD__wid__DEFAULT
#define R_EXT_DMA_0_CMD__wid__DEFAULT dword
#endif

/* input output */
#ifndef R_EXT_DMA_0_CMD__dir__DEFAULT
#define R_EXT_DMA_0_CMD__dir__DEFAULT input
#endif

/* stop start */
#ifndef R_EXT_DMA_0_CMD__run__DEFAULT
#define R_EXT_DMA_0_CMD__run__DEFAULT stop
#endif

/*  0 - 0xffff */
#ifndef R_EXT_DMA_0_CMD__trf_count__DEFAULT
#define R_EXT_DMA_0_CMD__trf_count__DEFAULT 0
#endif

/*
** Default values for register  R_EXT_DMA_1_ADDR
*/

/*  0 - 0xfffffff */
#ifndef R_EXT_DMA_1_ADDR__ext0_addr__DEFAULT
#define R_EXT_DMA_1_ADDR__ext0_addr__DEFAULT 0
#endif

/*
** Default values for register  R_EXT_DMA_1_CMD
*/

/* disable enable */
#ifndef R_EXT_DMA_1_CMD__cnt__DEFAULT
#define R_EXT_DMA_1_CMD__cnt__DEFAULT disable
#endif

/* ahigh alow */
#ifndef R_EXT_DMA_1_CMD__rqpol__DEFAULT
#define R_EXT_DMA_1_CMD__rqpol__DEFAULT ahigh
#endif

/* ahigh alow */
#ifndef R_EXT_DMA_1_CMD__apol__DEFAULT
#define R_EXT_DMA_1_CMD__apol__DEFAULT ahigh
#endif

/* burst handsh */
#ifndef R_EXT_DMA_1_CMD__rq_ack__DEFAULT
#define R_EXT_DMA_1_CMD__rq_ack__DEFAULT burst
#endif

/* dword word byte */
#ifndef R_EXT_DMA_1_CMD__wid__DEFAULT
#define R_EXT_DMA_1_CMD__wid__DEFAULT dword
#endif

/* input output */
#ifndef R_EXT_DMA_1_CMD__dir__DEFAULT
#define R_EXT_DMA_1_CMD__dir__DEFAULT input
#endif

/* stop start */
#ifndef R_EXT_DMA_1_CMD__run__DEFAULT
#define R_EXT_DMA_1_CMD__run__DEFAULT stop
#endif

/*  0 - 0xffff */
#ifndef R_EXT_DMA_1_CMD__trf_count__DEFAULT
#define R_EXT_DMA_1_CMD__trf_count__DEFAULT 0
#endif

/*
** Default values for register  R_GEN_CONFIG
*/

/* select disable */
#ifndef R_GEN_CONFIG__par_w__DEFAULT
#define R_GEN_CONFIG__par_w__DEFAULT select
#endif

/* select disable */
#ifndef R_GEN_CONFIG__usb2__DEFAULT
#define R_GEN_CONFIG__usb2__DEFAULT select
#endif

/* select disable */
#ifndef R_GEN_CONFIG__usb1__DEFAULT
#define R_GEN_CONFIG__usb1__DEFAULT select
#endif

/* out in */
#ifndef R_GEN_CONFIG__g24dir__DEFAULT
#define R_GEN_CONFIG__g24dir__DEFAULT out
#endif

/* out in */
#ifndef R_GEN_CONFIG__g16_23dir__DEFAULT
#define R_GEN_CONFIG__g16_23dir__DEFAULT out
#endif

/* out in */
#ifndef R_GEN_CONFIG__g8_15dir__DEFAULT
#define R_GEN_CONFIG__g8_15dir__DEFAULT out
#endif

/* out in */
#ifndef R_GEN_CONFIG__g0dir__DEFAULT
#define R_GEN_CONFIG__g0dir__DEFAULT out
#endif

/* serial1 usb */
#ifndef R_GEN_CONFIG__dma9__DEFAULT
#define R_GEN_CONFIG__dma9__DEFAULT serial1
#endif

/* serial1 usb */
#ifndef R_GEN_CONFIG__dma8__DEFAULT
#define R_GEN_CONFIG__dma8__DEFAULT serial1
#endif

/* serial0 intdma6 extdma1 unused */
#ifndef R_GEN_CONFIG__dma7__DEFAULT
#define R_GEN_CONFIG__dma7__DEFAULT serial0
#endif

/* serial0 intdma7 extdma1 unused */
#ifndef R_GEN_CONFIG__dma6__DEFAULT
#define R_GEN_CONFIG__dma6__DEFAULT serial0
#endif

/* extdma0 serial3 scsi1 par1 */
#ifndef R_GEN_CONFIG__dma5__DEFAULT
#define R_GEN_CONFIG__dma5__DEFAULT extdma0
#endif

/* extdma0 serial3 scsi1 par1 */
#ifndef R_GEN_CONFIG__dma4__DEFAULT
#define R_GEN_CONFIG__dma4__DEFAULT extdma0
#endif

/* serial2 scsi0 par0 ata */
#ifndef R_GEN_CONFIG__dma3__DEFAULT
#define R_GEN_CONFIG__dma3__DEFAULT serial2
#endif

/* serial2 scsi0 par0 ata */
#ifndef R_GEN_CONFIG__dma2__DEFAULT
#define R_GEN_CONFIG__dma2__DEFAULT serial2
#endif

/* select disable */
#ifndef R_GEN_CONFIG__mio_w__DEFAULT
#define R_GEN_CONFIG__mio_w__DEFAULT select
#endif

/* select disable */
#ifndef R_GEN_CONFIG__ser3__DEFAULT
#define R_GEN_CONFIG__ser3__DEFAULT select
#endif

/* select disable */
#ifndef R_GEN_CONFIG__par1__DEFAULT
#define R_GEN_CONFIG__par1__DEFAULT select
#endif

/* select disable */
#ifndef R_GEN_CONFIG__scsi0w__DEFAULT
#define R_GEN_CONFIG__scsi0w__DEFAULT select
#endif

/* select disable */
#ifndef R_GEN_CONFIG__scsi1__DEFAULT
#define R_GEN_CONFIG__scsi1__DEFAULT select
#endif

/* select disable */
#ifndef R_GEN_CONFIG__mio__DEFAULT
#define R_GEN_CONFIG__mio__DEFAULT select
#endif

/* select disable */
#ifndef R_GEN_CONFIG__ser2__DEFAULT
#define R_GEN_CONFIG__ser2__DEFAULT select
#endif

/* select disable */
#ifndef R_GEN_CONFIG__par0__DEFAULT
#define R_GEN_CONFIG__par0__DEFAULT select
#endif

/* select disable */
#ifndef R_GEN_CONFIG__ata__DEFAULT
#define R_GEN_CONFIG__ata__DEFAULT select
#endif

/* select disable */
#ifndef R_GEN_CONFIG__scsi0__DEFAULT
#define R_GEN_CONFIG__scsi0__DEFAULT select
#endif

/*
** Default values for register  R_GEN_CONFIG_II
*/

/* sync async */
#ifndef R_GEN_CONFIG_II__sermode3__DEFAULT
#define R_GEN_CONFIG_II__sermode3__DEFAULT sync
#endif

/* sync async */
#ifndef R_GEN_CONFIG_II__sermode1__DEFAULT
#define R_GEN_CONFIG_II__sermode1__DEFAULT sync
#endif

/* select disable */
#ifndef R_GEN_CONFIG_II__ext_clk__DEFAULT
#define R_GEN_CONFIG_II__ext_clk__DEFAULT select
#endif

/* select disable */
#ifndef R_GEN_CONFIG_II__ser3__DEFAULT
#define R_GEN_CONFIG_II__ser3__DEFAULT select
#endif

/* select disable */
#ifndef R_GEN_CONFIG_II__ser2__DEFAULT
#define R_GEN_CONFIG_II__ser2__DEFAULT select
#endif

/*
** Default values for register  R_IRQ_MASK0_CLR
*/

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__nmi_pin__DEFAULT
#define R_IRQ_MASK0_CLR__nmi_pin__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__watchdog_nmi__DEFAULT
#define R_IRQ_MASK0_CLR__watchdog_nmi__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__sqe_test_error__DEFAULT
#define R_IRQ_MASK0_CLR__sqe_test_error__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__carrier_loss__DEFAULT
#define R_IRQ_MASK0_CLR__carrier_loss__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__deferred__DEFAULT
#define R_IRQ_MASK0_CLR__deferred__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__late_col__DEFAULT
#define R_IRQ_MASK0_CLR__late_col__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__multiple_col__DEFAULT
#define R_IRQ_MASK0_CLR__multiple_col__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__single_col__DEFAULT
#define R_IRQ_MASK0_CLR__single_col__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__congestion__DEFAULT
#define R_IRQ_MASK0_CLR__congestion__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__oversize__DEFAULT
#define R_IRQ_MASK0_CLR__oversize__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__alignment_error__DEFAULT
#define R_IRQ_MASK0_CLR__alignment_error__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__crc_error__DEFAULT
#define R_IRQ_MASK0_CLR__crc_error__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__overrun__DEFAULT
#define R_IRQ_MASK0_CLR__overrun__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__underrun__DEFAULT
#define R_IRQ_MASK0_CLR__underrun__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__excessive_col__DEFAULT
#define R_IRQ_MASK0_CLR__excessive_col__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__mdio__DEFAULT
#define R_IRQ_MASK0_CLR__mdio__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__ata_drq3__DEFAULT
#define R_IRQ_MASK0_CLR__ata_drq3__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__ata_drq2__DEFAULT
#define R_IRQ_MASK0_CLR__ata_drq2__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__ata_drq1__DEFAULT
#define R_IRQ_MASK0_CLR__ata_drq1__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__ata_drq0__DEFAULT
#define R_IRQ_MASK0_CLR__ata_drq0__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__par0_ecp_cmd__DEFAULT
#define R_IRQ_MASK0_CLR__par0_ecp_cmd__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__par0_peri__DEFAULT
#define R_IRQ_MASK0_CLR__par0_peri__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__par0_data__DEFAULT
#define R_IRQ_MASK0_CLR__par0_data__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__par0_ready__DEFAULT
#define R_IRQ_MASK0_CLR__par0_ready__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__ata_dmaend__DEFAULT
#define R_IRQ_MASK0_CLR__ata_dmaend__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__irq_ext_vector_nr__DEFAULT
#define R_IRQ_MASK0_CLR__irq_ext_vector_nr__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__irq_int_vector_nr__DEFAULT
#define R_IRQ_MASK0_CLR__irq_int_vector_nr__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__ext_dma1__DEFAULT
#define R_IRQ_MASK0_CLR__ext_dma1__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__ext_dma0__DEFAULT
#define R_IRQ_MASK0_CLR__ext_dma0__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__timer1__DEFAULT
#define R_IRQ_MASK0_CLR__timer1__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK0_CLR__timer0__DEFAULT
#define R_IRQ_MASK0_CLR__timer0__DEFAULT clr
#endif

/*
** Default values for register  R_IRQ_MASK0_SET
*/

/* set nop */
#ifndef R_IRQ_MASK0_SET__nmi_pin__DEFAULT
#define R_IRQ_MASK0_SET__nmi_pin__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__watchdog_nmi__DEFAULT
#define R_IRQ_MASK0_SET__watchdog_nmi__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__sqe_test_error__DEFAULT
#define R_IRQ_MASK0_SET__sqe_test_error__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__carrier_loss__DEFAULT
#define R_IRQ_MASK0_SET__carrier_loss__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__deferred__DEFAULT
#define R_IRQ_MASK0_SET__deferred__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__late_col__DEFAULT
#define R_IRQ_MASK0_SET__late_col__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__multiple_col__DEFAULT
#define R_IRQ_MASK0_SET__multiple_col__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__single_col__DEFAULT
#define R_IRQ_MASK0_SET__single_col__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__congestion__DEFAULT
#define R_IRQ_MASK0_SET__congestion__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__oversize__DEFAULT
#define R_IRQ_MASK0_SET__oversize__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__alignment_error__DEFAULT
#define R_IRQ_MASK0_SET__alignment_error__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__crc_error__DEFAULT
#define R_IRQ_MASK0_SET__crc_error__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__overrun__DEFAULT
#define R_IRQ_MASK0_SET__overrun__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__underrun__DEFAULT
#define R_IRQ_MASK0_SET__underrun__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__excessive_col__DEFAULT
#define R_IRQ_MASK0_SET__excessive_col__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__mdio__DEFAULT
#define R_IRQ_MASK0_SET__mdio__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__ata_drq3__DEFAULT
#define R_IRQ_MASK0_SET__ata_drq3__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__ata_drq2__DEFAULT
#define R_IRQ_MASK0_SET__ata_drq2__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__ata_drq1__DEFAULT
#define R_IRQ_MASK0_SET__ata_drq1__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__ata_drq0__DEFAULT
#define R_IRQ_MASK0_SET__ata_drq0__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__par0_ecp_cmd__DEFAULT
#define R_IRQ_MASK0_SET__par0_ecp_cmd__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__par0_peri__DEFAULT
#define R_IRQ_MASK0_SET__par0_peri__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__par0_data__DEFAULT
#define R_IRQ_MASK0_SET__par0_data__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__par0_ready__DEFAULT
#define R_IRQ_MASK0_SET__par0_ready__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__ata_dmaend__DEFAULT
#define R_IRQ_MASK0_SET__ata_dmaend__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__irq_ext_vector_nr__DEFAULT
#define R_IRQ_MASK0_SET__irq_ext_vector_nr__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__irq_int_vector_nr__DEFAULT
#define R_IRQ_MASK0_SET__irq_int_vector_nr__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__ext_dma1__DEFAULT
#define R_IRQ_MASK0_SET__ext_dma1__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__ext_dma0__DEFAULT
#define R_IRQ_MASK0_SET__ext_dma0__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__timer1__DEFAULT
#define R_IRQ_MASK0_SET__timer1__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK0_SET__timer0__DEFAULT
#define R_IRQ_MASK0_SET__timer0__DEFAULT set
#endif

/*
** Default values for register  R_IRQ_MASK1_CLR
*/

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__sw_int7__DEFAULT
#define R_IRQ_MASK1_CLR__sw_int7__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__sw_int6__DEFAULT
#define R_IRQ_MASK1_CLR__sw_int6__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__sw_int5__DEFAULT
#define R_IRQ_MASK1_CLR__sw_int5__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__sw_int4__DEFAULT
#define R_IRQ_MASK1_CLR__sw_int4__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__sw_int3__DEFAULT
#define R_IRQ_MASK1_CLR__sw_int3__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__sw_int2__DEFAULT
#define R_IRQ_MASK1_CLR__sw_int2__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__sw_int1__DEFAULT
#define R_IRQ_MASK1_CLR__sw_int1__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__sw_int0__DEFAULT
#define R_IRQ_MASK1_CLR__sw_int0__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__par1_ecp_cmd__DEFAULT
#define R_IRQ_MASK1_CLR__par1_ecp_cmd__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__par1_peri__DEFAULT
#define R_IRQ_MASK1_CLR__par1_peri__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__par1_data__DEFAULT
#define R_IRQ_MASK1_CLR__par1_data__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__par1_ready__DEFAULT
#define R_IRQ_MASK1_CLR__par1_ready__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__ser3_ready__DEFAULT
#define R_IRQ_MASK1_CLR__ser3_ready__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__ser3_data__DEFAULT
#define R_IRQ_MASK1_CLR__ser3_data__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__ser2_ready__DEFAULT
#define R_IRQ_MASK1_CLR__ser2_ready__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__ser2_data__DEFAULT
#define R_IRQ_MASK1_CLR__ser2_data__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__ser1_ready__DEFAULT
#define R_IRQ_MASK1_CLR__ser1_ready__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__ser1_data__DEFAULT
#define R_IRQ_MASK1_CLR__ser1_data__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__ser0_ready__DEFAULT
#define R_IRQ_MASK1_CLR__ser0_ready__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__ser0_data__DEFAULT
#define R_IRQ_MASK1_CLR__ser0_data__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__pa7__DEFAULT
#define R_IRQ_MASK1_CLR__pa7__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__pa6__DEFAULT
#define R_IRQ_MASK1_CLR__pa6__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__pa5__DEFAULT
#define R_IRQ_MASK1_CLR__pa5__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__pa4__DEFAULT
#define R_IRQ_MASK1_CLR__pa4__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__pa3__DEFAULT
#define R_IRQ_MASK1_CLR__pa3__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__pa2__DEFAULT
#define R_IRQ_MASK1_CLR__pa2__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__pa1__DEFAULT
#define R_IRQ_MASK1_CLR__pa1__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK1_CLR__pa0__DEFAULT
#define R_IRQ_MASK1_CLR__pa0__DEFAULT clr
#endif

/*
** Default values for register  R_IRQ_MASK1_SET
*/

/* set nop */
#ifndef R_IRQ_MASK1_SET__sw_int7__DEFAULT
#define R_IRQ_MASK1_SET__sw_int7__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__sw_int6__DEFAULT
#define R_IRQ_MASK1_SET__sw_int6__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__sw_int5__DEFAULT
#define R_IRQ_MASK1_SET__sw_int5__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__sw_int4__DEFAULT
#define R_IRQ_MASK1_SET__sw_int4__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__sw_int3__DEFAULT
#define R_IRQ_MASK1_SET__sw_int3__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__sw_int2__DEFAULT
#define R_IRQ_MASK1_SET__sw_int2__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__sw_int1__DEFAULT
#define R_IRQ_MASK1_SET__sw_int1__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__sw_int0__DEFAULT
#define R_IRQ_MASK1_SET__sw_int0__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__par1_ecp_cmd__DEFAULT
#define R_IRQ_MASK1_SET__par1_ecp_cmd__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__par1_peri__DEFAULT
#define R_IRQ_MASK1_SET__par1_peri__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__par1_data__DEFAULT
#define R_IRQ_MASK1_SET__par1_data__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__par1_ready__DEFAULT
#define R_IRQ_MASK1_SET__par1_ready__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__ser3_ready__DEFAULT
#define R_IRQ_MASK1_SET__ser3_ready__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__ser3_data__DEFAULT
#define R_IRQ_MASK1_SET__ser3_data__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__ser2_ready__DEFAULT
#define R_IRQ_MASK1_SET__ser2_ready__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__ser2_data__DEFAULT
#define R_IRQ_MASK1_SET__ser2_data__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__ser1_ready__DEFAULT
#define R_IRQ_MASK1_SET__ser1_ready__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__ser1_data__DEFAULT
#define R_IRQ_MASK1_SET__ser1_data__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__ser0_ready__DEFAULT
#define R_IRQ_MASK1_SET__ser0_ready__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__ser0_data__DEFAULT
#define R_IRQ_MASK1_SET__ser0_data__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__pa7__DEFAULT
#define R_IRQ_MASK1_SET__pa7__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__pa6__DEFAULT
#define R_IRQ_MASK1_SET__pa6__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__pa5__DEFAULT
#define R_IRQ_MASK1_SET__pa5__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__pa4__DEFAULT
#define R_IRQ_MASK1_SET__pa4__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__pa3__DEFAULT
#define R_IRQ_MASK1_SET__pa3__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__pa2__DEFAULT
#define R_IRQ_MASK1_SET__pa2__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__pa1__DEFAULT
#define R_IRQ_MASK1_SET__pa1__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK1_SET__pa0__DEFAULT
#define R_IRQ_MASK1_SET__pa0__DEFAULT set
#endif

/*
** Default values for register  R_IRQ_MASK2_CLR
*/

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma8_sub3_descr__DEFAULT
#define R_IRQ_MASK2_CLR__dma8_sub3_descr__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma8_sub2_descr__DEFAULT
#define R_IRQ_MASK2_CLR__dma8_sub2_descr__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma8_sub1_descr__DEFAULT
#define R_IRQ_MASK2_CLR__dma8_sub1_descr__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma8_sub0_descr__DEFAULT
#define R_IRQ_MASK2_CLR__dma8_sub0_descr__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma9_eop__DEFAULT
#define R_IRQ_MASK2_CLR__dma9_eop__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma9_descr__DEFAULT
#define R_IRQ_MASK2_CLR__dma9_descr__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma8_eop__DEFAULT
#define R_IRQ_MASK2_CLR__dma8_eop__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma8_descr__DEFAULT
#define R_IRQ_MASK2_CLR__dma8_descr__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma7_eop__DEFAULT
#define R_IRQ_MASK2_CLR__dma7_eop__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma7_descr__DEFAULT
#define R_IRQ_MASK2_CLR__dma7_descr__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma6_eop__DEFAULT
#define R_IRQ_MASK2_CLR__dma6_eop__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma6_descr__DEFAULT
#define R_IRQ_MASK2_CLR__dma6_descr__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma5_eop__DEFAULT
#define R_IRQ_MASK2_CLR__dma5_eop__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma5_descr__DEFAULT
#define R_IRQ_MASK2_CLR__dma5_descr__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma4_eop__DEFAULT
#define R_IRQ_MASK2_CLR__dma4_eop__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma4_descr__DEFAULT
#define R_IRQ_MASK2_CLR__dma4_descr__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma3_eop__DEFAULT
#define R_IRQ_MASK2_CLR__dma3_eop__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma3_descr__DEFAULT
#define R_IRQ_MASK2_CLR__dma3_descr__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma2_eop__DEFAULT
#define R_IRQ_MASK2_CLR__dma2_eop__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma2_descr__DEFAULT
#define R_IRQ_MASK2_CLR__dma2_descr__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma1_eop__DEFAULT
#define R_IRQ_MASK2_CLR__dma1_eop__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma1_descr__DEFAULT
#define R_IRQ_MASK2_CLR__dma1_descr__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma0_eop__DEFAULT
#define R_IRQ_MASK2_CLR__dma0_eop__DEFAULT clr
#endif

/* clr nop */
#ifndef R_IRQ_MASK2_CLR__dma0_descr__DEFAULT
#define R_IRQ_MASK2_CLR__dma0_descr__DEFAULT clr
#endif

/*
** Default values for register  R_IRQ_MASK2_SET
*/

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma8_sub3_descr__DEFAULT
#define R_IRQ_MASK2_SET__dma8_sub3_descr__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma8_sub2_descr__DEFAULT
#define R_IRQ_MASK2_SET__dma8_sub2_descr__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma8_sub1_descr__DEFAULT
#define R_IRQ_MASK2_SET__dma8_sub1_descr__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma8_sub0_descr__DEFAULT
#define R_IRQ_MASK2_SET__dma8_sub0_descr__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma9_eop__DEFAULT
#define R_IRQ_MASK2_SET__dma9_eop__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma9_descr__DEFAULT
#define R_IRQ_MASK2_SET__dma9_descr__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma8_eop__DEFAULT
#define R_IRQ_MASK2_SET__dma8_eop__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma8_descr__DEFAULT
#define R_IRQ_MASK2_SET__dma8_descr__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma7_eop__DEFAULT
#define R_IRQ_MASK2_SET__dma7_eop__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma7_descr__DEFAULT
#define R_IRQ_MASK2_SET__dma7_descr__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma6_eop__DEFAULT
#define R_IRQ_MASK2_SET__dma6_eop__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma6_descr__DEFAULT
#define R_IRQ_MASK2_SET__dma6_descr__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma5_eop__DEFAULT
#define R_IRQ_MASK2_SET__dma5_eop__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma5_descr__DEFAULT
#define R_IRQ_MASK2_SET__dma5_descr__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma4_eop__DEFAULT
#define R_IRQ_MASK2_SET__dma4_eop__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma4_descr__DEFAULT
#define R_IRQ_MASK2_SET__dma4_descr__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma3_eop__DEFAULT
#define R_IRQ_MASK2_SET__dma3_eop__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma3_descr__DEFAULT
#define R_IRQ_MASK2_SET__dma3_descr__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma2_eop__DEFAULT
#define R_IRQ_MASK2_SET__dma2_eop__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma2_descr__DEFAULT
#define R_IRQ_MASK2_SET__dma2_descr__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma1_eop__DEFAULT
#define R_IRQ_MASK2_SET__dma1_eop__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma1_descr__DEFAULT
#define R_IRQ_MASK2_SET__dma1_descr__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma0_eop__DEFAULT
#define R_IRQ_MASK2_SET__dma0_eop__DEFAULT set
#endif

/* set nop */
#ifndef R_IRQ_MASK2_SET__dma0_descr__DEFAULT
#define R_IRQ_MASK2_SET__dma0_descr__DEFAULT set
#endif

/*
** Default values for register  R_MMU_CONFIG
*/

/* disable enable */
#ifndef R_MMU_CONFIG__mmu_enable__DEFAULT
#define R_MMU_CONFIG__mmu_enable__DEFAULT disable
#endif

/* disable enable */
#ifndef R_MMU_CONFIG__inv_excp__DEFAULT
#define R_MMU_CONFIG__inv_excp__DEFAULT disable
#endif

/* disable enable */
#ifndef R_MMU_CONFIG__acc_excp__DEFAULT
#define R_MMU_CONFIG__acc_excp__DEFAULT disable
#endif

/* disable enable */
#ifndef R_MMU_CONFIG__we_excp__DEFAULT
#define R_MMU_CONFIG__we_excp__DEFAULT disable
#endif

/* page seg */
#ifndef R_MMU_CONFIG__seg_f__DEFAULT
#define R_MMU_CONFIG__seg_f__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_CONFIG__seg_e__DEFAULT
#define R_MMU_CONFIG__seg_e__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_CONFIG__seg_d__DEFAULT
#define R_MMU_CONFIG__seg_d__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_CONFIG__seg_c__DEFAULT
#define R_MMU_CONFIG__seg_c__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_CONFIG__seg_b__DEFAULT
#define R_MMU_CONFIG__seg_b__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_CONFIG__seg_a__DEFAULT
#define R_MMU_CONFIG__seg_a__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_CONFIG__seg_9__DEFAULT
#define R_MMU_CONFIG__seg_9__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_CONFIG__seg_8__DEFAULT
#define R_MMU_CONFIG__seg_8__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_CONFIG__seg_7__DEFAULT
#define R_MMU_CONFIG__seg_7__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_CONFIG__seg_6__DEFAULT
#define R_MMU_CONFIG__seg_6__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_CONFIG__seg_5__DEFAULT
#define R_MMU_CONFIG__seg_5__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_CONFIG__seg_4__DEFAULT
#define R_MMU_CONFIG__seg_4__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_CONFIG__seg_3__DEFAULT
#define R_MMU_CONFIG__seg_3__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_CONFIG__seg_2__DEFAULT
#define R_MMU_CONFIG__seg_2__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_CONFIG__seg_1__DEFAULT
#define R_MMU_CONFIG__seg_1__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_CONFIG__seg_0__DEFAULT
#define R_MMU_CONFIG__seg_0__DEFAULT page
#endif

/*
** Default values for register  R_MMU_CTRL
*/

/* disable enable */
#ifndef R_MMU_CTRL__inv_excp__DEFAULT
#define R_MMU_CTRL__inv_excp__DEFAULT disable
#endif

/* disable enable */
#ifndef R_MMU_CTRL__acc_excp__DEFAULT
#define R_MMU_CTRL__acc_excp__DEFAULT disable
#endif

/* disable enable */
#ifndef R_MMU_CTRL__we_excp__DEFAULT
#define R_MMU_CTRL__we_excp__DEFAULT disable
#endif

/*
** Default values for register  R_MMU_ENABLE
*/

/* disable enable */
#ifndef R_MMU_ENABLE__mmu_enable__DEFAULT
#define R_MMU_ENABLE__mmu_enable__DEFAULT disable
#endif

/*
** Default values for register  R_MMU_KBASE_HI
*/

/*  0 - 15 */
#ifndef R_MMU_KBASE_HI__base_f__DEFAULT
#define R_MMU_KBASE_HI__base_f__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_MMU_KBASE_HI__base_e__DEFAULT
#define R_MMU_KBASE_HI__base_e__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_MMU_KBASE_HI__base_d__DEFAULT
#define R_MMU_KBASE_HI__base_d__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_MMU_KBASE_HI__base_c__DEFAULT
#define R_MMU_KBASE_HI__base_c__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_MMU_KBASE_HI__base_b__DEFAULT
#define R_MMU_KBASE_HI__base_b__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_MMU_KBASE_HI__base_a__DEFAULT
#define R_MMU_KBASE_HI__base_a__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_MMU_KBASE_HI__base_9__DEFAULT
#define R_MMU_KBASE_HI__base_9__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_MMU_KBASE_HI__base_8__DEFAULT
#define R_MMU_KBASE_HI__base_8__DEFAULT 0
#endif

/*
** Default values for register  R_MMU_KBASE_LO
*/

/*  0 - 15 */
#ifndef R_MMU_KBASE_LO__base_7__DEFAULT
#define R_MMU_KBASE_LO__base_7__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_MMU_KBASE_LO__base_6__DEFAULT
#define R_MMU_KBASE_LO__base_6__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_MMU_KBASE_LO__base_5__DEFAULT
#define R_MMU_KBASE_LO__base_5__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_MMU_KBASE_LO__base_4__DEFAULT
#define R_MMU_KBASE_LO__base_4__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_MMU_KBASE_LO__base_3__DEFAULT
#define R_MMU_KBASE_LO__base_3__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_MMU_KBASE_LO__base_2__DEFAULT
#define R_MMU_KBASE_LO__base_2__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_MMU_KBASE_LO__base_1__DEFAULT
#define R_MMU_KBASE_LO__base_1__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_MMU_KBASE_LO__base_0__DEFAULT
#define R_MMU_KBASE_LO__base_0__DEFAULT 0
#endif

/*
** Default values for register  R_MMU_KSEG
*/

/* page seg */
#ifndef R_MMU_KSEG__seg_f__DEFAULT
#define R_MMU_KSEG__seg_f__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_KSEG__seg_e__DEFAULT
#define R_MMU_KSEG__seg_e__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_KSEG__seg_d__DEFAULT
#define R_MMU_KSEG__seg_d__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_KSEG__seg_c__DEFAULT
#define R_MMU_KSEG__seg_c__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_KSEG__seg_b__DEFAULT
#define R_MMU_KSEG__seg_b__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_KSEG__seg_a__DEFAULT
#define R_MMU_KSEG__seg_a__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_KSEG__seg_9__DEFAULT
#define R_MMU_KSEG__seg_9__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_KSEG__seg_8__DEFAULT
#define R_MMU_KSEG__seg_8__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_KSEG__seg_7__DEFAULT
#define R_MMU_KSEG__seg_7__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_KSEG__seg_6__DEFAULT
#define R_MMU_KSEG__seg_6__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_KSEG__seg_5__DEFAULT
#define R_MMU_KSEG__seg_5__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_KSEG__seg_4__DEFAULT
#define R_MMU_KSEG__seg_4__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_KSEG__seg_3__DEFAULT
#define R_MMU_KSEG__seg_3__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_KSEG__seg_2__DEFAULT
#define R_MMU_KSEG__seg_2__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_KSEG__seg_1__DEFAULT
#define R_MMU_KSEG__seg_1__DEFAULT page
#endif

/* page seg */
#ifndef R_MMU_KSEG__seg_0__DEFAULT
#define R_MMU_KSEG__seg_0__DEFAULT page
#endif

/*
** Default values for register  R_NETWORK_GA_0
*/

/*  0 - 0xffffffff */
#ifndef R_NETWORK_GA_0__ga_low__DEFAULT
#define R_NETWORK_GA_0__ga_low__DEFAULT 0
#endif

/*
** Default values for register  R_NETWORK_GA_1
*/

/*  0 - 0xffffffff */
#ifndef R_NETWORK_GA_1__ga_high__DEFAULT
#define R_NETWORK_GA_1__ga_high__DEFAULT 0
#endif

/*
** Default values for register  R_NETWORK_GEN_CONFIG
*/

/* off on */
#ifndef R_NETWORK_GEN_CONFIG__loopback__DEFAULT
#define R_NETWORK_GEN_CONFIG__loopback__DEFAULT off
#endif

/* ether tokenr */
#ifndef R_NETWORK_GEN_CONFIG__frame__DEFAULT
#define R_NETWORK_GEN_CONFIG__frame__DEFAULT ether
#endif

/* off on */
#ifndef R_NETWORK_GEN_CONFIG__vg__DEFAULT
#define R_NETWORK_GEN_CONFIG__vg__DEFAULT off
#endif

/* mii_clk sni mii_req mii_err */
#ifndef R_NETWORK_GEN_CONFIG__phy__DEFAULT
#define R_NETWORK_GEN_CONFIG__phy__DEFAULT mii_clk
#endif

/* off on */
#ifndef R_NETWORK_GEN_CONFIG__enable__DEFAULT
#define R_NETWORK_GEN_CONFIG__enable__DEFAULT off
#endif

/*
** Default values for register  R_NETWORK_MGM_CTRL
*/

/*  0 - 0xf */
#ifndef R_NETWORK_MGM_CTRL__txd_pins__DEFAULT
#define R_NETWORK_MGM_CTRL__txd_pins__DEFAULT 0
#endif

/*  0 - 0x1 */
#ifndef R_NETWORK_MGM_CTRL__txer_pin__DEFAULT
#define R_NETWORK_MGM_CTRL__txer_pin__DEFAULT 0
#endif

/*  0 - 0x1 */
#ifndef R_NETWORK_MGM_CTRL__mdck__DEFAULT
#define R_NETWORK_MGM_CTRL__mdck__DEFAULT 0
#endif

/* disable enable */
#ifndef R_NETWORK_MGM_CTRL__mdoe__DEFAULT
#define R_NETWORK_MGM_CTRL__mdoe__DEFAULT disable
#endif

/*  0 - 0x1 */
#ifndef R_NETWORK_MGM_CTRL__mdio__DEFAULT
#define R_NETWORK_MGM_CTRL__mdio__DEFAULT 0
#endif

/*
** Default values for register  R_NETWORK_REC_CONFIG
*/

/* size1518 size1522 */
#ifndef R_NETWORK_REC_CONFIG__max_size__DEFAULT
#define R_NETWORK_REC_CONFIG__max_size__DEFAULT size1518
#endif

/* half full */
#ifndef R_NETWORK_REC_CONFIG__duplex__DEFAULT
#define R_NETWORK_REC_CONFIG__duplex__DEFAULT half
#endif

/* discard receive */
#ifndef R_NETWORK_REC_CONFIG__bad_crc__DEFAULT
#define R_NETWORK_REC_CONFIG__bad_crc__DEFAULT discard
#endif

/* discard receive */
#ifndef R_NETWORK_REC_CONFIG__oversize__DEFAULT
#define R_NETWORK_REC_CONFIG__oversize__DEFAULT discard
#endif

/* discard receive */
#ifndef R_NETWORK_REC_CONFIG__undersize__DEFAULT
#define R_NETWORK_REC_CONFIG__undersize__DEFAULT discard
#endif

/* discard receive */
#ifndef R_NETWORK_REC_CONFIG__all_roots__DEFAULT
#define R_NETWORK_REC_CONFIG__all_roots__DEFAULT discard
#endif

/* discard receive */
#ifndef R_NETWORK_REC_CONFIG__tr_broadcast__DEFAULT
#define R_NETWORK_REC_CONFIG__tr_broadcast__DEFAULT discard
#endif

/* discard receive */
#ifndef R_NETWORK_REC_CONFIG__broadcast__DEFAULT
#define R_NETWORK_REC_CONFIG__broadcast__DEFAULT discard
#endif

/* discard receive */
#ifndef R_NETWORK_REC_CONFIG__individual__DEFAULT
#define R_NETWORK_REC_CONFIG__individual__DEFAULT discard
#endif

/* disable enable */
#ifndef R_NETWORK_REC_CONFIG__ma1__DEFAULT
#define R_NETWORK_REC_CONFIG__ma1__DEFAULT disable
#endif

/* disable enable */
#ifndef R_NETWORK_REC_CONFIG__ma0__DEFAULT
#define R_NETWORK_REC_CONFIG__ma0__DEFAULT disable
#endif

/*
** Default values for register  R_NETWORK_SA_0
*/

/*  0 - 0xffffffff */
#ifndef R_NETWORK_SA_0__ma0_low__DEFAULT
#define R_NETWORK_SA_0__ma0_low__DEFAULT 0
#endif

/*
** Default values for register  R_NETWORK_SA_1
*/

/*  0 - 0xffff */
#ifndef R_NETWORK_SA_1__ma1_low__DEFAULT
#define R_NETWORK_SA_1__ma1_low__DEFAULT 0
#endif

/*  0 - 0xffff */
#ifndef R_NETWORK_SA_1__ma0_high__DEFAULT
#define R_NETWORK_SA_1__ma0_high__DEFAULT 0
#endif

/*
** Default values for register  R_NETWORK_SA_2
*/

/*  0 - 0xffffffff */
#ifndef R_NETWORK_SA_2__ma1_high__DEFAULT
#define R_NETWORK_SA_2__ma1_high__DEFAULT 0
#endif

/*
** Default values for register  R_NETWORK_TR_CTRL
*/

/* clr nop */
#ifndef R_NETWORK_TR_CTRL__clr_error__DEFAULT
#define R_NETWORK_TR_CTRL__clr_error__DEFAULT clr
#endif

/* none d2us */
#ifndef R_NETWORK_TR_CTRL__delay__DEFAULT
#define R_NETWORK_TR_CTRL__delay__DEFAULT none
#endif

/* do dont */
#ifndef R_NETWORK_TR_CTRL__cancel__DEFAULT
#define R_NETWORK_TR_CTRL__cancel__DEFAULT do
#endif

/* ack_col disable ack_crs enable */
#ifndef R_NETWORK_TR_CTRL__cd__DEFAULT
#define R_NETWORK_TR_CTRL__cd__DEFAULT ack_col
#endif

/* disable enable */
#ifndef R_NETWORK_TR_CTRL__retry__DEFAULT
#define R_NETWORK_TR_CTRL__retry__DEFAULT disable
#endif

/* disable enable */
#ifndef R_NETWORK_TR_CTRL__pad__DEFAULT
#define R_NETWORK_TR_CTRL__pad__DEFAULT disable
#endif

/* disable enable */
#ifndef R_NETWORK_TR_CTRL__crc__DEFAULT
#define R_NETWORK_TR_CTRL__crc__DEFAULT disable
#endif

/*
** Default values for register  R_PAR0_CONFIG
*/

/* noninv inv */
#ifndef R_PAR0_CONFIG__ioe__DEFAULT
#define R_PAR0_CONFIG__ioe__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR0_CONFIG__iseli__DEFAULT
#define R_PAR0_CONFIG__iseli__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR0_CONFIG__iautofd__DEFAULT
#define R_PAR0_CONFIG__iautofd__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR0_CONFIG__istrb__DEFAULT
#define R_PAR0_CONFIG__istrb__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR0_CONFIG__iinit__DEFAULT
#define R_PAR0_CONFIG__iinit__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR0_CONFIG__iperr__DEFAULT
#define R_PAR0_CONFIG__iperr__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR0_CONFIG__iack__DEFAULT
#define R_PAR0_CONFIG__iack__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR0_CONFIG__ibusy__DEFAULT
#define R_PAR0_CONFIG__ibusy__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR0_CONFIG__ifault__DEFAULT
#define R_PAR0_CONFIG__ifault__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR0_CONFIG__isel__DEFAULT
#define R_PAR0_CONFIG__isel__DEFAULT noninv
#endif

/* disable enable */
#ifndef R_PAR0_CONFIG__ext_mode__DEFAULT
#define R_PAR0_CONFIG__ext_mode__DEFAULT disable
#endif

/* disable enable */
#ifndef R_PAR0_CONFIG__wide__DEFAULT
#define R_PAR0_CONFIG__wide__DEFAULT disable
#endif

/* disable enable */
#ifndef R_PAR0_CONFIG__dma__DEFAULT
#define R_PAR0_CONFIG__dma__DEFAULT disable
#endif

/* disable enable */
#ifndef R_PAR0_CONFIG__rle_in__DEFAULT
#define R_PAR0_CONFIG__rle_in__DEFAULT disable
#endif

/* disable enable */
#ifndef R_PAR0_CONFIG__rle_out__DEFAULT
#define R_PAR0_CONFIG__rle_out__DEFAULT disable
#endif

/* reset on */
#ifndef R_PAR0_CONFIG__enable__DEFAULT
#define R_PAR0_CONFIG__enable__DEFAULT reset
#endif

/* off on */
#ifndef R_PAR0_CONFIG__force__DEFAULT
#define R_PAR0_CONFIG__force__DEFAULT off
#endif

/* ignore wait */
#ifndef R_PAR0_CONFIG__ign_ack__DEFAULT
#define R_PAR0_CONFIG__ign_ack__DEFAULT ignore
#endif

/* wait_oe dont_wait epp_data epp_addr */
#ifndef R_PAR0_CONFIG__oe_ack__DEFAULT
#define R_PAR0_CONFIG__oe_ack__DEFAULT wait_oe
#endif

/* epp_wr3 fastbyte ecp_rev byte centronics ecp_fwd epp_rd off nibble epp_wr1 manual epp_wr2 */
#ifndef R_PAR0_CONFIG__mode__DEFAULT
#define R_PAR0_CONFIG__mode__DEFAULT epp_wr3
#endif

/*
** Default values for register  R_PAR0_CTRL
*/

/*  0 - 31 */
#ifndef R_PAR0_CTRL__ctrl__DEFAULT
#define R_PAR0_CTRL__ctrl__DEFAULT 0
#endif

/*
** Default values for register  R_PAR0_CTRL_DATA
*/

/* nop ack */
#ifndef R_PAR0_CTRL_DATA__peri_int__DEFAULT
#define R_PAR0_CTRL_DATA__peri_int__DEFAULT nop
#endif

/* disable enable */
#ifndef R_PAR0_CTRL_DATA__oe__DEFAULT
#define R_PAR0_CTRL_DATA__oe__DEFAULT disable
#endif

/* inactive active */
#ifndef R_PAR0_CTRL_DATA__seli__DEFAULT
#define R_PAR0_CTRL_DATA__seli__DEFAULT inactive
#endif

/* inactive active */
#ifndef R_PAR0_CTRL_DATA__autofd__DEFAULT
#define R_PAR0_CTRL_DATA__autofd__DEFAULT inactive
#endif

/* inactive active */
#ifndef R_PAR0_CTRL_DATA__strb__DEFAULT
#define R_PAR0_CTRL_DATA__strb__DEFAULT inactive
#endif

/* inactive active */
#ifndef R_PAR0_CTRL_DATA__init__DEFAULT
#define R_PAR0_CTRL_DATA__init__DEFAULT inactive
#endif

/* data command */
#ifndef R_PAR0_CTRL_DATA__ecp_cmd__DEFAULT
#define R_PAR0_CTRL_DATA__ecp_cmd__DEFAULT data
#endif

/*  0 - 0xff */
#ifndef R_PAR0_CTRL_DATA__data__DEFAULT
#define R_PAR0_CTRL_DATA__data__DEFAULT 0
#endif

/*
** Default values for register  R_PAR0_DELAY
*/

/*  0 - 0x7 */
#ifndef R_PAR0_DELAY__fine_hold__DEFAULT
#define R_PAR0_DELAY__fine_hold__DEFAULT 0
#endif

/*  0 - 0x1f */
#ifndef R_PAR0_DELAY__hold__DEFAULT
#define R_PAR0_DELAY__hold__DEFAULT 0
#endif

/*  0 - 0x7 */
#ifndef R_PAR0_DELAY__fine_strb__DEFAULT
#define R_PAR0_DELAY__fine_strb__DEFAULT 0
#endif

/*  0 - 0x1f */
#ifndef R_PAR0_DELAY__strobe__DEFAULT
#define R_PAR0_DELAY__strobe__DEFAULT 0
#endif

/*  0 - 0x7 */
#ifndef R_PAR0_DELAY__fine_setup__DEFAULT
#define R_PAR0_DELAY__fine_setup__DEFAULT 0
#endif

/*  0 - 0x1f */
#ifndef R_PAR0_DELAY__setup__DEFAULT
#define R_PAR0_DELAY__setup__DEFAULT 0
#endif

/*
** Default values for register  R_PAR1_CONFIG
*/

/* noninv inv */
#ifndef R_PAR1_CONFIG__ioe__DEFAULT
#define R_PAR1_CONFIG__ioe__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR1_CONFIG__iseli__DEFAULT
#define R_PAR1_CONFIG__iseli__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR1_CONFIG__iautofd__DEFAULT
#define R_PAR1_CONFIG__iautofd__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR1_CONFIG__istrb__DEFAULT
#define R_PAR1_CONFIG__istrb__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR1_CONFIG__iinit__DEFAULT
#define R_PAR1_CONFIG__iinit__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR1_CONFIG__iperr__DEFAULT
#define R_PAR1_CONFIG__iperr__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR1_CONFIG__iack__DEFAULT
#define R_PAR1_CONFIG__iack__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR1_CONFIG__ibusy__DEFAULT
#define R_PAR1_CONFIG__ibusy__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR1_CONFIG__ifault__DEFAULT
#define R_PAR1_CONFIG__ifault__DEFAULT noninv
#endif

/* noninv inv */
#ifndef R_PAR1_CONFIG__isel__DEFAULT
#define R_PAR1_CONFIG__isel__DEFAULT noninv
#endif

/* disable enable */
#ifndef R_PAR1_CONFIG__ext_mode__DEFAULT
#define R_PAR1_CONFIG__ext_mode__DEFAULT disable
#endif

/* disable enable */
#ifndef R_PAR1_CONFIG__dma__DEFAULT
#define R_PAR1_CONFIG__dma__DEFAULT disable
#endif

/* disable enable */
#ifndef R_PAR1_CONFIG__rle_in__DEFAULT
#define R_PAR1_CONFIG__rle_in__DEFAULT disable
#endif

/* disable enable */
#ifndef R_PAR1_CONFIG__rle_out__DEFAULT
#define R_PAR1_CONFIG__rle_out__DEFAULT disable
#endif

/* reset on */
#ifndef R_PAR1_CONFIG__enable__DEFAULT
#define R_PAR1_CONFIG__enable__DEFAULT reset
#endif

/* off on */
#ifndef R_PAR1_CONFIG__force__DEFAULT
#define R_PAR1_CONFIG__force__DEFAULT off
#endif

/* ignore wait */
#ifndef R_PAR1_CONFIG__ign_ack__DEFAULT
#define R_PAR1_CONFIG__ign_ack__DEFAULT ignore
#endif

/* wait_oe dont_wait epp_data epp_addr */
#ifndef R_PAR1_CONFIG__oe_ack__DEFAULT
#define R_PAR1_CONFIG__oe_ack__DEFAULT wait_oe
#endif

/* epp_wr3 fastbyte ecp_rev byte centronics ecp_fwd epp_rd off nibble epp_wr1 manual epp_wr2 */
#ifndef R_PAR1_CONFIG__mode__DEFAULT
#define R_PAR1_CONFIG__mode__DEFAULT epp_wr3
#endif

/*
** Default values for register  R_PAR1_CTRL
*/

/*  0 - 31 */
#ifndef R_PAR1_CTRL__ctrl__DEFAULT
#define R_PAR1_CTRL__ctrl__DEFAULT 0
#endif

/*
** Default values for register  R_PAR1_CTRL_DATA
*/

/* nop ack */
#ifndef R_PAR1_CTRL_DATA__peri_int__DEFAULT
#define R_PAR1_CTRL_DATA__peri_int__DEFAULT nop
#endif

/* disable enable */
#ifndef R_PAR1_CTRL_DATA__oe__DEFAULT
#define R_PAR1_CTRL_DATA__oe__DEFAULT disable
#endif

/* inactive active */
#ifndef R_PAR1_CTRL_DATA__seli__DEFAULT
#define R_PAR1_CTRL_DATA__seli__DEFAULT inactive
#endif

/* inactive active */
#ifndef R_PAR1_CTRL_DATA__autofd__DEFAULT
#define R_PAR1_CTRL_DATA__autofd__DEFAULT inactive
#endif

/* inactive active */
#ifndef R_PAR1_CTRL_DATA__strb__DEFAULT
#define R_PAR1_CTRL_DATA__strb__DEFAULT inactive
#endif

/* inactive active */
#ifndef R_PAR1_CTRL_DATA__init__DEFAULT
#define R_PAR1_CTRL_DATA__init__DEFAULT inactive
#endif

/* data command */
#ifndef R_PAR1_CTRL_DATA__ecp_cmd__DEFAULT
#define R_PAR1_CTRL_DATA__ecp_cmd__DEFAULT data
#endif

/*  0 - 0xff */
#ifndef R_PAR1_CTRL_DATA__data__DEFAULT
#define R_PAR1_CTRL_DATA__data__DEFAULT 0
#endif

/*
** Default values for register  R_PAR1_DELAY
*/

/*  0 - 0x7 */
#ifndef R_PAR1_DELAY__fine_hold__DEFAULT
#define R_PAR1_DELAY__fine_hold__DEFAULT 0
#endif

/*  0 - 0x1f */
#ifndef R_PAR1_DELAY__hold__DEFAULT
#define R_PAR1_DELAY__hold__DEFAULT 0
#endif

/*  0 - 0x7 */
#ifndef R_PAR1_DELAY__fine_strb__DEFAULT
#define R_PAR1_DELAY__fine_strb__DEFAULT 0
#endif

/*  0 - 0x1f */
#ifndef R_PAR1_DELAY__strobe__DEFAULT
#define R_PAR1_DELAY__strobe__DEFAULT 0
#endif

/*  0 - 0x7 */
#ifndef R_PAR1_DELAY__fine_setup__DEFAULT
#define R_PAR1_DELAY__fine_setup__DEFAULT 0
#endif

/*  0 - 0x1f */
#ifndef R_PAR1_DELAY__setup__DEFAULT
#define R_PAR1_DELAY__setup__DEFAULT 0
#endif

/*
** Default values for register  R_PORT_PA_DATA
*/

/*  0 - 255 */
#ifndef R_PORT_PA_DATA__data_out__DEFAULT
#define R_PORT_PA_DATA__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_PORT_PA_DIR
*/

/* input output */
#ifndef R_PORT_PA_DIR__dir7__DEFAULT
#define R_PORT_PA_DIR__dir7__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PA_DIR__dir6__DEFAULT
#define R_PORT_PA_DIR__dir6__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PA_DIR__dir5__DEFAULT
#define R_PORT_PA_DIR__dir5__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PA_DIR__dir4__DEFAULT
#define R_PORT_PA_DIR__dir4__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PA_DIR__dir3__DEFAULT
#define R_PORT_PA_DIR__dir3__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PA_DIR__dir2__DEFAULT
#define R_PORT_PA_DIR__dir2__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PA_DIR__dir1__DEFAULT
#define R_PORT_PA_DIR__dir1__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PA_DIR__dir0__DEFAULT
#define R_PORT_PA_DIR__dir0__DEFAULT input
#endif

/*
** Default values for register  R_PORT_PA_SET
*/

/* input output */
#ifndef R_PORT_PA_SET__dir7__DEFAULT
#define R_PORT_PA_SET__dir7__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PA_SET__dir6__DEFAULT
#define R_PORT_PA_SET__dir6__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PA_SET__dir5__DEFAULT
#define R_PORT_PA_SET__dir5__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PA_SET__dir4__DEFAULT
#define R_PORT_PA_SET__dir4__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PA_SET__dir3__DEFAULT
#define R_PORT_PA_SET__dir3__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PA_SET__dir2__DEFAULT
#define R_PORT_PA_SET__dir2__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PA_SET__dir1__DEFAULT
#define R_PORT_PA_SET__dir1__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PA_SET__dir0__DEFAULT
#define R_PORT_PA_SET__dir0__DEFAULT input
#endif

/*  0 - 255 */
#ifndef R_PORT_PA_SET__data_out__DEFAULT
#define R_PORT_PA_SET__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_PORT_PB_CONFIG
*/

/* port cs */
#ifndef R_PORT_PB_CONFIG__cs7__DEFAULT
#define R_PORT_PB_CONFIG__cs7__DEFAULT port
#endif

/* port cs */
#ifndef R_PORT_PB_CONFIG__cs6__DEFAULT
#define R_PORT_PB_CONFIG__cs6__DEFAULT port
#endif

/* port cs */
#ifndef R_PORT_PB_CONFIG__cs5__DEFAULT
#define R_PORT_PB_CONFIG__cs5__DEFAULT port
#endif

/* port cs */
#ifndef R_PORT_PB_CONFIG__cs4__DEFAULT
#define R_PORT_PB_CONFIG__cs4__DEFAULT port
#endif

/* port cs */
#ifndef R_PORT_PB_CONFIG__cs3__DEFAULT
#define R_PORT_PB_CONFIG__cs3__DEFAULT port
#endif

/* port cs */
#ifndef R_PORT_PB_CONFIG__cs2__DEFAULT
#define R_PORT_PB_CONFIG__cs2__DEFAULT port
#endif

/* port_cs enph */
#ifndef R_PORT_PB_CONFIG__scsi1__DEFAULT
#define R_PORT_PB_CONFIG__scsi1__DEFAULT port_cs
#endif

/* port_cs enph */
#ifndef R_PORT_PB_CONFIG__scsi0__DEFAULT
#define R_PORT_PB_CONFIG__scsi0__DEFAULT port_cs
#endif

/*
** Default values for register  R_PORT_PB_DATA
*/

/*  0 - 255 */
#ifndef R_PORT_PB_DATA__data_out__DEFAULT
#define R_PORT_PB_DATA__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_PORT_PB_DIR
*/

/* input output */
#ifndef R_PORT_PB_DIR__dir7__DEFAULT
#define R_PORT_PB_DIR__dir7__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PB_DIR__dir6__DEFAULT
#define R_PORT_PB_DIR__dir6__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PB_DIR__dir5__DEFAULT
#define R_PORT_PB_DIR__dir5__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PB_DIR__dir4__DEFAULT
#define R_PORT_PB_DIR__dir4__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PB_DIR__dir3__DEFAULT
#define R_PORT_PB_DIR__dir3__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PB_DIR__dir2__DEFAULT
#define R_PORT_PB_DIR__dir2__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PB_DIR__dir1__DEFAULT
#define R_PORT_PB_DIR__dir1__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PB_DIR__dir0__DEFAULT
#define R_PORT_PB_DIR__dir0__DEFAULT input
#endif

/*
** Default values for register  R_PORT_PB_I2C
*/

/* port_cs ss3extra */
#ifndef R_PORT_PB_I2C__syncser3__DEFAULT
#define R_PORT_PB_I2C__syncser3__DEFAULT port_cs
#endif

/* port_cs ss1extra */
#ifndef R_PORT_PB_I2C__syncser1__DEFAULT
#define R_PORT_PB_I2C__syncser1__DEFAULT port_cs
#endif

/* off on */
#ifndef R_PORT_PB_I2C__i2c_en__DEFAULT
#define R_PORT_PB_I2C__i2c_en__DEFAULT off
#endif

/*  0 - 1 */
#ifndef R_PORT_PB_I2C__i2c_d__DEFAULT
#define R_PORT_PB_I2C__i2c_d__DEFAULT 0
#endif

/*  0 - 1 */
#ifndef R_PORT_PB_I2C__i2c_clk__DEFAULT
#define R_PORT_PB_I2C__i2c_clk__DEFAULT 0
#endif

/* disable enable */
#ifndef R_PORT_PB_I2C__i2c_oe___DEFAULT
#define R_PORT_PB_I2C__i2c_oe___DEFAULT disable
#endif

/*
** Default values for register  R_PORT_PB_SET
*/

/* port_cs ss3extra */
#ifndef R_PORT_PB_SET__syncser3__DEFAULT
#define R_PORT_PB_SET__syncser3__DEFAULT port_cs
#endif

/* port_cs ss1extra */
#ifndef R_PORT_PB_SET__syncser1__DEFAULT
#define R_PORT_PB_SET__syncser1__DEFAULT port_cs
#endif

/* off on */
#ifndef R_PORT_PB_SET__i2c_en__DEFAULT
#define R_PORT_PB_SET__i2c_en__DEFAULT off
#endif

/*  0 - 1 */
#ifndef R_PORT_PB_SET__i2c_d__DEFAULT
#define R_PORT_PB_SET__i2c_d__DEFAULT 0
#endif

/*  0 - 1 */
#ifndef R_PORT_PB_SET__i2c_clk__DEFAULT
#define R_PORT_PB_SET__i2c_clk__DEFAULT 0
#endif

/* disable enable */
#ifndef R_PORT_PB_SET__i2c_oe___DEFAULT
#define R_PORT_PB_SET__i2c_oe___DEFAULT disable
#endif

/* port cs */
#ifndef R_PORT_PB_SET__cs7__DEFAULT
#define R_PORT_PB_SET__cs7__DEFAULT port
#endif

/* port cs */
#ifndef R_PORT_PB_SET__cs6__DEFAULT
#define R_PORT_PB_SET__cs6__DEFAULT port
#endif

/* port cs */
#ifndef R_PORT_PB_SET__cs5__DEFAULT
#define R_PORT_PB_SET__cs5__DEFAULT port
#endif

/* port cs */
#ifndef R_PORT_PB_SET__cs4__DEFAULT
#define R_PORT_PB_SET__cs4__DEFAULT port
#endif

/* port cs */
#ifndef R_PORT_PB_SET__cs3__DEFAULT
#define R_PORT_PB_SET__cs3__DEFAULT port
#endif

/* port cs */
#ifndef R_PORT_PB_SET__cs2__DEFAULT
#define R_PORT_PB_SET__cs2__DEFAULT port
#endif

/* port_cs enph */
#ifndef R_PORT_PB_SET__scsi1__DEFAULT
#define R_PORT_PB_SET__scsi1__DEFAULT port_cs
#endif

/* port_cs enph */
#ifndef R_PORT_PB_SET__scsi0__DEFAULT
#define R_PORT_PB_SET__scsi0__DEFAULT port_cs
#endif

/* input output */
#ifndef R_PORT_PB_SET__dir7__DEFAULT
#define R_PORT_PB_SET__dir7__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PB_SET__dir6__DEFAULT
#define R_PORT_PB_SET__dir6__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PB_SET__dir5__DEFAULT
#define R_PORT_PB_SET__dir5__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PB_SET__dir4__DEFAULT
#define R_PORT_PB_SET__dir4__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PB_SET__dir3__DEFAULT
#define R_PORT_PB_SET__dir3__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PB_SET__dir2__DEFAULT
#define R_PORT_PB_SET__dir2__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PB_SET__dir1__DEFAULT
#define R_PORT_PB_SET__dir1__DEFAULT input
#endif

/* input output */
#ifndef R_PORT_PB_SET__dir0__DEFAULT
#define R_PORT_PB_SET__dir0__DEFAULT input
#endif

/*  0 - 255 */
#ifndef R_PORT_PB_SET__data_out__DEFAULT
#define R_PORT_PB_SET__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SCSI0_CMD
*/

/*  0 - 0xf */
#ifndef R_SCSI0_CMD__asynch_setup__DEFAULT
#define R_SCSI0_CMD__asynch_setup__DEFAULT 0
#endif

/* full_stat_3 full_dout_3 man_rat resel_din arb_only resel_stat resel_dout man_data_in man_data_out full_din_1 full_dout_1 full_stat_1 full_din_3 */
#ifndef R_SCSI0_CMD__command__DEFAULT
#define R_SCSI0_CMD__command__DEFAULT full_stat_3
#endif

/*
** Default values for register  R_SCSI0_CMD_DATA
*/

/* off on */
#ifndef R_SCSI0_CMD_DATA__parity_in__DEFAULT
#define R_SCSI0_CMD_DATA__parity_in__DEFAULT off
#endif

/* off on */
#ifndef R_SCSI0_CMD_DATA__skip__DEFAULT
#define R_SCSI0_CMD_DATA__skip__DEFAULT off
#endif

/* yes nop */
#ifndef R_SCSI0_CMD_DATA__clr_status__DEFAULT
#define R_SCSI0_CMD_DATA__clr_status__DEFAULT yes
#endif

/*  0 - 0xf */
#ifndef R_SCSI0_CMD_DATA__asynch_setup__DEFAULT
#define R_SCSI0_CMD_DATA__asynch_setup__DEFAULT 0
#endif

/* full_stat_3 full_dout_3 man_rat resel_din arb_only resel_stat resel_dout man_data_in man_data_out full_din_1 full_dout_1 full_stat_1 full_din_3 */
#ifndef R_SCSI0_CMD_DATA__command__DEFAULT
#define R_SCSI0_CMD_DATA__command__DEFAULT full_stat_3
#endif

/*  0 - 0xffff */
#ifndef R_SCSI0_CMD_DATA__data_out__DEFAULT
#define R_SCSI0_CMD_DATA__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SCSI0_CTRL
*/

/* software hardware */
#ifndef R_SCSI0_CTRL__id_type__DEFAULT
#define R_SCSI0_CTRL__id_type__DEFAULT software
#endif

/*  0 - 0x7f */
#ifndef R_SCSI0_CTRL__sel_timeout__DEFAULT
#define R_SCSI0_CTRL__sel_timeout__DEFAULT 0
#endif

/*  0 - 0xff */
#ifndef R_SCSI0_CTRL__synch_per__DEFAULT
#define R_SCSI0_CTRL__synch_per__DEFAULT 0
#endif

/* yes no */
#ifndef R_SCSI0_CTRL__rst__DEFAULT
#define R_SCSI0_CTRL__rst__DEFAULT yes
#endif

/* yes no */
#ifndef R_SCSI0_CTRL__atn__DEFAULT
#define R_SCSI0_CTRL__atn__DEFAULT yes
#endif

/*  0 - 0xf */
#ifndef R_SCSI0_CTRL__my_id__DEFAULT
#define R_SCSI0_CTRL__my_id__DEFAULT 0
#endif

/*  0 - 0xf */
#ifndef R_SCSI0_CTRL__target_id__DEFAULT
#define R_SCSI0_CTRL__target_id__DEFAULT 0
#endif

/* yes no */
#ifndef R_SCSI0_CTRL__fast_20__DEFAULT
#define R_SCSI0_CTRL__fast_20__DEFAULT yes
#endif

/* narrow wide */
#ifndef R_SCSI0_CTRL__bus_width__DEFAULT
#define R_SCSI0_CTRL__bus_width__DEFAULT narrow
#endif

/* synch asynch */
#ifndef R_SCSI0_CTRL__synch__DEFAULT
#define R_SCSI0_CTRL__synch__DEFAULT synch
#endif

/* off on */
#ifndef R_SCSI0_CTRL__enable__DEFAULT
#define R_SCSI0_CTRL__enable__DEFAULT off
#endif

/*
** Default values for register  R_SCSI0_DATA
*/

/*  0 - 0xffff */
#ifndef R_SCSI0_DATA__data_out__DEFAULT
#define R_SCSI0_DATA__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SCSI0_STATUS_CTRL
*/

/* off on */
#ifndef R_SCSI0_STATUS_CTRL__parity_in__DEFAULT
#define R_SCSI0_STATUS_CTRL__parity_in__DEFAULT off
#endif

/* off on */
#ifndef R_SCSI0_STATUS_CTRL__skip__DEFAULT
#define R_SCSI0_STATUS_CTRL__skip__DEFAULT off
#endif

/* yes nop */
#ifndef R_SCSI0_STATUS_CTRL__clr_status__DEFAULT
#define R_SCSI0_STATUS_CTRL__clr_status__DEFAULT yes
#endif

/*
** Default values for register  R_SCSI1_CMD
*/

/*  0 - 0xf */
#ifndef R_SCSI1_CMD__asynch_setup__DEFAULT
#define R_SCSI1_CMD__asynch_setup__DEFAULT 0
#endif

/* full_stat_3 full_dout_3 man_rat resel_din arb_only resel_stat resel_dout man_data_in man_data_out full_din_1 full_dout_1 full_stat_1 full_din_3 */
#ifndef R_SCSI1_CMD__command__DEFAULT
#define R_SCSI1_CMD__command__DEFAULT full_stat_3
#endif

/*
** Default values for register  R_SCSI1_CMD_DATA
*/

/* off on */
#ifndef R_SCSI1_CMD_DATA__parity_in__DEFAULT
#define R_SCSI1_CMD_DATA__parity_in__DEFAULT off
#endif

/* off on */
#ifndef R_SCSI1_CMD_DATA__skip__DEFAULT
#define R_SCSI1_CMD_DATA__skip__DEFAULT off
#endif

/* yes nop */
#ifndef R_SCSI1_CMD_DATA__clr_status__DEFAULT
#define R_SCSI1_CMD_DATA__clr_status__DEFAULT yes
#endif

/*  0 - 0xf */
#ifndef R_SCSI1_CMD_DATA__asynch_setup__DEFAULT
#define R_SCSI1_CMD_DATA__asynch_setup__DEFAULT 0
#endif

/* full_stat_3 full_dout_3 man_rat resel_din arb_only resel_stat resel_dout man_data_in man_data_out full_din_1 full_dout_1 full_stat_1 full_din_3 */
#ifndef R_SCSI1_CMD_DATA__command__DEFAULT
#define R_SCSI1_CMD_DATA__command__DEFAULT full_stat_3
#endif

/*  0 - 0xffff */
#ifndef R_SCSI1_CMD_DATA__data_out__DEFAULT
#define R_SCSI1_CMD_DATA__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SCSI1_CTRL
*/

/* software hardware */
#ifndef R_SCSI1_CTRL__id_type__DEFAULT
#define R_SCSI1_CTRL__id_type__DEFAULT software
#endif

/*  0 - 0x7f */
#ifndef R_SCSI1_CTRL__sel_timeout__DEFAULT
#define R_SCSI1_CTRL__sel_timeout__DEFAULT 0
#endif

/*  0 - 0xff */
#ifndef R_SCSI1_CTRL__synch_per__DEFAULT
#define R_SCSI1_CTRL__synch_per__DEFAULT 0
#endif

/* yes no */
#ifndef R_SCSI1_CTRL__rst__DEFAULT
#define R_SCSI1_CTRL__rst__DEFAULT yes
#endif

/* yes no */
#ifndef R_SCSI1_CTRL__atn__DEFAULT
#define R_SCSI1_CTRL__atn__DEFAULT yes
#endif

/*  0 - 0xf */
#ifndef R_SCSI1_CTRL__my_id__DEFAULT
#define R_SCSI1_CTRL__my_id__DEFAULT 0
#endif

/*  0 - 0xf */
#ifndef R_SCSI1_CTRL__target_id__DEFAULT
#define R_SCSI1_CTRL__target_id__DEFAULT 0
#endif

/* yes no */
#ifndef R_SCSI1_CTRL__fast_20__DEFAULT
#define R_SCSI1_CTRL__fast_20__DEFAULT yes
#endif

/* narrow wide */
#ifndef R_SCSI1_CTRL__bus_width__DEFAULT
#define R_SCSI1_CTRL__bus_width__DEFAULT narrow
#endif

/* synch asynch */
#ifndef R_SCSI1_CTRL__synch__DEFAULT
#define R_SCSI1_CTRL__synch__DEFAULT synch
#endif

/* off on */
#ifndef R_SCSI1_CTRL__enable__DEFAULT
#define R_SCSI1_CTRL__enable__DEFAULT off
#endif

/*
** Default values for register  R_SCSI1_DATA
*/

/*  0 - 0xffff */
#ifndef R_SCSI1_DATA__data_out__DEFAULT
#define R_SCSI1_DATA__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SCSI1_STATUS_CTRL
*/

/* off on */
#ifndef R_SCSI1_STATUS_CTRL__parity_in__DEFAULT
#define R_SCSI1_STATUS_CTRL__parity_in__DEFAULT off
#endif

/* off on */
#ifndef R_SCSI1_STATUS_CTRL__skip__DEFAULT
#define R_SCSI1_STATUS_CTRL__skip__DEFAULT off
#endif

/* yes nop */
#ifndef R_SCSI1_STATUS_CTRL__clr_status__DEFAULT
#define R_SCSI1_STATUS_CTRL__clr_status__DEFAULT yes
#endif

/*
** Default values for register  R_SDRAM_CONFIG
*/

/* wmm norm */
#ifndef R_SDRAM_CONFIG__wmm1__DEFAULT
#define R_SDRAM_CONFIG__wmm1__DEFAULT wmm
#endif

/* wmm norm */
#ifndef R_SDRAM_CONFIG__wmm0__DEFAULT
#define R_SDRAM_CONFIG__wmm0__DEFAULT wmm
#endif

/*  0 - 7 */
#ifndef R_SDRAM_CONFIG__sh1__DEFAULT
#define R_SDRAM_CONFIG__sh1__DEFAULT 0
#endif

/*  0 - 7 */
#ifndef R_SDRAM_CONFIG__sh0__DEFAULT
#define R_SDRAM_CONFIG__sh0__DEFAULT 0
#endif

/* bw16 bw32 */
#ifndef R_SDRAM_CONFIG__w__DEFAULT
#define R_SDRAM_CONFIG__w__DEFAULT bw16
#endif

/* bank4 bank2 */
#ifndef R_SDRAM_CONFIG__type1__DEFAULT
#define R_SDRAM_CONFIG__type1__DEFAULT bank4
#endif

/* bank4 bank2 */
#ifndef R_SDRAM_CONFIG__type0__DEFAULT
#define R_SDRAM_CONFIG__type0__DEFAULT bank4
#endif

/* bit10 bit20 bit11 bit21 bit12 bit22 bit13 bit23 bit14 bit24 bit15 bit25 bit16 bit26 bit17 bit27 bit18 bit9 bit28 bit19 grp0 bit29 grp1 */
#ifndef R_SDRAM_CONFIG__group_sel__DEFAULT
#define R_SDRAM_CONFIG__group_sel__DEFAULT bit10
#endif

/*  0 - 7 */
#ifndef R_SDRAM_CONFIG__ca1__DEFAULT
#define R_SDRAM_CONFIG__ca1__DEFAULT 0
#endif

/* bit10 bit20 bit11 bit21 bit12 bit22 bit13 bit23 bit14 bit24 bit15 bit25 bit16 bit26 bit17 bit27 bit18 bit28 bit19 bit29 bit9 */
#ifndef R_SDRAM_CONFIG__bank_sel1__DEFAULT
#define R_SDRAM_CONFIG__bank_sel1__DEFAULT bit10
#endif

/*  0 - 7 */
#ifndef R_SDRAM_CONFIG__ca0__DEFAULT
#define R_SDRAM_CONFIG__ca0__DEFAULT 0
#endif

/* bit10 bit20 bit11 bit21 bit12 bit22 bit13 bit23 bit14 bit24 bit15 bit25 bit16 bit26 bit17 bit27 bit18 bit28 bit19 bit29 bit9 */
#ifndef R_SDRAM_CONFIG__bank_sel0__DEFAULT
#define R_SDRAM_CONFIG__bank_sel0__DEFAULT bit10
#endif

/*
** Default values for register  R_SDRAM_TIMING
*/

/* disable enable */
#ifndef R_SDRAM_TIMING__sdram__DEFAULT
#define R_SDRAM_TIMING__sdram__DEFAULT disable
#endif

/*  0 - 0x7fff */
#ifndef R_SDRAM_TIMING__mrs_data__DEFAULT
#define R_SDRAM_TIMING__mrs_data__DEFAULT 0
#endif

/* e6500ns e13us disable e52us */
#ifndef R_SDRAM_TIMING__ref__DEFAULT
#define R_SDRAM_TIMING__ref__DEFAULT e6500ns
#endif

/* off on */
#ifndef R_SDRAM_TIMING__ddr__DEFAULT
#define R_SDRAM_TIMING__ddr__DEFAULT off
#endif

/* off on */
#ifndef R_SDRAM_TIMING__clk100__DEFAULT
#define R_SDRAM_TIMING__clk100__DEFAULT off
#endif

/* off on */
#ifndef R_SDRAM_TIMING__ps__DEFAULT
#define R_SDRAM_TIMING__ps__DEFAULT off
#endif

/* mrs nop ref pre */
#ifndef R_SDRAM_TIMING__cmd__DEFAULT
#define R_SDRAM_TIMING__cmd__DEFAULT mrs
#endif

/*  0 - 1 */
#ifndef R_SDRAM_TIMING__pde__DEFAULT
#define R_SDRAM_TIMING__pde__DEFAULT 0
#endif

/*  0 - 3 */
#ifndef R_SDRAM_TIMING__rc__DEFAULT
#define R_SDRAM_TIMING__rc__DEFAULT 0
#endif

/*  0 - 3 */
#ifndef R_SDRAM_TIMING__rp__DEFAULT
#define R_SDRAM_TIMING__rp__DEFAULT 0
#endif

/*  0 - 3 */
#ifndef R_SDRAM_TIMING__rcd__DEFAULT
#define R_SDRAM_TIMING__rcd__DEFAULT 0
#endif

/*  0 - 2 */
#ifndef R_SDRAM_TIMING__cl__DEFAULT
#define R_SDRAM_TIMING__cl__DEFAULT 0
#endif

/*
** Default values for register  R_SERIAL0_BAUD
*/

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_SERIAL0_BAUD__tr_baud__DEFAULT
#define R_SERIAL0_BAUD__tr_baud__DEFAULT c4800Hz
#endif

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_SERIAL0_BAUD__rec_baud__DEFAULT
#define R_SERIAL0_BAUD__rec_baud__DEFAULT c4800Hz
#endif

/*
** Default values for register  R_SERIAL0_CTRL
*/

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_SERIAL0_CTRL__tr_baud__DEFAULT
#define R_SERIAL0_CTRL__tr_baud__DEFAULT c4800Hz
#endif

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_SERIAL0_CTRL__rec_baud__DEFAULT
#define R_SERIAL0_CTRL__rec_baud__DEFAULT c4800Hz
#endif

/* ignore stop */
#ifndef R_SERIAL0_CTRL__dma_err__DEFAULT
#define R_SERIAL0_CTRL__dma_err__DEFAULT ignore
#endif

/* disable enable */
#ifndef R_SERIAL0_CTRL__rec_enable__DEFAULT
#define R_SERIAL0_CTRL__rec_enable__DEFAULT disable
#endif

/* inactive active */
#ifndef R_SERIAL0_CTRL__rts___DEFAULT
#define R_SERIAL0_CTRL__rts___DEFAULT inactive
#endif

/* majority middle */
#ifndef R_SERIAL0_CTRL__sampling__DEFAULT
#define R_SERIAL0_CTRL__sampling__DEFAULT majority
#endif

/* normal stick */
#ifndef R_SERIAL0_CTRL__rec_stick_par__DEFAULT
#define R_SERIAL0_CTRL__rec_stick_par__DEFAULT normal
#endif

/* even odd */
#ifndef R_SERIAL0_CTRL__rec_par__DEFAULT
#define R_SERIAL0_CTRL__rec_par__DEFAULT even
#endif

/* disable enable */
#ifndef R_SERIAL0_CTRL__rec_par_en__DEFAULT
#define R_SERIAL0_CTRL__rec_par_en__DEFAULT disable
#endif

/* rec_8bit rec_7bit */
#ifndef R_SERIAL0_CTRL__rec_bitnr__DEFAULT
#define R_SERIAL0_CTRL__rec_bitnr__DEFAULT rec_8bit
#endif

/*  0 - 0x1 */
#ifndef R_SERIAL0_CTRL__txd__DEFAULT
#define R_SERIAL0_CTRL__txd__DEFAULT 0
#endif

/* disable enable */
#ifndef R_SERIAL0_CTRL__tr_enable__DEFAULT
#define R_SERIAL0_CTRL__tr_enable__DEFAULT disable
#endif

/* disabled active */
#ifndef R_SERIAL0_CTRL__auto_cts__DEFAULT
#define R_SERIAL0_CTRL__auto_cts__DEFAULT disabled
#endif

/* one_bit two_bits */
#ifndef R_SERIAL0_CTRL__stop_bits__DEFAULT
#define R_SERIAL0_CTRL__stop_bits__DEFAULT one_bit
#endif

/* normal stick */
#ifndef R_SERIAL0_CTRL__tr_stick_par__DEFAULT
#define R_SERIAL0_CTRL__tr_stick_par__DEFAULT normal
#endif

/* even odd */
#ifndef R_SERIAL0_CTRL__tr_par__DEFAULT
#define R_SERIAL0_CTRL__tr_par__DEFAULT even
#endif

/* disable enable */
#ifndef R_SERIAL0_CTRL__tr_par_en__DEFAULT
#define R_SERIAL0_CTRL__tr_par_en__DEFAULT disable
#endif

/* tr_7bit tr_8bit */
#ifndef R_SERIAL0_CTRL__tr_bitnr__DEFAULT
#define R_SERIAL0_CTRL__tr_bitnr__DEFAULT tr_7bit
#endif

/*  0 - 0xff */
#ifndef R_SERIAL0_CTRL__data_out__DEFAULT
#define R_SERIAL0_CTRL__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SERIAL0_REC_CTRL
*/

/* ignore stop */
#ifndef R_SERIAL0_REC_CTRL__dma_err__DEFAULT
#define R_SERIAL0_REC_CTRL__dma_err__DEFAULT ignore
#endif

/* disable enable */
#ifndef R_SERIAL0_REC_CTRL__rec_enable__DEFAULT
#define R_SERIAL0_REC_CTRL__rec_enable__DEFAULT disable
#endif

/* inactive active */
#ifndef R_SERIAL0_REC_CTRL__rts___DEFAULT
#define R_SERIAL0_REC_CTRL__rts___DEFAULT inactive
#endif

/* majority middle */
#ifndef R_SERIAL0_REC_CTRL__sampling__DEFAULT
#define R_SERIAL0_REC_CTRL__sampling__DEFAULT majority
#endif

/* normal stick */
#ifndef R_SERIAL0_REC_CTRL__rec_stick_par__DEFAULT
#define R_SERIAL0_REC_CTRL__rec_stick_par__DEFAULT normal
#endif

/* even odd */
#ifndef R_SERIAL0_REC_CTRL__rec_par__DEFAULT
#define R_SERIAL0_REC_CTRL__rec_par__DEFAULT even
#endif

/* disable enable */
#ifndef R_SERIAL0_REC_CTRL__rec_par_en__DEFAULT
#define R_SERIAL0_REC_CTRL__rec_par_en__DEFAULT disable
#endif

/* rec_8bit rec_7bit */
#ifndef R_SERIAL0_REC_CTRL__rec_bitnr__DEFAULT
#define R_SERIAL0_REC_CTRL__rec_bitnr__DEFAULT rec_8bit
#endif

/*
** Default values for register  R_SERIAL0_TR_CTRL
*/

/*  0 - 0x1 */
#ifndef R_SERIAL0_TR_CTRL__txd__DEFAULT
#define R_SERIAL0_TR_CTRL__txd__DEFAULT 0
#endif

/* disable enable */
#ifndef R_SERIAL0_TR_CTRL__tr_enable__DEFAULT
#define R_SERIAL0_TR_CTRL__tr_enable__DEFAULT disable
#endif

/* disabled active */
#ifndef R_SERIAL0_TR_CTRL__auto_cts__DEFAULT
#define R_SERIAL0_TR_CTRL__auto_cts__DEFAULT disabled
#endif

/* one_bit two_bits */
#ifndef R_SERIAL0_TR_CTRL__stop_bits__DEFAULT
#define R_SERIAL0_TR_CTRL__stop_bits__DEFAULT one_bit
#endif

/* normal stick */
#ifndef R_SERIAL0_TR_CTRL__tr_stick_par__DEFAULT
#define R_SERIAL0_TR_CTRL__tr_stick_par__DEFAULT normal
#endif

/* even odd */
#ifndef R_SERIAL0_TR_CTRL__tr_par__DEFAULT
#define R_SERIAL0_TR_CTRL__tr_par__DEFAULT even
#endif

/* disable enable */
#ifndef R_SERIAL0_TR_CTRL__tr_par_en__DEFAULT
#define R_SERIAL0_TR_CTRL__tr_par_en__DEFAULT disable
#endif

/* tr_7bit tr_8bit */
#ifndef R_SERIAL0_TR_CTRL__tr_bitnr__DEFAULT
#define R_SERIAL0_TR_CTRL__tr_bitnr__DEFAULT tr_7bit
#endif

/*
** Default values for register  R_SERIAL0_TR_DATA
*/

/*  0 - 0xff */
#ifndef R_SERIAL0_TR_DATA__data_out__DEFAULT
#define R_SERIAL0_TR_DATA__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SERIAL0_XOFF
*/

/* stop enable */
#ifndef R_SERIAL0_XOFF__tx_stop__DEFAULT
#define R_SERIAL0_XOFF__tx_stop__DEFAULT stop
#endif

/* disable enable */
#ifndef R_SERIAL0_XOFF__auto_xoff__DEFAULT
#define R_SERIAL0_XOFF__auto_xoff__DEFAULT disable
#endif

/*  0 - 0xff */
#ifndef R_SERIAL0_XOFF__xoff_char__DEFAULT
#define R_SERIAL0_XOFF__xoff_char__DEFAULT 0
#endif

/*
** Default values for register  R_SERIAL1_BAUD
*/

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_SERIAL1_BAUD__tr_baud__DEFAULT
#define R_SERIAL1_BAUD__tr_baud__DEFAULT c4800Hz
#endif

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_SERIAL1_BAUD__rec_baud__DEFAULT
#define R_SERIAL1_BAUD__rec_baud__DEFAULT c4800Hz
#endif

/*
** Default values for register  R_SERIAL1_CTRL
*/

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_SERIAL1_CTRL__tr_baud__DEFAULT
#define R_SERIAL1_CTRL__tr_baud__DEFAULT c4800Hz
#endif

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_SERIAL1_CTRL__rec_baud__DEFAULT
#define R_SERIAL1_CTRL__rec_baud__DEFAULT c4800Hz
#endif

/* ignore stop */
#ifndef R_SERIAL1_CTRL__dma_err__DEFAULT
#define R_SERIAL1_CTRL__dma_err__DEFAULT ignore
#endif

/* disable enable */
#ifndef R_SERIAL1_CTRL__rec_enable__DEFAULT
#define R_SERIAL1_CTRL__rec_enable__DEFAULT disable
#endif

/* inactive active */
#ifndef R_SERIAL1_CTRL__rts___DEFAULT
#define R_SERIAL1_CTRL__rts___DEFAULT inactive
#endif

/* majority middle */
#ifndef R_SERIAL1_CTRL__sampling__DEFAULT
#define R_SERIAL1_CTRL__sampling__DEFAULT majority
#endif

/* normal stick */
#ifndef R_SERIAL1_CTRL__rec_stick_par__DEFAULT
#define R_SERIAL1_CTRL__rec_stick_par__DEFAULT normal
#endif

/* even odd */
#ifndef R_SERIAL1_CTRL__rec_par__DEFAULT
#define R_SERIAL1_CTRL__rec_par__DEFAULT even
#endif

/* disable enable */
#ifndef R_SERIAL1_CTRL__rec_par_en__DEFAULT
#define R_SERIAL1_CTRL__rec_par_en__DEFAULT disable
#endif

/* rec_8bit rec_7bit */
#ifndef R_SERIAL1_CTRL__rec_bitnr__DEFAULT
#define R_SERIAL1_CTRL__rec_bitnr__DEFAULT rec_8bit
#endif

/*  0 - 0x1 */
#ifndef R_SERIAL1_CTRL__txd__DEFAULT
#define R_SERIAL1_CTRL__txd__DEFAULT 0
#endif

/* disable enable */
#ifndef R_SERIAL1_CTRL__tr_enable__DEFAULT
#define R_SERIAL1_CTRL__tr_enable__DEFAULT disable
#endif

/* disabled active */
#ifndef R_SERIAL1_CTRL__auto_cts__DEFAULT
#define R_SERIAL1_CTRL__auto_cts__DEFAULT disabled
#endif

/* one_bit two_bits */
#ifndef R_SERIAL1_CTRL__stop_bits__DEFAULT
#define R_SERIAL1_CTRL__stop_bits__DEFAULT one_bit
#endif

/* normal stick */
#ifndef R_SERIAL1_CTRL__tr_stick_par__DEFAULT
#define R_SERIAL1_CTRL__tr_stick_par__DEFAULT normal
#endif

/* even odd */
#ifndef R_SERIAL1_CTRL__tr_par__DEFAULT
#define R_SERIAL1_CTRL__tr_par__DEFAULT even
#endif

/* disable enable */
#ifndef R_SERIAL1_CTRL__tr_par_en__DEFAULT
#define R_SERIAL1_CTRL__tr_par_en__DEFAULT disable
#endif

/* tr_7bit tr_8bit */
#ifndef R_SERIAL1_CTRL__tr_bitnr__DEFAULT
#define R_SERIAL1_CTRL__tr_bitnr__DEFAULT tr_7bit
#endif

/*  0 - 0xff */
#ifndef R_SERIAL1_CTRL__data_out__DEFAULT
#define R_SERIAL1_CTRL__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SERIAL1_REC_CTRL
*/

/* ignore stop */
#ifndef R_SERIAL1_REC_CTRL__dma_err__DEFAULT
#define R_SERIAL1_REC_CTRL__dma_err__DEFAULT ignore
#endif

/* disable enable */
#ifndef R_SERIAL1_REC_CTRL__rec_enable__DEFAULT
#define R_SERIAL1_REC_CTRL__rec_enable__DEFAULT disable
#endif

/* inactive active */
#ifndef R_SERIAL1_REC_CTRL__rts___DEFAULT
#define R_SERIAL1_REC_CTRL__rts___DEFAULT inactive
#endif

/* majority middle */
#ifndef R_SERIAL1_REC_CTRL__sampling__DEFAULT
#define R_SERIAL1_REC_CTRL__sampling__DEFAULT majority
#endif

/* normal stick */
#ifndef R_SERIAL1_REC_CTRL__rec_stick_par__DEFAULT
#define R_SERIAL1_REC_CTRL__rec_stick_par__DEFAULT normal
#endif

/* even odd */
#ifndef R_SERIAL1_REC_CTRL__rec_par__DEFAULT
#define R_SERIAL1_REC_CTRL__rec_par__DEFAULT even
#endif

/* disable enable */
#ifndef R_SERIAL1_REC_CTRL__rec_par_en__DEFAULT
#define R_SERIAL1_REC_CTRL__rec_par_en__DEFAULT disable
#endif

/* rec_8bit rec_7bit */
#ifndef R_SERIAL1_REC_CTRL__rec_bitnr__DEFAULT
#define R_SERIAL1_REC_CTRL__rec_bitnr__DEFAULT rec_8bit
#endif

/*
** Default values for register  R_SERIAL1_TR_CTRL
*/

/*  0 - 0x1 */
#ifndef R_SERIAL1_TR_CTRL__txd__DEFAULT
#define R_SERIAL1_TR_CTRL__txd__DEFAULT 0
#endif

/* disable enable */
#ifndef R_SERIAL1_TR_CTRL__tr_enable__DEFAULT
#define R_SERIAL1_TR_CTRL__tr_enable__DEFAULT disable
#endif

/* disabled active */
#ifndef R_SERIAL1_TR_CTRL__auto_cts__DEFAULT
#define R_SERIAL1_TR_CTRL__auto_cts__DEFAULT disabled
#endif

/* one_bit two_bits */
#ifndef R_SERIAL1_TR_CTRL__stop_bits__DEFAULT
#define R_SERIAL1_TR_CTRL__stop_bits__DEFAULT one_bit
#endif

/* normal stick */
#ifndef R_SERIAL1_TR_CTRL__tr_stick_par__DEFAULT
#define R_SERIAL1_TR_CTRL__tr_stick_par__DEFAULT normal
#endif

/* even odd */
#ifndef R_SERIAL1_TR_CTRL__tr_par__DEFAULT
#define R_SERIAL1_TR_CTRL__tr_par__DEFAULT even
#endif

/* disable enable */
#ifndef R_SERIAL1_TR_CTRL__tr_par_en__DEFAULT
#define R_SERIAL1_TR_CTRL__tr_par_en__DEFAULT disable
#endif

/* tr_7bit tr_8bit */
#ifndef R_SERIAL1_TR_CTRL__tr_bitnr__DEFAULT
#define R_SERIAL1_TR_CTRL__tr_bitnr__DEFAULT tr_7bit
#endif

/*
** Default values for register  R_SERIAL1_TR_DATA
*/

/*  0 - 0xff */
#ifndef R_SERIAL1_TR_DATA__data_out__DEFAULT
#define R_SERIAL1_TR_DATA__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SERIAL1_XOFF
*/

/* stop enable */
#ifndef R_SERIAL1_XOFF__tx_stop__DEFAULT
#define R_SERIAL1_XOFF__tx_stop__DEFAULT stop
#endif

/* disable enable */
#ifndef R_SERIAL1_XOFF__auto_xoff__DEFAULT
#define R_SERIAL1_XOFF__auto_xoff__DEFAULT disable
#endif

/*  0 - 0xff */
#ifndef R_SERIAL1_XOFF__xoff_char__DEFAULT
#define R_SERIAL1_XOFF__xoff_char__DEFAULT 0
#endif

/*
** Default values for register  R_SERIAL2_BAUD
*/

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_SERIAL2_BAUD__tr_baud__DEFAULT
#define R_SERIAL2_BAUD__tr_baud__DEFAULT c4800Hz
#endif

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_SERIAL2_BAUD__rec_baud__DEFAULT
#define R_SERIAL2_BAUD__rec_baud__DEFAULT c4800Hz
#endif

/*
** Default values for register  R_SERIAL2_CTRL
*/

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_SERIAL2_CTRL__tr_baud__DEFAULT
#define R_SERIAL2_CTRL__tr_baud__DEFAULT c4800Hz
#endif

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_SERIAL2_CTRL__rec_baud__DEFAULT
#define R_SERIAL2_CTRL__rec_baud__DEFAULT c4800Hz
#endif

/* ignore stop */
#ifndef R_SERIAL2_CTRL__dma_err__DEFAULT
#define R_SERIAL2_CTRL__dma_err__DEFAULT ignore
#endif

/* disable enable */
#ifndef R_SERIAL2_CTRL__rec_enable__DEFAULT
#define R_SERIAL2_CTRL__rec_enable__DEFAULT disable
#endif

/* inactive active */
#ifndef R_SERIAL2_CTRL__rts___DEFAULT
#define R_SERIAL2_CTRL__rts___DEFAULT inactive
#endif

/* majority middle */
#ifndef R_SERIAL2_CTRL__sampling__DEFAULT
#define R_SERIAL2_CTRL__sampling__DEFAULT majority
#endif

/* normal stick */
#ifndef R_SERIAL2_CTRL__rec_stick_par__DEFAULT
#define R_SERIAL2_CTRL__rec_stick_par__DEFAULT normal
#endif

/* even odd */
#ifndef R_SERIAL2_CTRL__rec_par__DEFAULT
#define R_SERIAL2_CTRL__rec_par__DEFAULT even
#endif

/* disable enable */
#ifndef R_SERIAL2_CTRL__rec_par_en__DEFAULT
#define R_SERIAL2_CTRL__rec_par_en__DEFAULT disable
#endif

/* rec_8bit rec_7bit */
#ifndef R_SERIAL2_CTRL__rec_bitnr__DEFAULT
#define R_SERIAL2_CTRL__rec_bitnr__DEFAULT rec_8bit
#endif

/*  0 - 0x1 */
#ifndef R_SERIAL2_CTRL__txd__DEFAULT
#define R_SERIAL2_CTRL__txd__DEFAULT 0
#endif

/* disable enable */
#ifndef R_SERIAL2_CTRL__tr_enable__DEFAULT
#define R_SERIAL2_CTRL__tr_enable__DEFAULT disable
#endif

/* disabled active */
#ifndef R_SERIAL2_CTRL__auto_cts__DEFAULT
#define R_SERIAL2_CTRL__auto_cts__DEFAULT disabled
#endif

/* one_bit two_bits */
#ifndef R_SERIAL2_CTRL__stop_bits__DEFAULT
#define R_SERIAL2_CTRL__stop_bits__DEFAULT one_bit
#endif

/* normal stick */
#ifndef R_SERIAL2_CTRL__tr_stick_par__DEFAULT
#define R_SERIAL2_CTRL__tr_stick_par__DEFAULT normal
#endif

/* even odd */
#ifndef R_SERIAL2_CTRL__tr_par__DEFAULT
#define R_SERIAL2_CTRL__tr_par__DEFAULT even
#endif

/* disable enable */
#ifndef R_SERIAL2_CTRL__tr_par_en__DEFAULT
#define R_SERIAL2_CTRL__tr_par_en__DEFAULT disable
#endif

/* tr_7bit tr_8bit */
#ifndef R_SERIAL2_CTRL__tr_bitnr__DEFAULT
#define R_SERIAL2_CTRL__tr_bitnr__DEFAULT tr_7bit
#endif

/*  0 - 0xff */
#ifndef R_SERIAL2_CTRL__data_out__DEFAULT
#define R_SERIAL2_CTRL__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SERIAL2_REC_CTRL
*/

/* ignore stop */
#ifndef R_SERIAL2_REC_CTRL__dma_err__DEFAULT
#define R_SERIAL2_REC_CTRL__dma_err__DEFAULT ignore
#endif

/* disable enable */
#ifndef R_SERIAL2_REC_CTRL__rec_enable__DEFAULT
#define R_SERIAL2_REC_CTRL__rec_enable__DEFAULT disable
#endif

/* inactive active */
#ifndef R_SERIAL2_REC_CTRL__rts___DEFAULT
#define R_SERIAL2_REC_CTRL__rts___DEFAULT inactive
#endif

/* majority middle */
#ifndef R_SERIAL2_REC_CTRL__sampling__DEFAULT
#define R_SERIAL2_REC_CTRL__sampling__DEFAULT majority
#endif

/* normal stick */
#ifndef R_SERIAL2_REC_CTRL__rec_stick_par__DEFAULT
#define R_SERIAL2_REC_CTRL__rec_stick_par__DEFAULT normal
#endif

/* even odd */
#ifndef R_SERIAL2_REC_CTRL__rec_par__DEFAULT
#define R_SERIAL2_REC_CTRL__rec_par__DEFAULT even
#endif

/* disable enable */
#ifndef R_SERIAL2_REC_CTRL__rec_par_en__DEFAULT
#define R_SERIAL2_REC_CTRL__rec_par_en__DEFAULT disable
#endif

/* rec_8bit rec_7bit */
#ifndef R_SERIAL2_REC_CTRL__rec_bitnr__DEFAULT
#define R_SERIAL2_REC_CTRL__rec_bitnr__DEFAULT rec_8bit
#endif

/*
** Default values for register  R_SERIAL2_TR_CTRL
*/

/*  0 - 0x1 */
#ifndef R_SERIAL2_TR_CTRL__txd__DEFAULT
#define R_SERIAL2_TR_CTRL__txd__DEFAULT 0
#endif

/* disable enable */
#ifndef R_SERIAL2_TR_CTRL__tr_enable__DEFAULT
#define R_SERIAL2_TR_CTRL__tr_enable__DEFAULT disable
#endif

/* disabled active */
#ifndef R_SERIAL2_TR_CTRL__auto_cts__DEFAULT
#define R_SERIAL2_TR_CTRL__auto_cts__DEFAULT disabled
#endif

/* one_bit two_bits */
#ifndef R_SERIAL2_TR_CTRL__stop_bits__DEFAULT
#define R_SERIAL2_TR_CTRL__stop_bits__DEFAULT one_bit
#endif

/* normal stick */
#ifndef R_SERIAL2_TR_CTRL__tr_stick_par__DEFAULT
#define R_SERIAL2_TR_CTRL__tr_stick_par__DEFAULT normal
#endif

/* even odd */
#ifndef R_SERIAL2_TR_CTRL__tr_par__DEFAULT
#define R_SERIAL2_TR_CTRL__tr_par__DEFAULT even
#endif

/* disable enable */
#ifndef R_SERIAL2_TR_CTRL__tr_par_en__DEFAULT
#define R_SERIAL2_TR_CTRL__tr_par_en__DEFAULT disable
#endif

/* tr_7bit tr_8bit */
#ifndef R_SERIAL2_TR_CTRL__tr_bitnr__DEFAULT
#define R_SERIAL2_TR_CTRL__tr_bitnr__DEFAULT tr_7bit
#endif

/*
** Default values for register  R_SERIAL2_TR_DATA
*/

/*  0 - 0xff */
#ifndef R_SERIAL2_TR_DATA__data_out__DEFAULT
#define R_SERIAL2_TR_DATA__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SERIAL2_XOFF
*/

/* stop enable */
#ifndef R_SERIAL2_XOFF__tx_stop__DEFAULT
#define R_SERIAL2_XOFF__tx_stop__DEFAULT stop
#endif

/* disable enable */
#ifndef R_SERIAL2_XOFF__auto_xoff__DEFAULT
#define R_SERIAL2_XOFF__auto_xoff__DEFAULT disable
#endif

/*  0 - 0xff */
#ifndef R_SERIAL2_XOFF__xoff_char__DEFAULT
#define R_SERIAL2_XOFF__xoff_char__DEFAULT 0
#endif

/*
** Default values for register  R_SERIAL3_BAUD
*/

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_SERIAL3_BAUD__tr_baud__DEFAULT
#define R_SERIAL3_BAUD__tr_baud__DEFAULT c4800Hz
#endif

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_SERIAL3_BAUD__rec_baud__DEFAULT
#define R_SERIAL3_BAUD__rec_baud__DEFAULT c4800Hz
#endif

/*
** Default values for register  R_SERIAL3_CTRL
*/

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_SERIAL3_CTRL__tr_baud__DEFAULT
#define R_SERIAL3_CTRL__tr_baud__DEFAULT c4800Hz
#endif

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_SERIAL3_CTRL__rec_baud__DEFAULT
#define R_SERIAL3_CTRL__rec_baud__DEFAULT c4800Hz
#endif

/* ignore stop */
#ifndef R_SERIAL3_CTRL__dma_err__DEFAULT
#define R_SERIAL3_CTRL__dma_err__DEFAULT ignore
#endif

/* disable enable */
#ifndef R_SERIAL3_CTRL__rec_enable__DEFAULT
#define R_SERIAL3_CTRL__rec_enable__DEFAULT disable
#endif

/* inactive active */
#ifndef R_SERIAL3_CTRL__rts___DEFAULT
#define R_SERIAL3_CTRL__rts___DEFAULT inactive
#endif

/* majority middle */
#ifndef R_SERIAL3_CTRL__sampling__DEFAULT
#define R_SERIAL3_CTRL__sampling__DEFAULT majority
#endif

/* normal stick */
#ifndef R_SERIAL3_CTRL__rec_stick_par__DEFAULT
#define R_SERIAL3_CTRL__rec_stick_par__DEFAULT normal
#endif

/* even odd */
#ifndef R_SERIAL3_CTRL__rec_par__DEFAULT
#define R_SERIAL3_CTRL__rec_par__DEFAULT even
#endif

/* disable enable */
#ifndef R_SERIAL3_CTRL__rec_par_en__DEFAULT
#define R_SERIAL3_CTRL__rec_par_en__DEFAULT disable
#endif

/* rec_8bit rec_7bit */
#ifndef R_SERIAL3_CTRL__rec_bitnr__DEFAULT
#define R_SERIAL3_CTRL__rec_bitnr__DEFAULT rec_8bit
#endif

/*  0 - 0x1 */
#ifndef R_SERIAL3_CTRL__txd__DEFAULT
#define R_SERIAL3_CTRL__txd__DEFAULT 0
#endif

/* disable enable */
#ifndef R_SERIAL3_CTRL__tr_enable__DEFAULT
#define R_SERIAL3_CTRL__tr_enable__DEFAULT disable
#endif

/* disabled active */
#ifndef R_SERIAL3_CTRL__auto_cts__DEFAULT
#define R_SERIAL3_CTRL__auto_cts__DEFAULT disabled
#endif

/* one_bit two_bits */
#ifndef R_SERIAL3_CTRL__stop_bits__DEFAULT
#define R_SERIAL3_CTRL__stop_bits__DEFAULT one_bit
#endif

/* normal stick */
#ifndef R_SERIAL3_CTRL__tr_stick_par__DEFAULT
#define R_SERIAL3_CTRL__tr_stick_par__DEFAULT normal
#endif

/* even odd */
#ifndef R_SERIAL3_CTRL__tr_par__DEFAULT
#define R_SERIAL3_CTRL__tr_par__DEFAULT even
#endif

/* disable enable */
#ifndef R_SERIAL3_CTRL__tr_par_en__DEFAULT
#define R_SERIAL3_CTRL__tr_par_en__DEFAULT disable
#endif

/* tr_7bit tr_8bit */
#ifndef R_SERIAL3_CTRL__tr_bitnr__DEFAULT
#define R_SERIAL3_CTRL__tr_bitnr__DEFAULT tr_7bit
#endif

/*  0 - 0xff */
#ifndef R_SERIAL3_CTRL__data_out__DEFAULT
#define R_SERIAL3_CTRL__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SERIAL3_REC_CTRL
*/

/* ignore stop */
#ifndef R_SERIAL3_REC_CTRL__dma_err__DEFAULT
#define R_SERIAL3_REC_CTRL__dma_err__DEFAULT ignore
#endif

/* disable enable */
#ifndef R_SERIAL3_REC_CTRL__rec_enable__DEFAULT
#define R_SERIAL3_REC_CTRL__rec_enable__DEFAULT disable
#endif

/* inactive active */
#ifndef R_SERIAL3_REC_CTRL__rts___DEFAULT
#define R_SERIAL3_REC_CTRL__rts___DEFAULT inactive
#endif

/* majority middle */
#ifndef R_SERIAL3_REC_CTRL__sampling__DEFAULT
#define R_SERIAL3_REC_CTRL__sampling__DEFAULT majority
#endif

/* normal stick */
#ifndef R_SERIAL3_REC_CTRL__rec_stick_par__DEFAULT
#define R_SERIAL3_REC_CTRL__rec_stick_par__DEFAULT normal
#endif

/* even odd */
#ifndef R_SERIAL3_REC_CTRL__rec_par__DEFAULT
#define R_SERIAL3_REC_CTRL__rec_par__DEFAULT even
#endif

/* disable enable */
#ifndef R_SERIAL3_REC_CTRL__rec_par_en__DEFAULT
#define R_SERIAL3_REC_CTRL__rec_par_en__DEFAULT disable
#endif

/* rec_8bit rec_7bit */
#ifndef R_SERIAL3_REC_CTRL__rec_bitnr__DEFAULT
#define R_SERIAL3_REC_CTRL__rec_bitnr__DEFAULT rec_8bit
#endif

/*
** Default values for register  R_SERIAL3_TR_CTRL
*/

/*  0 - 0x1 */
#ifndef R_SERIAL3_TR_CTRL__txd__DEFAULT
#define R_SERIAL3_TR_CTRL__txd__DEFAULT 0
#endif

/* disable enable */
#ifndef R_SERIAL3_TR_CTRL__tr_enable__DEFAULT
#define R_SERIAL3_TR_CTRL__tr_enable__DEFAULT disable
#endif

/* disabled active */
#ifndef R_SERIAL3_TR_CTRL__auto_cts__DEFAULT
#define R_SERIAL3_TR_CTRL__auto_cts__DEFAULT disabled
#endif

/* one_bit two_bits */
#ifndef R_SERIAL3_TR_CTRL__stop_bits__DEFAULT
#define R_SERIAL3_TR_CTRL__stop_bits__DEFAULT one_bit
#endif

/* normal stick */
#ifndef R_SERIAL3_TR_CTRL__tr_stick_par__DEFAULT
#define R_SERIAL3_TR_CTRL__tr_stick_par__DEFAULT normal
#endif

/* even odd */
#ifndef R_SERIAL3_TR_CTRL__tr_par__DEFAULT
#define R_SERIAL3_TR_CTRL__tr_par__DEFAULT even
#endif

/* disable enable */
#ifndef R_SERIAL3_TR_CTRL__tr_par_en__DEFAULT
#define R_SERIAL3_TR_CTRL__tr_par_en__DEFAULT disable
#endif

/* tr_7bit tr_8bit */
#ifndef R_SERIAL3_TR_CTRL__tr_bitnr__DEFAULT
#define R_SERIAL3_TR_CTRL__tr_bitnr__DEFAULT tr_7bit
#endif

/*
** Default values for register  R_SERIAL3_TR_DATA
*/

/*  0 - 0xff */
#ifndef R_SERIAL3_TR_DATA__data_out__DEFAULT
#define R_SERIAL3_TR_DATA__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SERIAL3_XOFF
*/

/* stop enable */
#ifndef R_SERIAL3_XOFF__tx_stop__DEFAULT
#define R_SERIAL3_XOFF__tx_stop__DEFAULT stop
#endif

/* disable enable */
#ifndef R_SERIAL3_XOFF__auto_xoff__DEFAULT
#define R_SERIAL3_XOFF__auto_xoff__DEFAULT disable
#endif

/*  0 - 0xff */
#ifndef R_SERIAL3_XOFF__xoff_char__DEFAULT
#define R_SERIAL3_XOFF__xoff_char__DEFAULT 0
#endif

/*
** Default values for register  R_SERIAL_PRESCALE
*/

/*  0 - 0xffff */
#ifndef R_SERIAL_PRESCALE__ser_presc__DEFAULT
#define R_SERIAL_PRESCALE__ser_presc__DEFAULT 0
#endif

/*
** Default values for register  R_SET_EOP
*/

/* set nop */
#ifndef R_SET_EOP__ch9_eop__DEFAULT
#define R_SET_EOP__ch9_eop__DEFAULT set
#endif

/* set nop */
#ifndef R_SET_EOP__ch7_eop__DEFAULT
#define R_SET_EOP__ch7_eop__DEFAULT set
#endif

/* set nop */
#ifndef R_SET_EOP__ch5_eop__DEFAULT
#define R_SET_EOP__ch5_eop__DEFAULT set
#endif

/* set nop */
#ifndef R_SET_EOP__ch3_eop__DEFAULT
#define R_SET_EOP__ch3_eop__DEFAULT set
#endif

/*
** Default values for register  R_SHARED_RAM_ADDR
*/

/*  0 - 0x3fffff */
#ifndef R_SHARED_RAM_ADDR__base_addr__DEFAULT
#define R_SHARED_RAM_ADDR__base_addr__DEFAULT 0
#endif

/*
** Default values for register  R_SHARED_RAM_CONFIG
*/

/* word byte */
#ifndef R_SHARED_RAM_CONFIG__width__DEFAULT
#define R_SHARED_RAM_CONFIG__width__DEFAULT word
#endif

/* yes no */
#ifndef R_SHARED_RAM_CONFIG__enable__DEFAULT
#define R_SHARED_RAM_CONFIG__enable__DEFAULT yes
#endif

/* int nop */
#ifndef R_SHARED_RAM_CONFIG__pint__DEFAULT
#define R_SHARED_RAM_CONFIG__pint__DEFAULT int
#endif

/* clr nop */
#ifndef R_SHARED_RAM_CONFIG__clri__DEFAULT
#define R_SHARED_RAM_CONFIG__clri__DEFAULT clr
#endif

/*
** Default values for register  R_SINGLE_STEP
*/

/* off on */
#ifndef R_SINGLE_STEP__single_step__DEFAULT
#define R_SINGLE_STEP__single_step__DEFAULT off
#endif

/* off on */
#ifndef R_SINGLE_STEP__step_wr__DEFAULT
#define R_SINGLE_STEP__step_wr__DEFAULT off
#endif

/* off on */
#ifndef R_SINGLE_STEP__step_rd__DEFAULT
#define R_SINGLE_STEP__step_rd__DEFAULT off
#endif

/* off on */
#ifndef R_SINGLE_STEP__step_fetch__DEFAULT
#define R_SINGLE_STEP__step_fetch__DEFAULT off
#endif

/*
** Default values for register  R_SYNC_SERIAL1_CTRL
*/

/* c4800Hz c921k6Hz c460k8Hz c57k6Hz c28k8Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c3125kHz c150Hz c600Hz c2400Hz c19k2Hz */
#ifndef R_SYNC_SERIAL1_CTRL__tr_baud__DEFAULT
#define R_SYNC_SERIAL1_CTRL__tr_baud__DEFAULT c4800Hz
#endif

/* off on */
#ifndef R_SYNC_SERIAL1_CTRL__dma_enable__DEFAULT
#define R_SYNC_SERIAL1_CTRL__dma_enable__DEFAULT off
#endif

/* slave_input master_input slave_output slave_bidir master_output master_bidir */
#ifndef R_SYNC_SERIAL1_CTRL__mode__DEFAULT
#define R_SYNC_SERIAL1_CTRL__mode__DEFAULT slave_input
#endif

/* normal ignore */
#ifndef R_SYNC_SERIAL1_CTRL__error__DEFAULT
#define R_SYNC_SERIAL1_CTRL__error__DEFAULT normal
#endif

/* disable enable */
#ifndef R_SYNC_SERIAL1_CTRL__rec_enable__DEFAULT
#define R_SYNC_SERIAL1_CTRL__rec_enable__DEFAULT disable
#endif

/* normal early */
#ifndef R_SYNC_SERIAL1_CTRL__f_synctype__DEFAULT
#define R_SYNC_SERIAL1_CTRL__f_synctype__DEFAULT normal
#endif

/* extended word bit */
#ifndef R_SYNC_SERIAL1_CTRL__f_syncsize__DEFAULT
#define R_SYNC_SERIAL1_CTRL__f_syncsize__DEFAULT extended
#endif

/* off on */
#ifndef R_SYNC_SERIAL1_CTRL__f_sync__DEFAULT
#define R_SYNC_SERIAL1_CTRL__f_sync__DEFAULT off
#endif

/* normal gated */
#ifndef R_SYNC_SERIAL1_CTRL__clk_mode__DEFAULT
#define R_SYNC_SERIAL1_CTRL__clk_mode__DEFAULT normal
#endif

/* running stopped */
#ifndef R_SYNC_SERIAL1_CTRL__clk_halt__DEFAULT
#define R_SYNC_SERIAL1_CTRL__clk_halt__DEFAULT running
#endif

/* lsb msb */
#ifndef R_SYNC_SERIAL1_CTRL__bitorder__DEFAULT
#define R_SYNC_SERIAL1_CTRL__bitorder__DEFAULT lsb
#endif

/* disable enable */
#ifndef R_SYNC_SERIAL1_CTRL__tr_enable__DEFAULT
#define R_SYNC_SERIAL1_CTRL__tr_enable__DEFAULT disable
#endif

/* size24bit size16bit size8bit size12bit size32bit */
#ifndef R_SYNC_SERIAL1_CTRL__wordsize__DEFAULT
#define R_SYNC_SERIAL1_CTRL__wordsize__DEFAULT size24bit
#endif

/* lmt_0 lmt_8 */
#ifndef R_SYNC_SERIAL1_CTRL__buf_empty__DEFAULT
#define R_SYNC_SERIAL1_CTRL__buf_empty__DEFAULT lmt_0
#endif

/* lmt_32 lmt_8 */
#ifndef R_SYNC_SERIAL1_CTRL__buf_full__DEFAULT
#define R_SYNC_SERIAL1_CTRL__buf_full__DEFAULT lmt_32
#endif

/* disabled enabled */
#ifndef R_SYNC_SERIAL1_CTRL__flow_ctrl__DEFAULT
#define R_SYNC_SERIAL1_CTRL__flow_ctrl__DEFAULT disabled
#endif

/* neg pos */
#ifndef R_SYNC_SERIAL1_CTRL__clk_polarity__DEFAULT
#define R_SYNC_SERIAL1_CTRL__clk_polarity__DEFAULT neg
#endif

/* inverted normal */
#ifndef R_SYNC_SERIAL1_CTRL__frame_polarity__DEFAULT
#define R_SYNC_SERIAL1_CTRL__frame_polarity__DEFAULT inverted
#endif

/* inverted normal */
#ifndef R_SYNC_SERIAL1_CTRL__status_polarity__DEFAULT
#define R_SYNC_SERIAL1_CTRL__status_polarity__DEFAULT inverted
#endif

/* inverted normal */
#ifndef R_SYNC_SERIAL1_CTRL__clk_driver__DEFAULT
#define R_SYNC_SERIAL1_CTRL__clk_driver__DEFAULT inverted
#endif

/* inverted normal */
#ifndef R_SYNC_SERIAL1_CTRL__frame_driver__DEFAULT
#define R_SYNC_SERIAL1_CTRL__frame_driver__DEFAULT inverted
#endif

/* inverted normal */
#ifndef R_SYNC_SERIAL1_CTRL__status_driver__DEFAULT
#define R_SYNC_SERIAL1_CTRL__status_driver__DEFAULT inverted
#endif

/* high low */
#ifndef R_SYNC_SERIAL1_CTRL__def_out0__DEFAULT
#define R_SYNC_SERIAL1_CTRL__def_out0__DEFAULT high
#endif

/*
** Default values for register  R_SYNC_SERIAL1_TR_BYTE
*/

/*  0 - 0xff */
#ifndef R_SYNC_SERIAL1_TR_BYTE__data_out__DEFAULT
#define R_SYNC_SERIAL1_TR_BYTE__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SYNC_SERIAL1_TR_DATA
*/

/*  0 - 0xffffffff */
#ifndef R_SYNC_SERIAL1_TR_DATA__data_out__DEFAULT
#define R_SYNC_SERIAL1_TR_DATA__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SYNC_SERIAL1_TR_WORD
*/

/*  0 - 0xffff */
#ifndef R_SYNC_SERIAL1_TR_WORD__data_out__DEFAULT
#define R_SYNC_SERIAL1_TR_WORD__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SYNC_SERIAL3_CTRL
*/

/* c4800Hz c921k6Hz c460k8Hz c57k6Hz c28k8Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c3125kHz c150Hz c600Hz c2400Hz c19k2Hz */
#ifndef R_SYNC_SERIAL3_CTRL__tr_baud__DEFAULT
#define R_SYNC_SERIAL3_CTRL__tr_baud__DEFAULT c4800Hz
#endif

/* off on */
#ifndef R_SYNC_SERIAL3_CTRL__dma_enable__DEFAULT
#define R_SYNC_SERIAL3_CTRL__dma_enable__DEFAULT off
#endif

/* slave_input master_input slave_output slave_bidir master_output master_bidir */
#ifndef R_SYNC_SERIAL3_CTRL__mode__DEFAULT
#define R_SYNC_SERIAL3_CTRL__mode__DEFAULT slave_input
#endif

/* normal ignore */
#ifndef R_SYNC_SERIAL3_CTRL__error__DEFAULT
#define R_SYNC_SERIAL3_CTRL__error__DEFAULT normal
#endif

/* disable enable */
#ifndef R_SYNC_SERIAL3_CTRL__rec_enable__DEFAULT
#define R_SYNC_SERIAL3_CTRL__rec_enable__DEFAULT disable
#endif

/* normal early */
#ifndef R_SYNC_SERIAL3_CTRL__f_synctype__DEFAULT
#define R_SYNC_SERIAL3_CTRL__f_synctype__DEFAULT normal
#endif

/* extended word bit */
#ifndef R_SYNC_SERIAL3_CTRL__f_syncsize__DEFAULT
#define R_SYNC_SERIAL3_CTRL__f_syncsize__DEFAULT extended
#endif

/* off on */
#ifndef R_SYNC_SERIAL3_CTRL__f_sync__DEFAULT
#define R_SYNC_SERIAL3_CTRL__f_sync__DEFAULT off
#endif

/* normal gated */
#ifndef R_SYNC_SERIAL3_CTRL__clk_mode__DEFAULT
#define R_SYNC_SERIAL3_CTRL__clk_mode__DEFAULT normal
#endif

/* running stopped */
#ifndef R_SYNC_SERIAL3_CTRL__clk_halt__DEFAULT
#define R_SYNC_SERIAL3_CTRL__clk_halt__DEFAULT running
#endif

/* lsb msb */
#ifndef R_SYNC_SERIAL3_CTRL__bitorder__DEFAULT
#define R_SYNC_SERIAL3_CTRL__bitorder__DEFAULT lsb
#endif

/* disable enable */
#ifndef R_SYNC_SERIAL3_CTRL__tr_enable__DEFAULT
#define R_SYNC_SERIAL3_CTRL__tr_enable__DEFAULT disable
#endif

/* size24bit size16bit size8bit size12bit size32bit */
#ifndef R_SYNC_SERIAL3_CTRL__wordsize__DEFAULT
#define R_SYNC_SERIAL3_CTRL__wordsize__DEFAULT size24bit
#endif

/* lmt_0 lmt_8 */
#ifndef R_SYNC_SERIAL3_CTRL__buf_empty__DEFAULT
#define R_SYNC_SERIAL3_CTRL__buf_empty__DEFAULT lmt_0
#endif

/* lmt_32 lmt_8 */
#ifndef R_SYNC_SERIAL3_CTRL__buf_full__DEFAULT
#define R_SYNC_SERIAL3_CTRL__buf_full__DEFAULT lmt_32
#endif

/* disabled enabled */
#ifndef R_SYNC_SERIAL3_CTRL__flow_ctrl__DEFAULT
#define R_SYNC_SERIAL3_CTRL__flow_ctrl__DEFAULT disabled
#endif

/* neg pos */
#ifndef R_SYNC_SERIAL3_CTRL__clk_polarity__DEFAULT
#define R_SYNC_SERIAL3_CTRL__clk_polarity__DEFAULT neg
#endif

/* inverted normal */
#ifndef R_SYNC_SERIAL3_CTRL__frame_polarity__DEFAULT
#define R_SYNC_SERIAL3_CTRL__frame_polarity__DEFAULT inverted
#endif

/* inverted normal */
#ifndef R_SYNC_SERIAL3_CTRL__status_polarity__DEFAULT
#define R_SYNC_SERIAL3_CTRL__status_polarity__DEFAULT inverted
#endif

/* inverted normal */
#ifndef R_SYNC_SERIAL3_CTRL__clk_driver__DEFAULT
#define R_SYNC_SERIAL3_CTRL__clk_driver__DEFAULT inverted
#endif

/* inverted normal */
#ifndef R_SYNC_SERIAL3_CTRL__frame_driver__DEFAULT
#define R_SYNC_SERIAL3_CTRL__frame_driver__DEFAULT inverted
#endif

/* inverted normal */
#ifndef R_SYNC_SERIAL3_CTRL__status_driver__DEFAULT
#define R_SYNC_SERIAL3_CTRL__status_driver__DEFAULT inverted
#endif

/* high low */
#ifndef R_SYNC_SERIAL3_CTRL__def_out0__DEFAULT
#define R_SYNC_SERIAL3_CTRL__def_out0__DEFAULT high
#endif

/*
** Default values for register  R_SYNC_SERIAL3_TR_BYTE
*/

/*  0 - 0xff */
#ifndef R_SYNC_SERIAL3_TR_BYTE__data_out__DEFAULT
#define R_SYNC_SERIAL3_TR_BYTE__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SYNC_SERIAL3_TR_DATA
*/

/*  0 - 0xffffffff */
#ifndef R_SYNC_SERIAL3_TR_DATA__data_out__DEFAULT
#define R_SYNC_SERIAL3_TR_DATA__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SYNC_SERIAL3_TR_WORD
*/

/*  0 - 0xffff */
#ifndef R_SYNC_SERIAL3_TR_WORD__data_out__DEFAULT
#define R_SYNC_SERIAL3_TR_WORD__data_out__DEFAULT 0
#endif

/*
** Default values for register  R_SYNC_SERIAL_PRESCALE
*/

/* baudrate codec */
#ifndef R_SYNC_SERIAL_PRESCALE__clk_sel_u3__DEFAULT
#define R_SYNC_SERIAL_PRESCALE__clk_sel_u3__DEFAULT baudrate
#endif

/* external internal */
#ifndef R_SYNC_SERIAL_PRESCALE__word_stb_sel_u3__DEFAULT
#define R_SYNC_SERIAL_PRESCALE__word_stb_sel_u3__DEFAULT external
#endif

/* baudrate codec */
#ifndef R_SYNC_SERIAL_PRESCALE__clk_sel_u1__DEFAULT
#define R_SYNC_SERIAL_PRESCALE__clk_sel_u1__DEFAULT baudrate
#endif

/* external internal */
#ifndef R_SYNC_SERIAL_PRESCALE__word_stb_sel_u1__DEFAULT
#define R_SYNC_SERIAL_PRESCALE__word_stb_sel_u1__DEFAULT external
#endif

/* div1 div2 div4 div32 div16 div8 div64 div128 */
#ifndef R_SYNC_SERIAL_PRESCALE__prescaler__DEFAULT
#define R_SYNC_SERIAL_PRESCALE__prescaler__DEFAULT div1
#endif

/* normal enabled */
#ifndef R_SYNC_SERIAL_PRESCALE__warp_mode__DEFAULT
#define R_SYNC_SERIAL_PRESCALE__warp_mode__DEFAULT normal
#endif

/*  0 - 0xf */
#ifndef R_SYNC_SERIAL_PRESCALE__frame_rate__DEFAULT
#define R_SYNC_SERIAL_PRESCALE__frame_rate__DEFAULT 0
#endif

/*  0 - 0x3ff */
#ifndef R_SYNC_SERIAL_PRESCALE__word_rate__DEFAULT
#define R_SYNC_SERIAL_PRESCALE__word_rate__DEFAULT 0
#endif

/*
** Default values for register  R_TEST_MODE
*/

/* off on */
#ifndef R_TEST_MODE__single_step__DEFAULT
#define R_TEST_MODE__single_step__DEFAULT off
#endif

/* off on */
#ifndef R_TEST_MODE__step_wr__DEFAULT
#define R_TEST_MODE__step_wr__DEFAULT off
#endif

/* off on */
#ifndef R_TEST_MODE__step_rd__DEFAULT
#define R_TEST_MODE__step_rd__DEFAULT off
#endif

/* off on */
#ifndef R_TEST_MODE__step_fetch__DEFAULT
#define R_TEST_MODE__step_fetch__DEFAULT off
#endif

/* off on */
#ifndef R_TEST_MODE__mmu_test__DEFAULT
#define R_TEST_MODE__mmu_test__DEFAULT off
#endif

/* off on */
#ifndef R_TEST_MODE__usb_test__DEFAULT
#define R_TEST_MODE__usb_test__DEFAULT off
#endif

/* off on */
#ifndef R_TEST_MODE__scsi_timer_test__DEFAULT
#define R_TEST_MODE__scsi_timer_test__DEFAULT off
#endif

/* off on */
#ifndef R_TEST_MODE__backoff__DEFAULT
#define R_TEST_MODE__backoff__DEFAULT off
#endif

/* off on */
#ifndef R_TEST_MODE__snmp_test__DEFAULT
#define R_TEST_MODE__snmp_test__DEFAULT off
#endif

/* do dont */
#ifndef R_TEST_MODE__snmp_inc__DEFAULT
#define R_TEST_MODE__snmp_inc__DEFAULT do
#endif

/* off on */
#ifndef R_TEST_MODE__ser_loop__DEFAULT
#define R_TEST_MODE__ser_loop__DEFAULT off
#endif

/* off on */
#ifndef R_TEST_MODE__baudrate__DEFAULT
#define R_TEST_MODE__baudrate__DEFAULT off
#endif

/* all off even odd */
#ifndef R_TEST_MODE__timer__DEFAULT
#define R_TEST_MODE__timer__DEFAULT all
#endif

/* test normal */
#ifndef R_TEST_MODE__cache_test__DEFAULT
#define R_TEST_MODE__cache_test__DEFAULT test
#endif

/* test normal */
#ifndef R_TEST_MODE__tag_test__DEFAULT
#define R_TEST_MODE__tag_test__DEFAULT test
#endif

/* disable enable */
#ifndef R_TEST_MODE__cache_enable__DEFAULT
#define R_TEST_MODE__cache_enable__DEFAULT disable
#endif

/*
** Default values for register  R_TIMER_CTRL
*/

/*  0 - 0xff */
#ifndef R_TIMER_CTRL__timerdiv1__DEFAULT
#define R_TIMER_CTRL__timerdiv1__DEFAULT 0
#endif

/*  0 - 0xff */
#ifndef R_TIMER_CTRL__timerdiv0__DEFAULT
#define R_TIMER_CTRL__timerdiv0__DEFAULT 0
#endif

/* normal prescale */
#ifndef R_TIMER_CTRL__presc_timer1__DEFAULT
#define R_TIMER_CTRL__presc_timer1__DEFAULT normal
#endif

/* clr nop */
#ifndef R_TIMER_CTRL__i1__DEFAULT
#define R_TIMER_CTRL__i1__DEFAULT clr
#endif

/* freeze run stop_ld */
#ifndef R_TIMER_CTRL__tm1__DEFAULT
#define R_TIMER_CTRL__tm1__DEFAULT freeze
#endif

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz cascade0 c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_TIMER_CTRL__clksel1__DEFAULT
#define R_TIMER_CTRL__clksel1__DEFAULT c4800Hz
#endif

/* external prescale */
#ifndef R_TIMER_CTRL__presc_ext__DEFAULT
#define R_TIMER_CTRL__presc_ext__DEFAULT external
#endif

/* clr nop */
#ifndef R_TIMER_CTRL__i0__DEFAULT
#define R_TIMER_CTRL__i0__DEFAULT clr
#endif

/* freeze run stop_ld */
#ifndef R_TIMER_CTRL__tm0__DEFAULT
#define R_TIMER_CTRL__tm0__DEFAULT freeze
#endif

/* c4800Hz c1843k2Hz c921k6Hz c460k8Hz c57k6Hz c9600Hz c300Hz c1200Hz c230k4Hz c115k2Hz flexible c600Hz c2400Hz c19k2Hz c6250kHz c38k4Hz */
#ifndef R_TIMER_CTRL__clksel0__DEFAULT
#define R_TIMER_CTRL__clksel0__DEFAULT c4800Hz
#endif

/*
** Default values for register  R_TIMER_PRESCALE
*/

/*  0 - 0xffff */
#ifndef R_TIMER_PRESCALE__tim_presc__DEFAULT
#define R_TIMER_PRESCALE__tim_presc__DEFAULT 0
#endif

/*
** Default values for register  R_USB_IRQ_MASK_CLR
*/

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR__iso_eof__DEFAULT
#define R_USB_IRQ_MASK_CLR__iso_eof__DEFAULT clr
#endif

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR__intr_eof__DEFAULT
#define R_USB_IRQ_MASK_CLR__intr_eof__DEFAULT clr
#endif

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR__iso_eot__DEFAULT
#define R_USB_IRQ_MASK_CLR__iso_eot__DEFAULT clr
#endif

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR__intr_eot__DEFAULT
#define R_USB_IRQ_MASK_CLR__intr_eot__DEFAULT clr
#endif

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR__ctl_eot__DEFAULT
#define R_USB_IRQ_MASK_CLR__ctl_eot__DEFAULT clr
#endif

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR__bulk_eot__DEFAULT
#define R_USB_IRQ_MASK_CLR__bulk_eot__DEFAULT clr
#endif

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR__epid_attn__DEFAULT
#define R_USB_IRQ_MASK_CLR__epid_attn__DEFAULT clr
#endif

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR__sof__DEFAULT
#define R_USB_IRQ_MASK_CLR__sof__DEFAULT clr
#endif

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR__port_status__DEFAULT
#define R_USB_IRQ_MASK_CLR__port_status__DEFAULT clr
#endif

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR__ctl_status__DEFAULT
#define R_USB_IRQ_MASK_CLR__ctl_status__DEFAULT clr
#endif

/*
** Default values for register  R_USB_IRQ_MASK_CLR_DEV
*/

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR_DEV__out_eot__DEFAULT
#define R_USB_IRQ_MASK_CLR_DEV__out_eot__DEFAULT clr
#endif

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR_DEV__ep3_in_eot__DEFAULT
#define R_USB_IRQ_MASK_CLR_DEV__ep3_in_eot__DEFAULT clr
#endif

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR_DEV__ep2_in_eot__DEFAULT
#define R_USB_IRQ_MASK_CLR_DEV__ep2_in_eot__DEFAULT clr
#endif

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR_DEV__ep1_in_eot__DEFAULT
#define R_USB_IRQ_MASK_CLR_DEV__ep1_in_eot__DEFAULT clr
#endif

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR_DEV__ep0_in_eot__DEFAULT
#define R_USB_IRQ_MASK_CLR_DEV__ep0_in_eot__DEFAULT clr
#endif

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR_DEV__epid_attn__DEFAULT
#define R_USB_IRQ_MASK_CLR_DEV__epid_attn__DEFAULT clr
#endif

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR_DEV__sof__DEFAULT
#define R_USB_IRQ_MASK_CLR_DEV__sof__DEFAULT clr
#endif

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR_DEV__port_status__DEFAULT
#define R_USB_IRQ_MASK_CLR_DEV__port_status__DEFAULT clr
#endif

/* clr nop */
#ifndef R_USB_IRQ_MASK_CLR_DEV__ctl_status__DEFAULT
#define R_USB_IRQ_MASK_CLR_DEV__ctl_status__DEFAULT clr
#endif

/*
** Default values for register  R_USB_IRQ_MASK_SET
*/

/* set nop */
#ifndef R_USB_IRQ_MASK_SET__iso_eof__DEFAULT
#define R_USB_IRQ_MASK_SET__iso_eof__DEFAULT set
#endif

/* set nop */
#ifndef R_USB_IRQ_MASK_SET__intr_eof__DEFAULT
#define R_USB_IRQ_MASK_SET__intr_eof__DEFAULT set
#endif

/* set nop */
#ifndef R_USB_IRQ_MASK_SET__iso_eot__DEFAULT
#define R_USB_IRQ_MASK_SET__iso_eot__DEFAULT set
#endif

/* set nop */
#ifndef R_USB_IRQ_MASK_SET__intr_eot__DEFAULT
#define R_USB_IRQ_MASK_SET__intr_eot__DEFAULT set
#endif

/* set nop */
#ifndef R_USB_IRQ_MASK_SET__ctl_eot__DEFAULT
#define R_USB_IRQ_MASK_SET__ctl_eot__DEFAULT set
#endif

/* set nop */
#ifndef R_USB_IRQ_MASK_SET__bulk_eot__DEFAULT
#define R_USB_IRQ_MASK_SET__bulk_eot__DEFAULT set
#endif

/* set nop */
#ifndef R_USB_IRQ_MASK_SET__epid_attn__DEFAULT
#define R_USB_IRQ_MASK_SET__epid_attn__DEFAULT set
#endif

/* set nop */
#ifndef R_USB_IRQ_MASK_SET__sof__DEFAULT
#define R_USB_IRQ_MASK_SET__sof__DEFAULT set
#endif

/* set nop */
#ifndef R_USB_IRQ_MASK_SET__port_status__DEFAULT
#define R_USB_IRQ_MASK_SET__port_status__DEFAULT set
#endif

/* set nop */
#ifndef R_USB_IRQ_MASK_SET__ctl_status__DEFAULT
#define R_USB_IRQ_MASK_SET__ctl_status__DEFAULT set
#endif

/*
** Default values for register  R_USB_IRQ_MASK_SET_DEV
*/

/* set nop */
#ifndef R_USB_IRQ_MASK_SET_DEV__out_eot__DEFAULT
#define R_USB_IRQ_MASK_SET_DEV__out_eot__DEFAULT set
#endif

/* set nop */
#ifndef R_USB_IRQ_MASK_SET_DEV__ep3_in_eot__DEFAULT
#define R_USB_IRQ_MASK_SET_DEV__ep3_in_eot__DEFAULT set
#endif

/* set nop */
#ifndef R_USB_IRQ_MASK_SET_DEV__ep2_in_eot__DEFAULT
#define R_USB_IRQ_MASK_SET_DEV__ep2_in_eot__DEFAULT set
#endif

/* set nop */
#ifndef R_USB_IRQ_MASK_SET_DEV__ep1_in_eot__DEFAULT
#define R_USB_IRQ_MASK_SET_DEV__ep1_in_eot__DEFAULT set
#endif

/* set nop */
#ifndef R_USB_IRQ_MASK_SET_DEV__ep0_in_eot__DEFAULT
#define R_USB_IRQ_MASK_SET_DEV__ep0_in_eot__DEFAULT set
#endif

/* set nop */
#ifndef R_USB_IRQ_MASK_SET_DEV__epid_attn__DEFAULT
#define R_USB_IRQ_MASK_SET_DEV__epid_attn__DEFAULT set
#endif

/* set nop */
#ifndef R_USB_IRQ_MASK_SET_DEV__sof__DEFAULT
#define R_USB_IRQ_MASK_SET_DEV__sof__DEFAULT set
#endif

/* set nop */
#ifndef R_USB_IRQ_MASK_SET_DEV__port_status__DEFAULT
#define R_USB_IRQ_MASK_SET_DEV__port_status__DEFAULT set
#endif

/* set nop */
#ifndef R_USB_IRQ_MASK_SET_DEV__ctl_status__DEFAULT
#define R_USB_IRQ_MASK_SET_DEV__ctl_status__DEFAULT set
#endif

/*
** Default values for register  R_USB_PORT1_DISABLE
*/

/* yes no */
#ifndef R_USB_PORT1_DISABLE__disable__DEFAULT
#define R_USB_PORT1_DISABLE__disable__DEFAULT yes
#endif

/*
** Default values for register  R_USB_PORT2_DISABLE
*/

/* yes no */
#ifndef R_USB_PORT2_DISABLE__disable__DEFAULT
#define R_USB_PORT2_DISABLE__disable__DEFAULT yes
#endif

/*
** Default values for register  R_VECT_MASK_CLR
*/

/* clr nop */
#ifndef R_VECT_MASK_CLR__usb__DEFAULT
#define R_VECT_MASK_CLR__usb__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__dma9__DEFAULT
#define R_VECT_MASK_CLR__dma9__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__dma8__DEFAULT
#define R_VECT_MASK_CLR__dma8__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__dma7__DEFAULT
#define R_VECT_MASK_CLR__dma7__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__dma6__DEFAULT
#define R_VECT_MASK_CLR__dma6__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__dma5__DEFAULT
#define R_VECT_MASK_CLR__dma5__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__dma4__DEFAULT
#define R_VECT_MASK_CLR__dma4__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__dma3__DEFAULT
#define R_VECT_MASK_CLR__dma3__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__dma2__DEFAULT
#define R_VECT_MASK_CLR__dma2__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__dma1__DEFAULT
#define R_VECT_MASK_CLR__dma1__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__dma0__DEFAULT
#define R_VECT_MASK_CLR__dma0__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__ext_dma1__DEFAULT
#define R_VECT_MASK_CLR__ext_dma1__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__ext_dma0__DEFAULT
#define R_VECT_MASK_CLR__ext_dma0__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__pa__DEFAULT
#define R_VECT_MASK_CLR__pa__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__irq_intnr__DEFAULT
#define R_VECT_MASK_CLR__irq_intnr__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__sw__DEFAULT
#define R_VECT_MASK_CLR__sw__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__serial__DEFAULT
#define R_VECT_MASK_CLR__serial__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__snmp__DEFAULT
#define R_VECT_MASK_CLR__snmp__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__network__DEFAULT
#define R_VECT_MASK_CLR__network__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__scsi1__DEFAULT
#define R_VECT_MASK_CLR__scsi1__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__scsi0__DEFAULT
#define R_VECT_MASK_CLR__scsi0__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__timer1__DEFAULT
#define R_VECT_MASK_CLR__timer1__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__timer0__DEFAULT
#define R_VECT_MASK_CLR__timer0__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__nmi__DEFAULT
#define R_VECT_MASK_CLR__nmi__DEFAULT clr
#endif

/* clr nop */
#ifndef R_VECT_MASK_CLR__some__DEFAULT
#define R_VECT_MASK_CLR__some__DEFAULT clr
#endif

/*
** Default values for register  R_VECT_MASK_SET
*/

/* set nop */
#ifndef R_VECT_MASK_SET__usb__DEFAULT
#define R_VECT_MASK_SET__usb__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__dma9__DEFAULT
#define R_VECT_MASK_SET__dma9__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__dma8__DEFAULT
#define R_VECT_MASK_SET__dma8__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__dma7__DEFAULT
#define R_VECT_MASK_SET__dma7__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__dma6__DEFAULT
#define R_VECT_MASK_SET__dma6__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__dma5__DEFAULT
#define R_VECT_MASK_SET__dma5__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__dma4__DEFAULT
#define R_VECT_MASK_SET__dma4__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__dma3__DEFAULT
#define R_VECT_MASK_SET__dma3__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__dma2__DEFAULT
#define R_VECT_MASK_SET__dma2__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__dma1__DEFAULT
#define R_VECT_MASK_SET__dma1__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__dma0__DEFAULT
#define R_VECT_MASK_SET__dma0__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__ext_dma1__DEFAULT
#define R_VECT_MASK_SET__ext_dma1__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__ext_dma0__DEFAULT
#define R_VECT_MASK_SET__ext_dma0__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__pa__DEFAULT
#define R_VECT_MASK_SET__pa__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__irq_intnr__DEFAULT
#define R_VECT_MASK_SET__irq_intnr__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__sw__DEFAULT
#define R_VECT_MASK_SET__sw__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__serial__DEFAULT
#define R_VECT_MASK_SET__serial__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__snmp__DEFAULT
#define R_VECT_MASK_SET__snmp__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__network__DEFAULT
#define R_VECT_MASK_SET__network__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__scsi1__DEFAULT
#define R_VECT_MASK_SET__scsi1__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__scsi0__DEFAULT
#define R_VECT_MASK_SET__scsi0__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__timer1__DEFAULT
#define R_VECT_MASK_SET__timer1__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__timer0__DEFAULT
#define R_VECT_MASK_SET__timer0__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__nmi__DEFAULT
#define R_VECT_MASK_SET__nmi__DEFAULT set
#endif

/* set nop */
#ifndef R_VECT_MASK_SET__some__DEFAULT
#define R_VECT_MASK_SET__some__DEFAULT set
#endif

/*
** Default values for register  R_WAITSTATES
*/

/*  0 - 3 */
#ifndef R_WAITSTATES__pcs4_7_zw__DEFAULT
#define R_WAITSTATES__pcs4_7_zw__DEFAULT 0
#endif

/*  0 - 3 */
#ifndef R_WAITSTATES__pcs4_7_ew__DEFAULT
#define R_WAITSTATES__pcs4_7_ew__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_WAITSTATES__pcs4_7_lw__DEFAULT
#define R_WAITSTATES__pcs4_7_lw__DEFAULT 0
#endif

/*  0 - 3 */
#ifndef R_WAITSTATES__pcs0_3_zw__DEFAULT
#define R_WAITSTATES__pcs0_3_zw__DEFAULT 0
#endif

/*  0 - 3 */
#ifndef R_WAITSTATES__pcs0_3_ew__DEFAULT
#define R_WAITSTATES__pcs0_3_ew__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_WAITSTATES__pcs0_3_lw__DEFAULT
#define R_WAITSTATES__pcs0_3_lw__DEFAULT 0
#endif

/*  0 - 3 */
#ifndef R_WAITSTATES__sram_zw__DEFAULT
#define R_WAITSTATES__sram_zw__DEFAULT 0
#endif

/*  0 - 3 */
#ifndef R_WAITSTATES__sram_ew__DEFAULT
#define R_WAITSTATES__sram_ew__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_WAITSTATES__sram_lw__DEFAULT
#define R_WAITSTATES__sram_lw__DEFAULT 0
#endif

/*  0 - 3 */
#ifndef R_WAITSTATES__flash_zw__DEFAULT
#define R_WAITSTATES__flash_zw__DEFAULT 0
#endif

/*  0 - 3 */
#ifndef R_WAITSTATES__flash_ew__DEFAULT
#define R_WAITSTATES__flash_ew__DEFAULT 0
#endif

/*  0 - 15 */
#ifndef R_WAITSTATES__flash_lw__DEFAULT
#define R_WAITSTATES__flash_lw__DEFAULT 0
#endif

/*
** Default values for register  R_WATCHDOG
*/

/*  0 - 7 */
#ifndef R_WATCHDOG__key__DEFAULT
#define R_WATCHDOG__key__DEFAULT 0
#endif

/* start stop */
#ifndef R_WATCHDOG__enable__DEFAULT
#define R_WATCHDOG__enable__DEFAULT start
#endif

/********************** TYPE DEFINITION SECTION ************************/

/********************** LOCAL FUNCTION DECLARATION SECTION *************/

/********************** GLOBAL VARIABLE DECLARATION SECTION ************/

/********************** FUNCTION DEFINITION SECTION ********************/

#endif
