/*!**********************************************************************
*!
*! FILE NAME: hwregs.c
*!
*! DESCRIPTION: Shadow register and initiated flag variables,
*!              and a function for initialization of these variables.
*!              
*!
*! FUNCTIONS: void init_shadow__hwregs( void )
*!
*! NOTE: This file is automatically generated, do _not_ edit.
*!       Created: Thu Oct  3 01:21:27 2002
*!       By:      Id: shadow_gen,v 1.14 2002/10/02 20:31:22 hp Exp 
*!       From:    /n/asic/projects/etrax_ng/doc/work/etrax_ng_regs.rd 1.168
*!                /n/asic/projects/etrax_ng/include//hwregs.ctrl 1.3
*!
*! NOTE: init_shadow__hwregs() initiate all write only registers
*!       described in /n/asic/projects/etrax_ng/doc/work/etrax_ng_regs.rd.
*!       Since one physical register may have several logical names you
*!       must choose which of the logical registers to initiate. 
*!       This is done by the 'USE_GROUP__group-name' macro in the
*!       hwregs_def.h file.
*!       
*!       As an example, in Etrax100 the following logical registers are
*!       all the same physical register at address 0xb0000044:
*!
*!         R_ATA_CONFIG
*!         R_PAR0_CONFIG
*!         R_SCSI0_CTRL
*!         R_SHARED_RAM_ADDR
*!
*!----------------------------------------------------------------------
*! HISTORY
*!
*! DATE           NAME                 CHANGES
*! ----           ----                 -------
*! Apr 01 1998    Jan Bengtsson        Initial version
*!----------------------------------------------------------------------
*!
*! (C) Copyright 1998, Axis Communications AB, LUND, SWEDEN
*!
*!**********************************************************************/
/* %Z% %M% %I% %G% */

/********************** INCLUDE FILES SECTION **************************/

#include "compiler.h"
#include "hwregs.h"

#if REG_DEBUG
#include <string.h>
#endif

/********************** CONSTANT AND MACRO SECTION *********************/

/********************** TYPE DEFINITION SECTION ************************/

/********************** LOCAL FUNCTION DECLARATION SECTION *************/

/********************** GLOBAL VARIABLE DECLARATION SECTION ************/

#ifndef REG_NO_SHADOW
/* Shadows for write only registers. */
reg_shadow_type__hwregs reg_shadow__hwregs;
#else
/* Use constant zero as shadow when there isn't a shadow register. */
reg_shadow_type__hwregs reg_shadow__hwregs = 0;
#endif

#if REG_DEBUG
#ifndef REG_NO_SHADOW
/* Initiated flags for shadow registers. */
reg_initiated_type__hwregs reg_initiated__hwregs;
#else
/* No need for initiated flags when there isn't a shadow register. */
reg_initiated_type__hwregs reg_initiated__hwregs = 0;
#endif
#endif

/********************** FUNCTION DEFINITION SECTION ********************/

/*#**********************************************************************
*#
*# FUNCTION NAME: init_shadow__hwregs
*#
*# PARAMETERS   : none
*#
*# RETURNS      : nothing
*#
*# SIDE EFFECTS : Writes initial values to all write only registers
*#                and their associated shadow registers. If REG_DEBUG
*#                is non zero the reg_initiated struct is also initiated.
*#
*# DESCRIPTION  : Initiate write only registers, their shadows, and in
*#                debug mode the initiated flags. Default values for
*#                the initialization are defined in hwregs_def.h.
*#
*#                Note that one physical register may have several 
*#                logical names, and that you have to modify this
*#                function to only initiate the physical register once!
*#
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*#
*#**********************************************************************/

void init_shadow__hwregs( void )
{
#if REG_DEBUG && !defined(REG_NO_SHADOW)
  /* Initiate reg_initiated__hwregs struct to 0xff. */
  memset( &reg_initiated__hwregs, 0xff, sizeof(reg_initiated_type__hwregs) );
#endif

#ifndef REG_NO_INIT_SHADOW

#if USE_GROUP__Serial_port_registers
  REG_SET__R_ALT_SER_BAUDRATE(
    ser3_tr, R_ALT_SER_BAUDRATE__ser3_tr__DEFAULT,
    ser3_rec, R_ALT_SER_BAUDRATE__ser3_rec__DEFAULT,
    ser2_tr, R_ALT_SER_BAUDRATE__ser2_tr__DEFAULT,
    ser2_rec, R_ALT_SER_BAUDRATE__ser2_rec__DEFAULT,
    ser1_tr, R_ALT_SER_BAUDRATE__ser1_tr__DEFAULT,
    ser1_rec, R_ALT_SER_BAUDRATE__ser1_rec__DEFAULT,
    ser0_tr, R_ALT_SER_BAUDRATE__ser0_tr__DEFAULT,
    ser0_rec, R_ALT_SER_BAUDRATE__ser0_rec__DEFAULT
  );
#endif

#if USE_GROUP__ATA_interface_registers
  REG_SET__R_ATA_CONFIG(
    enable, R_ATA_CONFIG__enable__DEFAULT,
    dma_strobe, R_ATA_CONFIG__dma_strobe__DEFAULT,
    dma_hold, R_ATA_CONFIG__dma_hold__DEFAULT,
    pio_setup, R_ATA_CONFIG__pio_setup__DEFAULT,
    pio_strobe, R_ATA_CONFIG__pio_strobe__DEFAULT,
    pio_hold, R_ATA_CONFIG__pio_hold__DEFAULT
  );
#endif

#if USE_GROUP__ATA_interface_registers
  REG_SET__R_ATA_CTRL_DATA(
    sel, R_ATA_CTRL_DATA__sel__DEFAULT,
    cs1, R_ATA_CTRL_DATA__cs1__DEFAULT,
    cs0, R_ATA_CTRL_DATA__cs0__DEFAULT,
    addr, R_ATA_CTRL_DATA__addr__DEFAULT,
    rw, R_ATA_CTRL_DATA__rw__DEFAULT,
    src_dst, R_ATA_CTRL_DATA__src_dst__DEFAULT,
    handsh, R_ATA_CTRL_DATA__handsh__DEFAULT,
    multi, R_ATA_CTRL_DATA__multi__DEFAULT,
    dma_size, R_ATA_CTRL_DATA__dma_size__DEFAULT,
    data, R_ATA_CTRL_DATA__data__DEFAULT
  );
#endif

#if USE_GROUP__Bus_interface_configuration_registers
  REG_SET__R_BUS_CONFIG(
    sram_type, R_BUS_CONFIG__sram_type__DEFAULT,
    dma_burst, R_BUS_CONFIG__dma_burst__DEFAULT,
    pcs4_7_wr, R_BUS_CONFIG__pcs4_7_wr__DEFAULT,
    pcs0_3_wr, R_BUS_CONFIG__pcs0_3_wr__DEFAULT,
    sram_wr, R_BUS_CONFIG__sram_wr__DEFAULT,
    flash_wr, R_BUS_CONFIG__flash_wr__DEFAULT,
    pcs4_7_bw, R_BUS_CONFIG__pcs4_7_bw__DEFAULT,
    pcs0_3_bw, R_BUS_CONFIG__pcs0_3_bw__DEFAULT,
    sram_bw, R_BUS_CONFIG__sram_bw__DEFAULT,
    flash_bw, R_BUS_CONFIG__flash_bw__DEFAULT
  );
#endif

#if USE_GROUP__Timer_registers
  REG_SET__R_CLOCK_PRESCALE(
    ser_presc, R_CLOCK_PRESCALE__ser_presc__DEFAULT,
    tim_presc, R_CLOCK_PRESCALE__tim_presc__DEFAULT
  );
#endif

#if USE_GROUP__DMA_registers
  REG_SET__R_DMA_CH0_CLR_INTR(
    clr_eop, R_DMA_CH0_CLR_INTR__clr_eop__DEFAULT,
    clr_descr, R_DMA_CH0_CLR_INTR__clr_descr__DEFAULT
  );
#endif

#if USE_GROUP__DMA_registers
  REG_SET__R_DMA_CH1_CLR_INTR(
    clr_eop, R_DMA_CH1_CLR_INTR__clr_eop__DEFAULT,
    clr_descr, R_DMA_CH1_CLR_INTR__clr_descr__DEFAULT
  );
#endif

#if USE_GROUP__DMA_registers
  REG_SET__R_DMA_CH2_CLR_INTR(
    clr_eop, R_DMA_CH2_CLR_INTR__clr_eop__DEFAULT,
    clr_descr, R_DMA_CH2_CLR_INTR__clr_descr__DEFAULT
  );
#endif

#if USE_GROUP__DMA_registers
  REG_SET__R_DMA_CH3_CLR_INTR(
    clr_eop, R_DMA_CH3_CLR_INTR__clr_eop__DEFAULT,
    clr_descr, R_DMA_CH3_CLR_INTR__clr_descr__DEFAULT
  );
#endif

#if USE_GROUP__DMA_registers
  REG_SET__R_DMA_CH4_CLR_INTR(
    clr_eop, R_DMA_CH4_CLR_INTR__clr_eop__DEFAULT,
    clr_descr, R_DMA_CH4_CLR_INTR__clr_descr__DEFAULT
  );
#endif

#if USE_GROUP__DMA_registers
  REG_SET__R_DMA_CH5_CLR_INTR(
    clr_eop, R_DMA_CH5_CLR_INTR__clr_eop__DEFAULT,
    clr_descr, R_DMA_CH5_CLR_INTR__clr_descr__DEFAULT
  );
#endif

#if USE_GROUP__DMA_registers
  REG_SET__R_DMA_CH6_CLR_INTR(
    clr_eop, R_DMA_CH6_CLR_INTR__clr_eop__DEFAULT,
    clr_descr, R_DMA_CH6_CLR_INTR__clr_descr__DEFAULT
  );
#endif

#if USE_GROUP__DMA_registers
  REG_SET__R_DMA_CH7_CLR_INTR(
    clr_eop, R_DMA_CH7_CLR_INTR__clr_eop__DEFAULT,
    clr_descr, R_DMA_CH7_CLR_INTR__clr_descr__DEFAULT
  );
#endif

#if USE_GROUP__DMA_registers
  REG_SET__R_DMA_CH8_CLR_INTR(
    clr_eop, R_DMA_CH8_CLR_INTR__clr_eop__DEFAULT,
    clr_descr, R_DMA_CH8_CLR_INTR__clr_descr__DEFAULT
  );
#endif

#if USE_GROUP__DMA_registers
  REG_SET__R_DMA_CH8_SUB0_CLR_INTR(
    clr_descr, R_DMA_CH8_SUB0_CLR_INTR__clr_descr__DEFAULT
  );
#endif

#if USE_GROUP__DMA_registers
  REG_SET__R_DMA_CH8_SUB1_CLR_INTR(
    clr_descr, R_DMA_CH8_SUB1_CLR_INTR__clr_descr__DEFAULT
  );
#endif

#if USE_GROUP__DMA_registers
  REG_SET__R_DMA_CH8_SUB2_CLR_INTR(
    clr_descr, R_DMA_CH8_SUB2_CLR_INTR__clr_descr__DEFAULT
  );
#endif

#if USE_GROUP__DMA_registers
  REG_SET__R_DMA_CH8_SUB3_CLR_INTR(
    clr_descr, R_DMA_CH8_SUB3_CLR_INTR__clr_descr__DEFAULT
  );
#endif

#if USE_GROUP__DMA_registers
  REG_SET__R_DMA_CH9_CLR_INTR(
    clr_eop, R_DMA_CH9_CLR_INTR__clr_eop__DEFAULT,
    clr_descr, R_DMA_CH9_CLR_INTR__clr_descr__DEFAULT
  );
#endif

#if USE_GROUP__Bus_interface_configuration_registers
  REG_SET__R_DRAM_CONFIG(
    wmm1, R_DRAM_CONFIG__wmm1__DEFAULT,
    wmm0, R_DRAM_CONFIG__wmm0__DEFAULT,
    sh1, R_DRAM_CONFIG__sh1__DEFAULT,
    sh0, R_DRAM_CONFIG__sh0__DEFAULT,
    w, R_DRAM_CONFIG__w__DEFAULT,
    c, R_DRAM_CONFIG__c__DEFAULT,
    e, R_DRAM_CONFIG__e__DEFAULT,
    group_sel, R_DRAM_CONFIG__group_sel__DEFAULT,
    ca1, R_DRAM_CONFIG__ca1__DEFAULT,
    bank23sel, R_DRAM_CONFIG__bank23sel__DEFAULT,
    ca0, R_DRAM_CONFIG__ca0__DEFAULT,
    bank01sel, R_DRAM_CONFIG__bank01sel__DEFAULT
  );
#endif

#if USE_GROUP__Bus_interface_configuration_registers
  REG_SET__R_DRAM_TIMING(
    sdram, R_DRAM_TIMING__sdram__DEFAULT,
    ref, R_DRAM_TIMING__ref__DEFAULT,
    rp, R_DRAM_TIMING__rp__DEFAULT,
    rs, R_DRAM_TIMING__rs__DEFAULT,
    rh, R_DRAM_TIMING__rh__DEFAULT,
    w, R_DRAM_TIMING__w__DEFAULT,
    c, R_DRAM_TIMING__c__DEFAULT,
    cz, R_DRAM_TIMING__cz__DEFAULT,
    cp, R_DRAM_TIMING__cp__DEFAULT,
    cw, R_DRAM_TIMING__cw__DEFAULT
  );
#endif

#if USE_GROUP__External_DMA_registers
  REG_SET__R_EXT_DMA_0_ADDR(
    ext0_addr, R_EXT_DMA_0_ADDR__ext0_addr__DEFAULT
  );
#endif

#if USE_GROUP__External_DMA_registers
  REG_SET__R_EXT_DMA_0_CMD(
    cnt, R_EXT_DMA_0_CMD__cnt__DEFAULT,
    rqpol, R_EXT_DMA_0_CMD__rqpol__DEFAULT,
    apol, R_EXT_DMA_0_CMD__apol__DEFAULT,
    rq_ack, R_EXT_DMA_0_CMD__rq_ack__DEFAULT,
    wid, R_EXT_DMA_0_CMD__wid__DEFAULT,
    dir, R_EXT_DMA_0_CMD__dir__DEFAULT,
    run, R_EXT_DMA_0_CMD__run__DEFAULT,
    trf_count, R_EXT_DMA_0_CMD__trf_count__DEFAULT
  );
#endif

#if USE_GROUP__External_DMA_registers
  REG_SET__R_EXT_DMA_1_ADDR(
    ext0_addr, R_EXT_DMA_1_ADDR__ext0_addr__DEFAULT
  );
#endif

#if USE_GROUP__External_DMA_registers
  REG_SET__R_EXT_DMA_1_CMD(
    cnt, R_EXT_DMA_1_CMD__cnt__DEFAULT,
    rqpol, R_EXT_DMA_1_CMD__rqpol__DEFAULT,
    apol, R_EXT_DMA_1_CMD__apol__DEFAULT,
    rq_ack, R_EXT_DMA_1_CMD__rq_ack__DEFAULT,
    wid, R_EXT_DMA_1_CMD__wid__DEFAULT,
    dir, R_EXT_DMA_1_CMD__dir__DEFAULT,
    run, R_EXT_DMA_1_CMD__run__DEFAULT,
    trf_count, R_EXT_DMA_1_CMD__trf_count__DEFAULT
  );
#endif

#if USE_GROUP__General_config_registers
  REG_SET__R_GEN_CONFIG(
    par_w, R_GEN_CONFIG__par_w__DEFAULT,
    usb2, R_GEN_CONFIG__usb2__DEFAULT,
    usb1, R_GEN_CONFIG__usb1__DEFAULT,
    g24dir, R_GEN_CONFIG__g24dir__DEFAULT,
    g16_23dir, R_GEN_CONFIG__g16_23dir__DEFAULT,
    g8_15dir, R_GEN_CONFIG__g8_15dir__DEFAULT,
    g0dir, R_GEN_CONFIG__g0dir__DEFAULT,
    dma9, R_GEN_CONFIG__dma9__DEFAULT,
    dma8, R_GEN_CONFIG__dma8__DEFAULT,
    dma7, R_GEN_CONFIG__dma7__DEFAULT,
    dma6, R_GEN_CONFIG__dma6__DEFAULT,
    dma5, R_GEN_CONFIG__dma5__DEFAULT,
    dma4, R_GEN_CONFIG__dma4__DEFAULT,
    dma3, R_GEN_CONFIG__dma3__DEFAULT,
    dma2, R_GEN_CONFIG__dma2__DEFAULT,
    mio_w, R_GEN_CONFIG__mio_w__DEFAULT,
    ser3, R_GEN_CONFIG__ser3__DEFAULT,
    par1, R_GEN_CONFIG__par1__DEFAULT,
    scsi0w, R_GEN_CONFIG__scsi0w__DEFAULT,
    scsi1, R_GEN_CONFIG__scsi1__DEFAULT,
    mio, R_GEN_CONFIG__mio__DEFAULT,
    ser2, R_GEN_CONFIG__ser2__DEFAULT,
    par0, R_GEN_CONFIG__par0__DEFAULT,
    ata, R_GEN_CONFIG__ata__DEFAULT,
    scsi0, R_GEN_CONFIG__scsi0__DEFAULT
  );
#endif

#if USE_GROUP__General_config_registers
  REG_SET__R_GEN_CONFIG_II(
    sermode3, R_GEN_CONFIG_II__sermode3__DEFAULT,
    sermode1, R_GEN_CONFIG_II__sermode1__DEFAULT,
    ext_clk, R_GEN_CONFIG_II__ext_clk__DEFAULT,
    ser3, R_GEN_CONFIG_II__ser3__DEFAULT,
    ser2, R_GEN_CONFIG_II__ser2__DEFAULT
  );
#endif

#if USE_GROUP__Interrupt_mask_and_status_registers
  REG_SET__R_IRQ_MASK0_CLR(
    nmi_pin, R_IRQ_MASK0_CLR__nmi_pin__DEFAULT,
    watchdog_nmi, R_IRQ_MASK0_CLR__watchdog_nmi__DEFAULT,
    sqe_test_error, R_IRQ_MASK0_CLR__sqe_test_error__DEFAULT,
    carrier_loss, R_IRQ_MASK0_CLR__carrier_loss__DEFAULT,
    deferred, R_IRQ_MASK0_CLR__deferred__DEFAULT,
    late_col, R_IRQ_MASK0_CLR__late_col__DEFAULT,
    multiple_col, R_IRQ_MASK0_CLR__multiple_col__DEFAULT,
    single_col, R_IRQ_MASK0_CLR__single_col__DEFAULT,
    congestion, R_IRQ_MASK0_CLR__congestion__DEFAULT,
    oversize, R_IRQ_MASK0_CLR__oversize__DEFAULT,
    alignment_error, R_IRQ_MASK0_CLR__alignment_error__DEFAULT,
    crc_error, R_IRQ_MASK0_CLR__crc_error__DEFAULT,
    overrun, R_IRQ_MASK0_CLR__overrun__DEFAULT,
    underrun, R_IRQ_MASK0_CLR__underrun__DEFAULT,
    excessive_col, R_IRQ_MASK0_CLR__excessive_col__DEFAULT,
    mdio, R_IRQ_MASK0_CLR__mdio__DEFAULT,
    ata_drq3, R_IRQ_MASK0_CLR__ata_drq3__DEFAULT,
    ata_drq2, R_IRQ_MASK0_CLR__ata_drq2__DEFAULT,
    ata_drq1, R_IRQ_MASK0_CLR__ata_drq1__DEFAULT,
    ata_drq0, R_IRQ_MASK0_CLR__ata_drq0__DEFAULT,
    par0_ecp_cmd, R_IRQ_MASK0_CLR__par0_ecp_cmd__DEFAULT,
    par0_peri, R_IRQ_MASK0_CLR__par0_peri__DEFAULT,
    par0_data, R_IRQ_MASK0_CLR__par0_data__DEFAULT,
    par0_ready, R_IRQ_MASK0_CLR__par0_ready__DEFAULT,
    ata_dmaend, R_IRQ_MASK0_CLR__ata_dmaend__DEFAULT,
    irq_ext_vector_nr, R_IRQ_MASK0_CLR__irq_ext_vector_nr__DEFAULT,
    irq_int_vector_nr, R_IRQ_MASK0_CLR__irq_int_vector_nr__DEFAULT,
    ext_dma1, R_IRQ_MASK0_CLR__ext_dma1__DEFAULT,
    ext_dma0, R_IRQ_MASK0_CLR__ext_dma0__DEFAULT,
    timer1, R_IRQ_MASK0_CLR__timer1__DEFAULT,
    timer0, R_IRQ_MASK0_CLR__timer0__DEFAULT
  );
#endif

#if USE_GROUP__Interrupt_mask_and_status_registers
  REG_SET__R_IRQ_MASK0_SET(
    nmi_pin, R_IRQ_MASK0_SET__nmi_pin__DEFAULT,
    watchdog_nmi, R_IRQ_MASK0_SET__watchdog_nmi__DEFAULT,
    sqe_test_error, R_IRQ_MASK0_SET__sqe_test_error__DEFAULT,
    carrier_loss, R_IRQ_MASK0_SET__carrier_loss__DEFAULT,
    deferred, R_IRQ_MASK0_SET__deferred__DEFAULT,
    late_col, R_IRQ_MASK0_SET__late_col__DEFAULT,
    multiple_col, R_IRQ_MASK0_SET__multiple_col__DEFAULT,
    single_col, R_IRQ_MASK0_SET__single_col__DEFAULT,
    congestion, R_IRQ_MASK0_SET__congestion__DEFAULT,
    oversize, R_IRQ_MASK0_SET__oversize__DEFAULT,
    alignment_error, R_IRQ_MASK0_SET__alignment_error__DEFAULT,
    crc_error, R_IRQ_MASK0_SET__crc_error__DEFAULT,
    overrun, R_IRQ_MASK0_SET__overrun__DEFAULT,
    underrun, R_IRQ_MASK0_SET__underrun__DEFAULT,
    excessive_col, R_IRQ_MASK0_SET__excessive_col__DEFAULT,
    mdio, R_IRQ_MASK0_SET__mdio__DEFAULT,
    ata_drq3, R_IRQ_MASK0_SET__ata_drq3__DEFAULT,
    ata_drq2, R_IRQ_MASK0_SET__ata_drq2__DEFAULT,
    ata_drq1, R_IRQ_MASK0_SET__ata_drq1__DEFAULT,
    ata_drq0, R_IRQ_MASK0_SET__ata_drq0__DEFAULT,
    par0_ecp_cmd, R_IRQ_MASK0_SET__par0_ecp_cmd__DEFAULT,
    par0_peri, R_IRQ_MASK0_SET__par0_peri__DEFAULT,
    par0_data, R_IRQ_MASK0_SET__par0_data__DEFAULT,
    par0_ready, R_IRQ_MASK0_SET__par0_ready__DEFAULT,
    ata_dmaend, R_IRQ_MASK0_SET__ata_dmaend__DEFAULT,
    irq_ext_vector_nr, R_IRQ_MASK0_SET__irq_ext_vector_nr__DEFAULT,
    irq_int_vector_nr, R_IRQ_MASK0_SET__irq_int_vector_nr__DEFAULT,
    ext_dma1, R_IRQ_MASK0_SET__ext_dma1__DEFAULT,
    ext_dma0, R_IRQ_MASK0_SET__ext_dma0__DEFAULT,
    timer1, R_IRQ_MASK0_SET__timer1__DEFAULT,
    timer0, R_IRQ_MASK0_SET__timer0__DEFAULT
  );
#endif

#if USE_GROUP__Interrupt_mask_and_status_registers
  REG_SET__R_IRQ_MASK1_CLR(
    sw_int7, R_IRQ_MASK1_CLR__sw_int7__DEFAULT,
    sw_int6, R_IRQ_MASK1_CLR__sw_int6__DEFAULT,
    sw_int5, R_IRQ_MASK1_CLR__sw_int5__DEFAULT,
    sw_int4, R_IRQ_MASK1_CLR__sw_int4__DEFAULT,
    sw_int3, R_IRQ_MASK1_CLR__sw_int3__DEFAULT,
    sw_int2, R_IRQ_MASK1_CLR__sw_int2__DEFAULT,
    sw_int1, R_IRQ_MASK1_CLR__sw_int1__DEFAULT,
    sw_int0, R_IRQ_MASK1_CLR__sw_int0__DEFAULT,
    par1_ecp_cmd, R_IRQ_MASK1_CLR__par1_ecp_cmd__DEFAULT,
    par1_peri, R_IRQ_MASK1_CLR__par1_peri__DEFAULT,
    par1_data, R_IRQ_MASK1_CLR__par1_data__DEFAULT,
    par1_ready, R_IRQ_MASK1_CLR__par1_ready__DEFAULT,
    ser3_ready, R_IRQ_MASK1_CLR__ser3_ready__DEFAULT,
    ser3_data, R_IRQ_MASK1_CLR__ser3_data__DEFAULT,
    ser2_ready, R_IRQ_MASK1_CLR__ser2_ready__DEFAULT,
    ser2_data, R_IRQ_MASK1_CLR__ser2_data__DEFAULT,
    ser1_ready, R_IRQ_MASK1_CLR__ser1_ready__DEFAULT,
    ser1_data, R_IRQ_MASK1_CLR__ser1_data__DEFAULT,
    ser0_ready, R_IRQ_MASK1_CLR__ser0_ready__DEFAULT,
    ser0_data, R_IRQ_MASK1_CLR__ser0_data__DEFAULT,
    pa7, R_IRQ_MASK1_CLR__pa7__DEFAULT,
    pa6, R_IRQ_MASK1_CLR__pa6__DEFAULT,
    pa5, R_IRQ_MASK1_CLR__pa5__DEFAULT,
    pa4, R_IRQ_MASK1_CLR__pa4__DEFAULT,
    pa3, R_IRQ_MASK1_CLR__pa3__DEFAULT,
    pa2, R_IRQ_MASK1_CLR__pa2__DEFAULT,
    pa1, R_IRQ_MASK1_CLR__pa1__DEFAULT,
    pa0, R_IRQ_MASK1_CLR__pa0__DEFAULT
  );
#endif

#if USE_GROUP__Interrupt_mask_and_status_registers
  REG_SET__R_IRQ_MASK1_SET(
    sw_int7, R_IRQ_MASK1_SET__sw_int7__DEFAULT,
    sw_int6, R_IRQ_MASK1_SET__sw_int6__DEFAULT,
    sw_int5, R_IRQ_MASK1_SET__sw_int5__DEFAULT,
    sw_int4, R_IRQ_MASK1_SET__sw_int4__DEFAULT,
    sw_int3, R_IRQ_MASK1_SET__sw_int3__DEFAULT,
    sw_int2, R_IRQ_MASK1_SET__sw_int2__DEFAULT,
    sw_int1, R_IRQ_MASK1_SET__sw_int1__DEFAULT,
    sw_int0, R_IRQ_MASK1_SET__sw_int0__DEFAULT,
    par1_ecp_cmd, R_IRQ_MASK1_SET__par1_ecp_cmd__DEFAULT,
    par1_peri, R_IRQ_MASK1_SET__par1_peri__DEFAULT,
    par1_data, R_IRQ_MASK1_SET__par1_data__DEFAULT,
    par1_ready, R_IRQ_MASK1_SET__par1_ready__DEFAULT,
    ser3_ready, R_IRQ_MASK1_SET__ser3_ready__DEFAULT,
    ser3_data, R_IRQ_MASK1_SET__ser3_data__DEFAULT,
    ser2_ready, R_IRQ_MASK1_SET__ser2_ready__DEFAULT,
    ser2_data, R_IRQ_MASK1_SET__ser2_data__DEFAULT,
    ser1_ready, R_IRQ_MASK1_SET__ser1_ready__DEFAULT,
    ser1_data, R_IRQ_MASK1_SET__ser1_data__DEFAULT,
    ser0_ready, R_IRQ_MASK1_SET__ser0_ready__DEFAULT,
    ser0_data, R_IRQ_MASK1_SET__ser0_data__DEFAULT,
    pa7, R_IRQ_MASK1_SET__pa7__DEFAULT,
    pa6, R_IRQ_MASK1_SET__pa6__DEFAULT,
    pa5, R_IRQ_MASK1_SET__pa5__DEFAULT,
    pa4, R_IRQ_MASK1_SET__pa4__DEFAULT,
    pa3, R_IRQ_MASK1_SET__pa3__DEFAULT,
    pa2, R_IRQ_MASK1_SET__pa2__DEFAULT,
    pa1, R_IRQ_MASK1_SET__pa1__DEFAULT,
    pa0, R_IRQ_MASK1_SET__pa0__DEFAULT
  );
#endif

#if USE_GROUP__Interrupt_mask_and_status_registers
  REG_SET__R_IRQ_MASK2_CLR(
    dma8_sub3_descr, R_IRQ_MASK2_CLR__dma8_sub3_descr__DEFAULT,
    dma8_sub2_descr, R_IRQ_MASK2_CLR__dma8_sub2_descr__DEFAULT,
    dma8_sub1_descr, R_IRQ_MASK2_CLR__dma8_sub1_descr__DEFAULT,
    dma8_sub0_descr, R_IRQ_MASK2_CLR__dma8_sub0_descr__DEFAULT,
    dma9_eop, R_IRQ_MASK2_CLR__dma9_eop__DEFAULT,
    dma9_descr, R_IRQ_MASK2_CLR__dma9_descr__DEFAULT,
    dma8_eop, R_IRQ_MASK2_CLR__dma8_eop__DEFAULT,
    dma8_descr, R_IRQ_MASK2_CLR__dma8_descr__DEFAULT,
    dma7_eop, R_IRQ_MASK2_CLR__dma7_eop__DEFAULT,
    dma7_descr, R_IRQ_MASK2_CLR__dma7_descr__DEFAULT,
    dma6_eop, R_IRQ_MASK2_CLR__dma6_eop__DEFAULT,
    dma6_descr, R_IRQ_MASK2_CLR__dma6_descr__DEFAULT,
    dma5_eop, R_IRQ_MASK2_CLR__dma5_eop__DEFAULT,
    dma5_descr, R_IRQ_MASK2_CLR__dma5_descr__DEFAULT,
    dma4_eop, R_IRQ_MASK2_CLR__dma4_eop__DEFAULT,
    dma4_descr, R_IRQ_MASK2_CLR__dma4_descr__DEFAULT,
    dma3_eop, R_IRQ_MASK2_CLR__dma3_eop__DEFAULT,
    dma3_descr, R_IRQ_MASK2_CLR__dma3_descr__DEFAULT,
    dma2_eop, R_IRQ_MASK2_CLR__dma2_eop__DEFAULT,
    dma2_descr, R_IRQ_MASK2_CLR__dma2_descr__DEFAULT,
    dma1_eop, R_IRQ_MASK2_CLR__dma1_eop__DEFAULT,
    dma1_descr, R_IRQ_MASK2_CLR__dma1_descr__DEFAULT,
    dma0_eop, R_IRQ_MASK2_CLR__dma0_eop__DEFAULT,
    dma0_descr, R_IRQ_MASK2_CLR__dma0_descr__DEFAULT
  );
#endif

#if USE_GROUP__Interrupt_mask_and_status_registers
  REG_SET__R_IRQ_MASK2_SET(
    dma8_sub3_descr, R_IRQ_MASK2_SET__dma8_sub3_descr__DEFAULT,
    dma8_sub2_descr, R_IRQ_MASK2_SET__dma8_sub2_descr__DEFAULT,
    dma8_sub1_descr, R_IRQ_MASK2_SET__dma8_sub1_descr__DEFAULT,
    dma8_sub0_descr, R_IRQ_MASK2_SET__dma8_sub0_descr__DEFAULT,
    dma9_eop, R_IRQ_MASK2_SET__dma9_eop__DEFAULT,
    dma9_descr, R_IRQ_MASK2_SET__dma9_descr__DEFAULT,
    dma8_eop, R_IRQ_MASK2_SET__dma8_eop__DEFAULT,
    dma8_descr, R_IRQ_MASK2_SET__dma8_descr__DEFAULT,
    dma7_eop, R_IRQ_MASK2_SET__dma7_eop__DEFAULT,
    dma7_descr, R_IRQ_MASK2_SET__dma7_descr__DEFAULT,
    dma6_eop, R_IRQ_MASK2_SET__dma6_eop__DEFAULT,
    dma6_descr, R_IRQ_MASK2_SET__dma6_descr__DEFAULT,
    dma5_eop, R_IRQ_MASK2_SET__dma5_eop__DEFAULT,
    dma5_descr, R_IRQ_MASK2_SET__dma5_descr__DEFAULT,
    dma4_eop, R_IRQ_MASK2_SET__dma4_eop__DEFAULT,
    dma4_descr, R_IRQ_MASK2_SET__dma4_descr__DEFAULT,
    dma3_eop, R_IRQ_MASK2_SET__dma3_eop__DEFAULT,
    dma3_descr, R_IRQ_MASK2_SET__dma3_descr__DEFAULT,
    dma2_eop, R_IRQ_MASK2_SET__dma2_eop__DEFAULT,
    dma2_descr, R_IRQ_MASK2_SET__dma2_descr__DEFAULT,
    dma1_eop, R_IRQ_MASK2_SET__dma1_eop__DEFAULT,
    dma1_descr, R_IRQ_MASK2_SET__dma1_descr__DEFAULT,
    dma0_eop, R_IRQ_MASK2_SET__dma0_eop__DEFAULT,
    dma0_descr, R_IRQ_MASK2_SET__dma0_descr__DEFAULT
  );
#endif

#if USE_GROUP__MMU_registers
  REG_SET__R_MMU_CONFIG(
    mmu_enable, R_MMU_CONFIG__mmu_enable__DEFAULT,
    inv_excp, R_MMU_CONFIG__inv_excp__DEFAULT,
    acc_excp, R_MMU_CONFIG__acc_excp__DEFAULT,
    we_excp, R_MMU_CONFIG__we_excp__DEFAULT,
    seg_f, R_MMU_CONFIG__seg_f__DEFAULT,
    seg_e, R_MMU_CONFIG__seg_e__DEFAULT,
    seg_d, R_MMU_CONFIG__seg_d__DEFAULT,
    seg_c, R_MMU_CONFIG__seg_c__DEFAULT,
    seg_b, R_MMU_CONFIG__seg_b__DEFAULT,
    seg_a, R_MMU_CONFIG__seg_a__DEFAULT,
    seg_9, R_MMU_CONFIG__seg_9__DEFAULT,
    seg_8, R_MMU_CONFIG__seg_8__DEFAULT,
    seg_7, R_MMU_CONFIG__seg_7__DEFAULT,
    seg_6, R_MMU_CONFIG__seg_6__DEFAULT,
    seg_5, R_MMU_CONFIG__seg_5__DEFAULT,
    seg_4, R_MMU_CONFIG__seg_4__DEFAULT,
    seg_3, R_MMU_CONFIG__seg_3__DEFAULT,
    seg_2, R_MMU_CONFIG__seg_2__DEFAULT,
    seg_1, R_MMU_CONFIG__seg_1__DEFAULT,
    seg_0, R_MMU_CONFIG__seg_0__DEFAULT
  );
#endif

#if USE_GROUP__MMU_registers
  REG_SET__R_MMU_CTRL(
    inv_excp, R_MMU_CTRL__inv_excp__DEFAULT,
    acc_excp, R_MMU_CTRL__acc_excp__DEFAULT,
    we_excp, R_MMU_CTRL__we_excp__DEFAULT
  );
#endif

#if USE_GROUP__MMU_registers
  REG_SET__R_MMU_ENABLE(
    mmu_enable, R_MMU_ENABLE__mmu_enable__DEFAULT
  );
#endif

#if USE_GROUP__MMU_registers
  REG_SET__R_MMU_KBASE_HI(
    base_f, R_MMU_KBASE_HI__base_f__DEFAULT,
    base_e, R_MMU_KBASE_HI__base_e__DEFAULT,
    base_d, R_MMU_KBASE_HI__base_d__DEFAULT,
    base_c, R_MMU_KBASE_HI__base_c__DEFAULT,
    base_b, R_MMU_KBASE_HI__base_b__DEFAULT,
    base_a, R_MMU_KBASE_HI__base_a__DEFAULT,
    base_9, R_MMU_KBASE_HI__base_9__DEFAULT,
    base_8, R_MMU_KBASE_HI__base_8__DEFAULT
  );
#endif

#if USE_GROUP__MMU_registers
  REG_SET__R_MMU_KBASE_LO(
    base_7, R_MMU_KBASE_LO__base_7__DEFAULT,
    base_6, R_MMU_KBASE_LO__base_6__DEFAULT,
    base_5, R_MMU_KBASE_LO__base_5__DEFAULT,
    base_4, R_MMU_KBASE_LO__base_4__DEFAULT,
    base_3, R_MMU_KBASE_LO__base_3__DEFAULT,
    base_2, R_MMU_KBASE_LO__base_2__DEFAULT,
    base_1, R_MMU_KBASE_LO__base_1__DEFAULT,
    base_0, R_MMU_KBASE_LO__base_0__DEFAULT
  );
#endif

#if USE_GROUP__MMU_registers
  REG_SET__R_MMU_KSEG(
    seg_f, R_MMU_KSEG__seg_f__DEFAULT,
    seg_e, R_MMU_KSEG__seg_e__DEFAULT,
    seg_d, R_MMU_KSEG__seg_d__DEFAULT,
    seg_c, R_MMU_KSEG__seg_c__DEFAULT,
    seg_b, R_MMU_KSEG__seg_b__DEFAULT,
    seg_a, R_MMU_KSEG__seg_a__DEFAULT,
    seg_9, R_MMU_KSEG__seg_9__DEFAULT,
    seg_8, R_MMU_KSEG__seg_8__DEFAULT,
    seg_7, R_MMU_KSEG__seg_7__DEFAULT,
    seg_6, R_MMU_KSEG__seg_6__DEFAULT,
    seg_5, R_MMU_KSEG__seg_5__DEFAULT,
    seg_4, R_MMU_KSEG__seg_4__DEFAULT,
    seg_3, R_MMU_KSEG__seg_3__DEFAULT,
    seg_2, R_MMU_KSEG__seg_2__DEFAULT,
    seg_1, R_MMU_KSEG__seg_1__DEFAULT,
    seg_0, R_MMU_KSEG__seg_0__DEFAULT
  );
#endif

#if USE_GROUP__Network_interface_registers
  REG_SET__R_NETWORK_GA_0(
    ga_low, R_NETWORK_GA_0__ga_low__DEFAULT
  );
#endif

#if USE_GROUP__Network_interface_registers
  REG_SET__R_NETWORK_GA_1(
    ga_high, R_NETWORK_GA_1__ga_high__DEFAULT
  );
#endif

#if USE_GROUP__Network_interface_registers
  REG_SET__R_NETWORK_GEN_CONFIG(
    loopback, R_NETWORK_GEN_CONFIG__loopback__DEFAULT,
    frame, R_NETWORK_GEN_CONFIG__frame__DEFAULT,
    vg, R_NETWORK_GEN_CONFIG__vg__DEFAULT,
    phy, R_NETWORK_GEN_CONFIG__phy__DEFAULT,
    enable, R_NETWORK_GEN_CONFIG__enable__DEFAULT
  );
#endif

#if USE_GROUP__Network_interface_registers
  REG_SET__R_NETWORK_MGM_CTRL(
    txd_pins, R_NETWORK_MGM_CTRL__txd_pins__DEFAULT,
    txer_pin, R_NETWORK_MGM_CTRL__txer_pin__DEFAULT,
    mdck, R_NETWORK_MGM_CTRL__mdck__DEFAULT,
    mdoe, R_NETWORK_MGM_CTRL__mdoe__DEFAULT,
    mdio, R_NETWORK_MGM_CTRL__mdio__DEFAULT
  );
#endif

#if USE_GROUP__Network_interface_registers
  REG_SET__R_NETWORK_REC_CONFIG(
    max_size, R_NETWORK_REC_CONFIG__max_size__DEFAULT,
    duplex, R_NETWORK_REC_CONFIG__duplex__DEFAULT,
    bad_crc, R_NETWORK_REC_CONFIG__bad_crc__DEFAULT,
    oversize, R_NETWORK_REC_CONFIG__oversize__DEFAULT,
    undersize, R_NETWORK_REC_CONFIG__undersize__DEFAULT,
    all_roots, R_NETWORK_REC_CONFIG__all_roots__DEFAULT,
    tr_broadcast, R_NETWORK_REC_CONFIG__tr_broadcast__DEFAULT,
    broadcast, R_NETWORK_REC_CONFIG__broadcast__DEFAULT,
    individual, R_NETWORK_REC_CONFIG__individual__DEFAULT,
    ma1, R_NETWORK_REC_CONFIG__ma1__DEFAULT,
    ma0, R_NETWORK_REC_CONFIG__ma0__DEFAULT
  );
#endif

#if USE_GROUP__Network_interface_registers
  REG_SET__R_NETWORK_SA_0(
    ma0_low, R_NETWORK_SA_0__ma0_low__DEFAULT
  );
#endif

#if USE_GROUP__Network_interface_registers
  REG_SET__R_NETWORK_SA_1(
    ma1_low, R_NETWORK_SA_1__ma1_low__DEFAULT,
    ma0_high, R_NETWORK_SA_1__ma0_high__DEFAULT
  );
#endif

#if USE_GROUP__Network_interface_registers
  REG_SET__R_NETWORK_SA_2(
    ma1_high, R_NETWORK_SA_2__ma1_high__DEFAULT
  );
#endif

#if USE_GROUP__Network_interface_registers
  REG_SET__R_NETWORK_TR_CTRL(
    clr_error, R_NETWORK_TR_CTRL__clr_error__DEFAULT,
    delay, R_NETWORK_TR_CTRL__delay__DEFAULT,
    cancel, R_NETWORK_TR_CTRL__cancel__DEFAULT,
    cd, R_NETWORK_TR_CTRL__cd__DEFAULT,
    retry, R_NETWORK_TR_CTRL__retry__DEFAULT,
    pad, R_NETWORK_TR_CTRL__pad__DEFAULT,
    crc, R_NETWORK_TR_CTRL__crc__DEFAULT
  );
#endif

#if USE_GROUP__Parallel_printer_port_registers
  REG_SET__R_PAR0_CONFIG(
    ioe, R_PAR0_CONFIG__ioe__DEFAULT,
    iseli, R_PAR0_CONFIG__iseli__DEFAULT,
    iautofd, R_PAR0_CONFIG__iautofd__DEFAULT,
    istrb, R_PAR0_CONFIG__istrb__DEFAULT,
    iinit, R_PAR0_CONFIG__iinit__DEFAULT,
    iperr, R_PAR0_CONFIG__iperr__DEFAULT,
    iack, R_PAR0_CONFIG__iack__DEFAULT,
    ibusy, R_PAR0_CONFIG__ibusy__DEFAULT,
    ifault, R_PAR0_CONFIG__ifault__DEFAULT,
    isel, R_PAR0_CONFIG__isel__DEFAULT,
    ext_mode, R_PAR0_CONFIG__ext_mode__DEFAULT,
    wide, R_PAR0_CONFIG__wide__DEFAULT,
    dma, R_PAR0_CONFIG__dma__DEFAULT,
    rle_in, R_PAR0_CONFIG__rle_in__DEFAULT,
    rle_out, R_PAR0_CONFIG__rle_out__DEFAULT,
    enable, R_PAR0_CONFIG__enable__DEFAULT,
    force, R_PAR0_CONFIG__force__DEFAULT,
    ign_ack, R_PAR0_CONFIG__ign_ack__DEFAULT,
    oe_ack, R_PAR0_CONFIG__oe_ack__DEFAULT,
    mode, R_PAR0_CONFIG__mode__DEFAULT
  );
#endif

#if USE_GROUP__Parallel_printer_port_registers
  REG_SET__R_PAR0_CTRL(
    ctrl, R_PAR0_CTRL__ctrl__DEFAULT
  );
#endif

#if USE_GROUP__Parallel_printer_port_registers
  REG_SET__R_PAR0_CTRL_DATA(
    peri_int, R_PAR0_CTRL_DATA__peri_int__DEFAULT,
    oe, R_PAR0_CTRL_DATA__oe__DEFAULT,
    seli, R_PAR0_CTRL_DATA__seli__DEFAULT,
    autofd, R_PAR0_CTRL_DATA__autofd__DEFAULT,
    strb, R_PAR0_CTRL_DATA__strb__DEFAULT,
    init, R_PAR0_CTRL_DATA__init__DEFAULT,
    ecp_cmd, R_PAR0_CTRL_DATA__ecp_cmd__DEFAULT,
    data, R_PAR0_CTRL_DATA__data__DEFAULT
  );
#endif

#if USE_GROUP__Parallel_printer_port_registers
  REG_SET__R_PAR0_DELAY(
    fine_hold, R_PAR0_DELAY__fine_hold__DEFAULT,
    hold, R_PAR0_DELAY__hold__DEFAULT,
    fine_strb, R_PAR0_DELAY__fine_strb__DEFAULT,
    strobe, R_PAR0_DELAY__strobe__DEFAULT,
    fine_setup, R_PAR0_DELAY__fine_setup__DEFAULT,
    setup, R_PAR0_DELAY__setup__DEFAULT
  );
#endif

#if USE_GROUP__Parallel_printer_port_registers
  REG_SET__R_PAR1_CONFIG(
    ioe, R_PAR1_CONFIG__ioe__DEFAULT,
    iseli, R_PAR1_CONFIG__iseli__DEFAULT,
    iautofd, R_PAR1_CONFIG__iautofd__DEFAULT,
    istrb, R_PAR1_CONFIG__istrb__DEFAULT,
    iinit, R_PAR1_CONFIG__iinit__DEFAULT,
    iperr, R_PAR1_CONFIG__iperr__DEFAULT,
    iack, R_PAR1_CONFIG__iack__DEFAULT,
    ibusy, R_PAR1_CONFIG__ibusy__DEFAULT,
    ifault, R_PAR1_CONFIG__ifault__DEFAULT,
    isel, R_PAR1_CONFIG__isel__DEFAULT,
    ext_mode, R_PAR1_CONFIG__ext_mode__DEFAULT,
    dma, R_PAR1_CONFIG__dma__DEFAULT,
    rle_in, R_PAR1_CONFIG__rle_in__DEFAULT,
    rle_out, R_PAR1_CONFIG__rle_out__DEFAULT,
    enable, R_PAR1_CONFIG__enable__DEFAULT,
    force, R_PAR1_CONFIG__force__DEFAULT,
    ign_ack, R_PAR1_CONFIG__ign_ack__DEFAULT,
    oe_ack, R_PAR1_CONFIG__oe_ack__DEFAULT,
    mode, R_PAR1_CONFIG__mode__DEFAULT
  );
#endif

#if USE_GROUP__Parallel_printer_port_registers
  REG_SET__R_PAR1_CTRL(
    ctrl, R_PAR1_CTRL__ctrl__DEFAULT
  );
#endif

#if USE_GROUP__Parallel_printer_port_registers
  REG_SET__R_PAR1_CTRL_DATA(
    peri_int, R_PAR1_CTRL_DATA__peri_int__DEFAULT,
    oe, R_PAR1_CTRL_DATA__oe__DEFAULT,
    seli, R_PAR1_CTRL_DATA__seli__DEFAULT,
    autofd, R_PAR1_CTRL_DATA__autofd__DEFAULT,
    strb, R_PAR1_CTRL_DATA__strb__DEFAULT,
    init, R_PAR1_CTRL_DATA__init__DEFAULT,
    ecp_cmd, R_PAR1_CTRL_DATA__ecp_cmd__DEFAULT,
    data, R_PAR1_CTRL_DATA__data__DEFAULT
  );
#endif

#if USE_GROUP__Parallel_printer_port_registers
  REG_SET__R_PAR1_DELAY(
    fine_hold, R_PAR1_DELAY__fine_hold__DEFAULT,
    hold, R_PAR1_DELAY__hold__DEFAULT,
    fine_strb, R_PAR1_DELAY__fine_strb__DEFAULT,
    strobe, R_PAR1_DELAY__strobe__DEFAULT,
    fine_setup, R_PAR1_DELAY__fine_setup__DEFAULT,
    setup, R_PAR1_DELAY__setup__DEFAULT
  );
#endif

#if USE_GROUP__General_port_configuration_registers
  REG_SET__R_PORT_PA_DATA(
    data_out, R_PORT_PA_DATA__data_out__DEFAULT
  );
#endif

#if USE_GROUP__General_port_configuration_registers
  REG_SET__R_PORT_PA_DIR(
    dir7, R_PORT_PA_DIR__dir7__DEFAULT,
    dir6, R_PORT_PA_DIR__dir6__DEFAULT,
    dir5, R_PORT_PA_DIR__dir5__DEFAULT,
    dir4, R_PORT_PA_DIR__dir4__DEFAULT,
    dir3, R_PORT_PA_DIR__dir3__DEFAULT,
    dir2, R_PORT_PA_DIR__dir2__DEFAULT,
    dir1, R_PORT_PA_DIR__dir1__DEFAULT,
    dir0, R_PORT_PA_DIR__dir0__DEFAULT
  );
#endif

#if USE_GROUP__General_port_configuration_registers
  REG_SET__R_PORT_PA_SET(
    dir7, R_PORT_PA_SET__dir7__DEFAULT,
    dir6, R_PORT_PA_SET__dir6__DEFAULT,
    dir5, R_PORT_PA_SET__dir5__DEFAULT,
    dir4, R_PORT_PA_SET__dir4__DEFAULT,
    dir3, R_PORT_PA_SET__dir3__DEFAULT,
    dir2, R_PORT_PA_SET__dir2__DEFAULT,
    dir1, R_PORT_PA_SET__dir1__DEFAULT,
    dir0, R_PORT_PA_SET__dir0__DEFAULT,
    data_out, R_PORT_PA_SET__data_out__DEFAULT
  );
#endif

#if USE_GROUP__General_port_configuration_registers
  REG_SET__R_PORT_PB_CONFIG(
    cs7, R_PORT_PB_CONFIG__cs7__DEFAULT,
    cs6, R_PORT_PB_CONFIG__cs6__DEFAULT,
    cs5, R_PORT_PB_CONFIG__cs5__DEFAULT,
    cs4, R_PORT_PB_CONFIG__cs4__DEFAULT,
    cs3, R_PORT_PB_CONFIG__cs3__DEFAULT,
    cs2, R_PORT_PB_CONFIG__cs2__DEFAULT,
    scsi1, R_PORT_PB_CONFIG__scsi1__DEFAULT,
    scsi0, R_PORT_PB_CONFIG__scsi0__DEFAULT
  );
#endif

#if USE_GROUP__General_port_configuration_registers
  REG_SET__R_PORT_PB_DATA(
    data_out, R_PORT_PB_DATA__data_out__DEFAULT
  );
#endif

#if USE_GROUP__General_port_configuration_registers
  REG_SET__R_PORT_PB_DIR(
    dir7, R_PORT_PB_DIR__dir7__DEFAULT,
    dir6, R_PORT_PB_DIR__dir6__DEFAULT,
    dir5, R_PORT_PB_DIR__dir5__DEFAULT,
    dir4, R_PORT_PB_DIR__dir4__DEFAULT,
    dir3, R_PORT_PB_DIR__dir3__DEFAULT,
    dir2, R_PORT_PB_DIR__dir2__DEFAULT,
    dir1, R_PORT_PB_DIR__dir1__DEFAULT,
    dir0, R_PORT_PB_DIR__dir0__DEFAULT
  );
#endif

#if USE_GROUP__General_port_configuration_registers
  REG_SET__R_PORT_PB_I2C(
    syncser3, R_PORT_PB_I2C__syncser3__DEFAULT,
    syncser1, R_PORT_PB_I2C__syncser1__DEFAULT,
    i2c_en, R_PORT_PB_I2C__i2c_en__DEFAULT,
    i2c_d, R_PORT_PB_I2C__i2c_d__DEFAULT,
    i2c_clk, R_PORT_PB_I2C__i2c_clk__DEFAULT,
    i2c_oe_, R_PORT_PB_I2C__i2c_oe___DEFAULT
  );
#endif

#if USE_GROUP__General_port_configuration_registers
  REG_SET__R_PORT_PB_SET(
    syncser3, R_PORT_PB_SET__syncser3__DEFAULT,
    syncser1, R_PORT_PB_SET__syncser1__DEFAULT,
    i2c_en, R_PORT_PB_SET__i2c_en__DEFAULT,
    i2c_d, R_PORT_PB_SET__i2c_d__DEFAULT,
    i2c_clk, R_PORT_PB_SET__i2c_clk__DEFAULT,
    i2c_oe_, R_PORT_PB_SET__i2c_oe___DEFAULT,
    cs7, R_PORT_PB_SET__cs7__DEFAULT,
    cs6, R_PORT_PB_SET__cs6__DEFAULT,
    cs5, R_PORT_PB_SET__cs5__DEFAULT,
    cs4, R_PORT_PB_SET__cs4__DEFAULT,
    cs3, R_PORT_PB_SET__cs3__DEFAULT,
    cs2, R_PORT_PB_SET__cs2__DEFAULT,
    scsi1, R_PORT_PB_SET__scsi1__DEFAULT,
    scsi0, R_PORT_PB_SET__scsi0__DEFAULT,
    dir7, R_PORT_PB_SET__dir7__DEFAULT,
    dir6, R_PORT_PB_SET__dir6__DEFAULT,
    dir5, R_PORT_PB_SET__dir5__DEFAULT,
    dir4, R_PORT_PB_SET__dir4__DEFAULT,
    dir3, R_PORT_PB_SET__dir3__DEFAULT,
    dir2, R_PORT_PB_SET__dir2__DEFAULT,
    dir1, R_PORT_PB_SET__dir1__DEFAULT,
    dir0, R_PORT_PB_SET__dir0__DEFAULT,
    data_out, R_PORT_PB_SET__data_out__DEFAULT
  );
#endif

#if USE_GROUP__SCSI_registers
  REG_SET__R_SCSI0_CMD(
    asynch_setup, R_SCSI0_CMD__asynch_setup__DEFAULT,
    command, R_SCSI0_CMD__command__DEFAULT
  );
#endif

#if USE_GROUP__SCSI_registers
  REG_SET__R_SCSI0_CMD_DATA(
    parity_in, R_SCSI0_CMD_DATA__parity_in__DEFAULT,
    skip, R_SCSI0_CMD_DATA__skip__DEFAULT,
    clr_status, R_SCSI0_CMD_DATA__clr_status__DEFAULT,
    asynch_setup, R_SCSI0_CMD_DATA__asynch_setup__DEFAULT,
    command, R_SCSI0_CMD_DATA__command__DEFAULT,
    data_out, R_SCSI0_CMD_DATA__data_out__DEFAULT
  );
#endif

#if USE_GROUP__SCSI_registers
  REG_SET__R_SCSI0_CTRL(
    id_type, R_SCSI0_CTRL__id_type__DEFAULT,
    sel_timeout, R_SCSI0_CTRL__sel_timeout__DEFAULT,
    synch_per, R_SCSI0_CTRL__synch_per__DEFAULT,
    rst, R_SCSI0_CTRL__rst__DEFAULT,
    atn, R_SCSI0_CTRL__atn__DEFAULT,
    my_id, R_SCSI0_CTRL__my_id__DEFAULT,
    target_id, R_SCSI0_CTRL__target_id__DEFAULT,
    fast_20, R_SCSI0_CTRL__fast_20__DEFAULT,
    bus_width, R_SCSI0_CTRL__bus_width__DEFAULT,
    synch, R_SCSI0_CTRL__synch__DEFAULT,
    enable, R_SCSI0_CTRL__enable__DEFAULT
  );
#endif

#if USE_GROUP__SCSI_registers
  REG_SET__R_SCSI0_DATA(
    data_out, R_SCSI0_DATA__data_out__DEFAULT
  );
#endif

#if USE_GROUP__SCSI_registers
  REG_SET__R_SCSI0_STATUS_CTRL(
    parity_in, R_SCSI0_STATUS_CTRL__parity_in__DEFAULT,
    skip, R_SCSI0_STATUS_CTRL__skip__DEFAULT,
    clr_status, R_SCSI0_STATUS_CTRL__clr_status__DEFAULT
  );
#endif

#if USE_GROUP__SCSI_registers
  REG_SET__R_SCSI1_CMD(
    asynch_setup, R_SCSI1_CMD__asynch_setup__DEFAULT,
    command, R_SCSI1_CMD__command__DEFAULT
  );
#endif

#if USE_GROUP__SCSI_registers
  REG_SET__R_SCSI1_CMD_DATA(
    parity_in, R_SCSI1_CMD_DATA__parity_in__DEFAULT,
    skip, R_SCSI1_CMD_DATA__skip__DEFAULT,
    clr_status, R_SCSI1_CMD_DATA__clr_status__DEFAULT,
    asynch_setup, R_SCSI1_CMD_DATA__asynch_setup__DEFAULT,
    command, R_SCSI1_CMD_DATA__command__DEFAULT,
    data_out, R_SCSI1_CMD_DATA__data_out__DEFAULT
  );
#endif

#if USE_GROUP__SCSI_registers
  REG_SET__R_SCSI1_CTRL(
    id_type, R_SCSI1_CTRL__id_type__DEFAULT,
    sel_timeout, R_SCSI1_CTRL__sel_timeout__DEFAULT,
    synch_per, R_SCSI1_CTRL__synch_per__DEFAULT,
    rst, R_SCSI1_CTRL__rst__DEFAULT,
    atn, R_SCSI1_CTRL__atn__DEFAULT,
    my_id, R_SCSI1_CTRL__my_id__DEFAULT,
    target_id, R_SCSI1_CTRL__target_id__DEFAULT,
    fast_20, R_SCSI1_CTRL__fast_20__DEFAULT,
    bus_width, R_SCSI1_CTRL__bus_width__DEFAULT,
    synch, R_SCSI1_CTRL__synch__DEFAULT,
    enable, R_SCSI1_CTRL__enable__DEFAULT
  );
#endif

#if USE_GROUP__SCSI_registers
  REG_SET__R_SCSI1_DATA(
    data_out, R_SCSI1_DATA__data_out__DEFAULT
  );
#endif

#if USE_GROUP__SCSI_registers
  REG_SET__R_SCSI1_STATUS_CTRL(
    parity_in, R_SCSI1_STATUS_CTRL__parity_in__DEFAULT,
    skip, R_SCSI1_STATUS_CTRL__skip__DEFAULT,
    clr_status, R_SCSI1_STATUS_CTRL__clr_status__DEFAULT
  );
#endif

#if USE_GROUP__Bus_interface_configuration_registers
  REG_SET__R_SDRAM_CONFIG(
    wmm1, R_SDRAM_CONFIG__wmm1__DEFAULT,
    wmm0, R_SDRAM_CONFIG__wmm0__DEFAULT,
    sh1, R_SDRAM_CONFIG__sh1__DEFAULT,
    sh0, R_SDRAM_CONFIG__sh0__DEFAULT,
    w, R_SDRAM_CONFIG__w__DEFAULT,
    type1, R_SDRAM_CONFIG__type1__DEFAULT,
    type0, R_SDRAM_CONFIG__type0__DEFAULT,
    group_sel, R_SDRAM_CONFIG__group_sel__DEFAULT,
    ca1, R_SDRAM_CONFIG__ca1__DEFAULT,
    bank_sel1, R_SDRAM_CONFIG__bank_sel1__DEFAULT,
    ca0, R_SDRAM_CONFIG__ca0__DEFAULT,
    bank_sel0, R_SDRAM_CONFIG__bank_sel0__DEFAULT
  );
#endif

#if USE_GROUP__Bus_interface_configuration_registers
  REG_SET__R_SDRAM_TIMING(
    sdram, R_SDRAM_TIMING__sdram__DEFAULT,
    mrs_data, R_SDRAM_TIMING__mrs_data__DEFAULT,
    ref, R_SDRAM_TIMING__ref__DEFAULT,
    ddr, R_SDRAM_TIMING__ddr__DEFAULT,
    clk100, R_SDRAM_TIMING__clk100__DEFAULT,
    ps, R_SDRAM_TIMING__ps__DEFAULT,
    cmd, R_SDRAM_TIMING__cmd__DEFAULT,
    pde, R_SDRAM_TIMING__pde__DEFAULT,
    rc, R_SDRAM_TIMING__rc__DEFAULT,
    rp, R_SDRAM_TIMING__rp__DEFAULT,
    rcd, R_SDRAM_TIMING__rcd__DEFAULT,
    cl, R_SDRAM_TIMING__cl__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL0_BAUD(
    tr_baud, R_SERIAL0_BAUD__tr_baud__DEFAULT,
    rec_baud, R_SERIAL0_BAUD__rec_baud__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL0_CTRL(
    tr_baud, R_SERIAL0_CTRL__tr_baud__DEFAULT,
    rec_baud, R_SERIAL0_CTRL__rec_baud__DEFAULT,
    dma_err, R_SERIAL0_CTRL__dma_err__DEFAULT,
    rec_enable, R_SERIAL0_CTRL__rec_enable__DEFAULT,
    rts_, R_SERIAL0_CTRL__rts___DEFAULT,
    sampling, R_SERIAL0_CTRL__sampling__DEFAULT,
    rec_stick_par, R_SERIAL0_CTRL__rec_stick_par__DEFAULT,
    rec_par, R_SERIAL0_CTRL__rec_par__DEFAULT,
    rec_par_en, R_SERIAL0_CTRL__rec_par_en__DEFAULT,
    rec_bitnr, R_SERIAL0_CTRL__rec_bitnr__DEFAULT,
    txd, R_SERIAL0_CTRL__txd__DEFAULT,
    tr_enable, R_SERIAL0_CTRL__tr_enable__DEFAULT,
    auto_cts, R_SERIAL0_CTRL__auto_cts__DEFAULT,
    stop_bits, R_SERIAL0_CTRL__stop_bits__DEFAULT,
    tr_stick_par, R_SERIAL0_CTRL__tr_stick_par__DEFAULT,
    tr_par, R_SERIAL0_CTRL__tr_par__DEFAULT,
    tr_par_en, R_SERIAL0_CTRL__tr_par_en__DEFAULT,
    tr_bitnr, R_SERIAL0_CTRL__tr_bitnr__DEFAULT,
    data_out, R_SERIAL0_CTRL__data_out__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL0_REC_CTRL(
    dma_err, R_SERIAL0_REC_CTRL__dma_err__DEFAULT,
    rec_enable, R_SERIAL0_REC_CTRL__rec_enable__DEFAULT,
    rts_, R_SERIAL0_REC_CTRL__rts___DEFAULT,
    sampling, R_SERIAL0_REC_CTRL__sampling__DEFAULT,
    rec_stick_par, R_SERIAL0_REC_CTRL__rec_stick_par__DEFAULT,
    rec_par, R_SERIAL0_REC_CTRL__rec_par__DEFAULT,
    rec_par_en, R_SERIAL0_REC_CTRL__rec_par_en__DEFAULT,
    rec_bitnr, R_SERIAL0_REC_CTRL__rec_bitnr__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL0_TR_CTRL(
    txd, R_SERIAL0_TR_CTRL__txd__DEFAULT,
    tr_enable, R_SERIAL0_TR_CTRL__tr_enable__DEFAULT,
    auto_cts, R_SERIAL0_TR_CTRL__auto_cts__DEFAULT,
    stop_bits, R_SERIAL0_TR_CTRL__stop_bits__DEFAULT,
    tr_stick_par, R_SERIAL0_TR_CTRL__tr_stick_par__DEFAULT,
    tr_par, R_SERIAL0_TR_CTRL__tr_par__DEFAULT,
    tr_par_en, R_SERIAL0_TR_CTRL__tr_par_en__DEFAULT,
    tr_bitnr, R_SERIAL0_TR_CTRL__tr_bitnr__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL0_TR_DATA(
    data_out, R_SERIAL0_TR_DATA__data_out__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL0_XOFF(
    tx_stop, R_SERIAL0_XOFF__tx_stop__DEFAULT,
    auto_xoff, R_SERIAL0_XOFF__auto_xoff__DEFAULT,
    xoff_char, R_SERIAL0_XOFF__xoff_char__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL1_BAUD(
    tr_baud, R_SERIAL1_BAUD__tr_baud__DEFAULT,
    rec_baud, R_SERIAL1_BAUD__rec_baud__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL1_CTRL(
    tr_baud, R_SERIAL1_CTRL__tr_baud__DEFAULT,
    rec_baud, R_SERIAL1_CTRL__rec_baud__DEFAULT,
    dma_err, R_SERIAL1_CTRL__dma_err__DEFAULT,
    rec_enable, R_SERIAL1_CTRL__rec_enable__DEFAULT,
    rts_, R_SERIAL1_CTRL__rts___DEFAULT,
    sampling, R_SERIAL1_CTRL__sampling__DEFAULT,
    rec_stick_par, R_SERIAL1_CTRL__rec_stick_par__DEFAULT,
    rec_par, R_SERIAL1_CTRL__rec_par__DEFAULT,
    rec_par_en, R_SERIAL1_CTRL__rec_par_en__DEFAULT,
    rec_bitnr, R_SERIAL1_CTRL__rec_bitnr__DEFAULT,
    txd, R_SERIAL1_CTRL__txd__DEFAULT,
    tr_enable, R_SERIAL1_CTRL__tr_enable__DEFAULT,
    auto_cts, R_SERIAL1_CTRL__auto_cts__DEFAULT,
    stop_bits, R_SERIAL1_CTRL__stop_bits__DEFAULT,
    tr_stick_par, R_SERIAL1_CTRL__tr_stick_par__DEFAULT,
    tr_par, R_SERIAL1_CTRL__tr_par__DEFAULT,
    tr_par_en, R_SERIAL1_CTRL__tr_par_en__DEFAULT,
    tr_bitnr, R_SERIAL1_CTRL__tr_bitnr__DEFAULT,
    data_out, R_SERIAL1_CTRL__data_out__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL1_REC_CTRL(
    dma_err, R_SERIAL1_REC_CTRL__dma_err__DEFAULT,
    rec_enable, R_SERIAL1_REC_CTRL__rec_enable__DEFAULT,
    rts_, R_SERIAL1_REC_CTRL__rts___DEFAULT,
    sampling, R_SERIAL1_REC_CTRL__sampling__DEFAULT,
    rec_stick_par, R_SERIAL1_REC_CTRL__rec_stick_par__DEFAULT,
    rec_par, R_SERIAL1_REC_CTRL__rec_par__DEFAULT,
    rec_par_en, R_SERIAL1_REC_CTRL__rec_par_en__DEFAULT,
    rec_bitnr, R_SERIAL1_REC_CTRL__rec_bitnr__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL1_TR_CTRL(
    txd, R_SERIAL1_TR_CTRL__txd__DEFAULT,
    tr_enable, R_SERIAL1_TR_CTRL__tr_enable__DEFAULT,
    auto_cts, R_SERIAL1_TR_CTRL__auto_cts__DEFAULT,
    stop_bits, R_SERIAL1_TR_CTRL__stop_bits__DEFAULT,
    tr_stick_par, R_SERIAL1_TR_CTRL__tr_stick_par__DEFAULT,
    tr_par, R_SERIAL1_TR_CTRL__tr_par__DEFAULT,
    tr_par_en, R_SERIAL1_TR_CTRL__tr_par_en__DEFAULT,
    tr_bitnr, R_SERIAL1_TR_CTRL__tr_bitnr__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL1_TR_DATA(
    data_out, R_SERIAL1_TR_DATA__data_out__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL1_XOFF(
    tx_stop, R_SERIAL1_XOFF__tx_stop__DEFAULT,
    auto_xoff, R_SERIAL1_XOFF__auto_xoff__DEFAULT,
    xoff_char, R_SERIAL1_XOFF__xoff_char__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL2_BAUD(
    tr_baud, R_SERIAL2_BAUD__tr_baud__DEFAULT,
    rec_baud, R_SERIAL2_BAUD__rec_baud__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL2_CTRL(
    tr_baud, R_SERIAL2_CTRL__tr_baud__DEFAULT,
    rec_baud, R_SERIAL2_CTRL__rec_baud__DEFAULT,
    dma_err, R_SERIAL2_CTRL__dma_err__DEFAULT,
    rec_enable, R_SERIAL2_CTRL__rec_enable__DEFAULT,
    rts_, R_SERIAL2_CTRL__rts___DEFAULT,
    sampling, R_SERIAL2_CTRL__sampling__DEFAULT,
    rec_stick_par, R_SERIAL2_CTRL__rec_stick_par__DEFAULT,
    rec_par, R_SERIAL2_CTRL__rec_par__DEFAULT,
    rec_par_en, R_SERIAL2_CTRL__rec_par_en__DEFAULT,
    rec_bitnr, R_SERIAL2_CTRL__rec_bitnr__DEFAULT,
    txd, R_SERIAL2_CTRL__txd__DEFAULT,
    tr_enable, R_SERIAL2_CTRL__tr_enable__DEFAULT,
    auto_cts, R_SERIAL2_CTRL__auto_cts__DEFAULT,
    stop_bits, R_SERIAL2_CTRL__stop_bits__DEFAULT,
    tr_stick_par, R_SERIAL2_CTRL__tr_stick_par__DEFAULT,
    tr_par, R_SERIAL2_CTRL__tr_par__DEFAULT,
    tr_par_en, R_SERIAL2_CTRL__tr_par_en__DEFAULT,
    tr_bitnr, R_SERIAL2_CTRL__tr_bitnr__DEFAULT,
    data_out, R_SERIAL2_CTRL__data_out__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL2_REC_CTRL(
    dma_err, R_SERIAL2_REC_CTRL__dma_err__DEFAULT,
    rec_enable, R_SERIAL2_REC_CTRL__rec_enable__DEFAULT,
    rts_, R_SERIAL2_REC_CTRL__rts___DEFAULT,
    sampling, R_SERIAL2_REC_CTRL__sampling__DEFAULT,
    rec_stick_par, R_SERIAL2_REC_CTRL__rec_stick_par__DEFAULT,
    rec_par, R_SERIAL2_REC_CTRL__rec_par__DEFAULT,
    rec_par_en, R_SERIAL2_REC_CTRL__rec_par_en__DEFAULT,
    rec_bitnr, R_SERIAL2_REC_CTRL__rec_bitnr__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL2_TR_CTRL(
    txd, R_SERIAL2_TR_CTRL__txd__DEFAULT,
    tr_enable, R_SERIAL2_TR_CTRL__tr_enable__DEFAULT,
    auto_cts, R_SERIAL2_TR_CTRL__auto_cts__DEFAULT,
    stop_bits, R_SERIAL2_TR_CTRL__stop_bits__DEFAULT,
    tr_stick_par, R_SERIAL2_TR_CTRL__tr_stick_par__DEFAULT,
    tr_par, R_SERIAL2_TR_CTRL__tr_par__DEFAULT,
    tr_par_en, R_SERIAL2_TR_CTRL__tr_par_en__DEFAULT,
    tr_bitnr, R_SERIAL2_TR_CTRL__tr_bitnr__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL2_TR_DATA(
    data_out, R_SERIAL2_TR_DATA__data_out__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL2_XOFF(
    tx_stop, R_SERIAL2_XOFF__tx_stop__DEFAULT,
    auto_xoff, R_SERIAL2_XOFF__auto_xoff__DEFAULT,
    xoff_char, R_SERIAL2_XOFF__xoff_char__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL3_BAUD(
    tr_baud, R_SERIAL3_BAUD__tr_baud__DEFAULT,
    rec_baud, R_SERIAL3_BAUD__rec_baud__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL3_CTRL(
    tr_baud, R_SERIAL3_CTRL__tr_baud__DEFAULT,
    rec_baud, R_SERIAL3_CTRL__rec_baud__DEFAULT,
    dma_err, R_SERIAL3_CTRL__dma_err__DEFAULT,
    rec_enable, R_SERIAL3_CTRL__rec_enable__DEFAULT,
    rts_, R_SERIAL3_CTRL__rts___DEFAULT,
    sampling, R_SERIAL3_CTRL__sampling__DEFAULT,
    rec_stick_par, R_SERIAL3_CTRL__rec_stick_par__DEFAULT,
    rec_par, R_SERIAL3_CTRL__rec_par__DEFAULT,
    rec_par_en, R_SERIAL3_CTRL__rec_par_en__DEFAULT,
    rec_bitnr, R_SERIAL3_CTRL__rec_bitnr__DEFAULT,
    txd, R_SERIAL3_CTRL__txd__DEFAULT,
    tr_enable, R_SERIAL3_CTRL__tr_enable__DEFAULT,
    auto_cts, R_SERIAL3_CTRL__auto_cts__DEFAULT,
    stop_bits, R_SERIAL3_CTRL__stop_bits__DEFAULT,
    tr_stick_par, R_SERIAL3_CTRL__tr_stick_par__DEFAULT,
    tr_par, R_SERIAL3_CTRL__tr_par__DEFAULT,
    tr_par_en, R_SERIAL3_CTRL__tr_par_en__DEFAULT,
    tr_bitnr, R_SERIAL3_CTRL__tr_bitnr__DEFAULT,
    data_out, R_SERIAL3_CTRL__data_out__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL3_REC_CTRL(
    dma_err, R_SERIAL3_REC_CTRL__dma_err__DEFAULT,
    rec_enable, R_SERIAL3_REC_CTRL__rec_enable__DEFAULT,
    rts_, R_SERIAL3_REC_CTRL__rts___DEFAULT,
    sampling, R_SERIAL3_REC_CTRL__sampling__DEFAULT,
    rec_stick_par, R_SERIAL3_REC_CTRL__rec_stick_par__DEFAULT,
    rec_par, R_SERIAL3_REC_CTRL__rec_par__DEFAULT,
    rec_par_en, R_SERIAL3_REC_CTRL__rec_par_en__DEFAULT,
    rec_bitnr, R_SERIAL3_REC_CTRL__rec_bitnr__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL3_TR_CTRL(
    txd, R_SERIAL3_TR_CTRL__txd__DEFAULT,
    tr_enable, R_SERIAL3_TR_CTRL__tr_enable__DEFAULT,
    auto_cts, R_SERIAL3_TR_CTRL__auto_cts__DEFAULT,
    stop_bits, R_SERIAL3_TR_CTRL__stop_bits__DEFAULT,
    tr_stick_par, R_SERIAL3_TR_CTRL__tr_stick_par__DEFAULT,
    tr_par, R_SERIAL3_TR_CTRL__tr_par__DEFAULT,
    tr_par_en, R_SERIAL3_TR_CTRL__tr_par_en__DEFAULT,
    tr_bitnr, R_SERIAL3_TR_CTRL__tr_bitnr__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL3_TR_DATA(
    data_out, R_SERIAL3_TR_DATA__data_out__DEFAULT
  );
#endif

#if USE_GROUP__Serial_port_registers
  REG_SET__R_SERIAL3_XOFF(
    tx_stop, R_SERIAL3_XOFF__tx_stop__DEFAULT,
    auto_xoff, R_SERIAL3_XOFF__auto_xoff__DEFAULT,
    xoff_char, R_SERIAL3_XOFF__xoff_char__DEFAULT
  );
#endif

#if USE_GROUP__Timer_registers
  REG_SET__R_SERIAL_PRESCALE(
    ser_presc, R_SERIAL_PRESCALE__ser_presc__DEFAULT
  );
#endif

#if USE_GROUP__DMA_registers
  REG_SET__R_SET_EOP(
    ch9_eop, R_SET_EOP__ch9_eop__DEFAULT,
    ch7_eop, R_SET_EOP__ch7_eop__DEFAULT,
    ch5_eop, R_SET_EOP__ch5_eop__DEFAULT,
    ch3_eop, R_SET_EOP__ch3_eop__DEFAULT
  );
#endif

#if USE_GROUP__Shared_RAM_interface_registers
  REG_SET__R_SHARED_RAM_ADDR(
    base_addr, R_SHARED_RAM_ADDR__base_addr__DEFAULT
  );
#endif

#if USE_GROUP__Shared_RAM_interface_registers
  REG_SET__R_SHARED_RAM_CONFIG(
    width, R_SHARED_RAM_CONFIG__width__DEFAULT,
    enable, R_SHARED_RAM_CONFIG__enable__DEFAULT,
    pint, R_SHARED_RAM_CONFIG__pint__DEFAULT,
    clri, R_SHARED_RAM_CONFIG__clri__DEFAULT
  );
#endif

#if USE_GROUP__Test_mode_registers
  REG_SET__R_SINGLE_STEP(
    single_step, R_SINGLE_STEP__single_step__DEFAULT,
    step_wr, R_SINGLE_STEP__step_wr__DEFAULT,
    step_rd, R_SINGLE_STEP__step_rd__DEFAULT,
    step_fetch, R_SINGLE_STEP__step_fetch__DEFAULT
  );
#endif

#if USE_GROUP__Syncrounous_serial_port_registers
  REG_SET__R_SYNC_SERIAL1_CTRL(
    tr_baud, R_SYNC_SERIAL1_CTRL__tr_baud__DEFAULT,
    dma_enable, R_SYNC_SERIAL1_CTRL__dma_enable__DEFAULT,
    mode, R_SYNC_SERIAL1_CTRL__mode__DEFAULT,
    error, R_SYNC_SERIAL1_CTRL__error__DEFAULT,
    rec_enable, R_SYNC_SERIAL1_CTRL__rec_enable__DEFAULT,
    f_synctype, R_SYNC_SERIAL1_CTRL__f_synctype__DEFAULT,
    f_syncsize, R_SYNC_SERIAL1_CTRL__f_syncsize__DEFAULT,
    f_sync, R_SYNC_SERIAL1_CTRL__f_sync__DEFAULT,
    clk_mode, R_SYNC_SERIAL1_CTRL__clk_mode__DEFAULT,
    clk_halt, R_SYNC_SERIAL1_CTRL__clk_halt__DEFAULT,
    bitorder, R_SYNC_SERIAL1_CTRL__bitorder__DEFAULT,
    tr_enable, R_SYNC_SERIAL1_CTRL__tr_enable__DEFAULT,
    wordsize, R_SYNC_SERIAL1_CTRL__wordsize__DEFAULT,
    buf_empty, R_SYNC_SERIAL1_CTRL__buf_empty__DEFAULT,
    buf_full, R_SYNC_SERIAL1_CTRL__buf_full__DEFAULT,
    flow_ctrl, R_SYNC_SERIAL1_CTRL__flow_ctrl__DEFAULT,
    clk_polarity, R_SYNC_SERIAL1_CTRL__clk_polarity__DEFAULT,
    frame_polarity, R_SYNC_SERIAL1_CTRL__frame_polarity__DEFAULT,
    status_polarity, R_SYNC_SERIAL1_CTRL__status_polarity__DEFAULT,
    clk_driver, R_SYNC_SERIAL1_CTRL__clk_driver__DEFAULT,
    frame_driver, R_SYNC_SERIAL1_CTRL__frame_driver__DEFAULT,
    status_driver, R_SYNC_SERIAL1_CTRL__status_driver__DEFAULT,
    def_out0, R_SYNC_SERIAL1_CTRL__def_out0__DEFAULT
  );
#endif

#if USE_GROUP__Syncrounous_serial_port_registers
  REG_SET__R_SYNC_SERIAL1_TR_BYTE(
    data_out, R_SYNC_SERIAL1_TR_BYTE__data_out__DEFAULT
  );
#endif

#if USE_GROUP__Syncrounous_serial_port_registers
  REG_SET__R_SYNC_SERIAL1_TR_DATA(
    data_out, R_SYNC_SERIAL1_TR_DATA__data_out__DEFAULT
  );
#endif

#if USE_GROUP__Syncrounous_serial_port_registers
  REG_SET__R_SYNC_SERIAL1_TR_WORD(
    data_out, R_SYNC_SERIAL1_TR_WORD__data_out__DEFAULT
  );
#endif

#if USE_GROUP__Syncrounous_serial_port_registers
  REG_SET__R_SYNC_SERIAL3_CTRL(
    tr_baud, R_SYNC_SERIAL3_CTRL__tr_baud__DEFAULT,
    dma_enable, R_SYNC_SERIAL3_CTRL__dma_enable__DEFAULT,
    mode, R_SYNC_SERIAL3_CTRL__mode__DEFAULT,
    error, R_SYNC_SERIAL3_CTRL__error__DEFAULT,
    rec_enable, R_SYNC_SERIAL3_CTRL__rec_enable__DEFAULT,
    f_synctype, R_SYNC_SERIAL3_CTRL__f_synctype__DEFAULT,
    f_syncsize, R_SYNC_SERIAL3_CTRL__f_syncsize__DEFAULT,
    f_sync, R_SYNC_SERIAL3_CTRL__f_sync__DEFAULT,
    clk_mode, R_SYNC_SERIAL3_CTRL__clk_mode__DEFAULT,
    clk_halt, R_SYNC_SERIAL3_CTRL__clk_halt__DEFAULT,
    bitorder, R_SYNC_SERIAL3_CTRL__bitorder__DEFAULT,
    tr_enable, R_SYNC_SERIAL3_CTRL__tr_enable__DEFAULT,
    wordsize, R_SYNC_SERIAL3_CTRL__wordsize__DEFAULT,
    buf_empty, R_SYNC_SERIAL3_CTRL__buf_empty__DEFAULT,
    buf_full, R_SYNC_SERIAL3_CTRL__buf_full__DEFAULT,
    flow_ctrl, R_SYNC_SERIAL3_CTRL__flow_ctrl__DEFAULT,
    clk_polarity, R_SYNC_SERIAL3_CTRL__clk_polarity__DEFAULT,
    frame_polarity, R_SYNC_SERIAL3_CTRL__frame_polarity__DEFAULT,
    status_polarity, R_SYNC_SERIAL3_CTRL__status_polarity__DEFAULT,
    clk_driver, R_SYNC_SERIAL3_CTRL__clk_driver__DEFAULT,
    frame_driver, R_SYNC_SERIAL3_CTRL__frame_driver__DEFAULT,
    status_driver, R_SYNC_SERIAL3_CTRL__status_driver__DEFAULT,
    def_out0, R_SYNC_SERIAL3_CTRL__def_out0__DEFAULT
  );
#endif

#if USE_GROUP__Syncrounous_serial_port_registers
  REG_SET__R_SYNC_SERIAL3_TR_BYTE(
    data_out, R_SYNC_SERIAL3_TR_BYTE__data_out__DEFAULT
  );
#endif

#if USE_GROUP__Syncrounous_serial_port_registers
  REG_SET__R_SYNC_SERIAL3_TR_DATA(
    data_out, R_SYNC_SERIAL3_TR_DATA__data_out__DEFAULT
  );
#endif

#if USE_GROUP__Syncrounous_serial_port_registers
  REG_SET__R_SYNC_SERIAL3_TR_WORD(
    data_out, R_SYNC_SERIAL3_TR_WORD__data_out__DEFAULT
  );
#endif

#if USE_GROUP__Timer_registers
  REG_SET__R_SYNC_SERIAL_PRESCALE(
    clk_sel_u3, R_SYNC_SERIAL_PRESCALE__clk_sel_u3__DEFAULT,
    word_stb_sel_u3, R_SYNC_SERIAL_PRESCALE__word_stb_sel_u3__DEFAULT,
    clk_sel_u1, R_SYNC_SERIAL_PRESCALE__clk_sel_u1__DEFAULT,
    word_stb_sel_u1, R_SYNC_SERIAL_PRESCALE__word_stb_sel_u1__DEFAULT,
    prescaler, R_SYNC_SERIAL_PRESCALE__prescaler__DEFAULT,
    warp_mode, R_SYNC_SERIAL_PRESCALE__warp_mode__DEFAULT,
    frame_rate, R_SYNC_SERIAL_PRESCALE__frame_rate__DEFAULT,
    word_rate, R_SYNC_SERIAL_PRESCALE__word_rate__DEFAULT
  );
#endif

#if USE_GROUP__Test_mode_registers
  REG_SET__R_TEST_MODE(
    single_step, R_TEST_MODE__single_step__DEFAULT,
    step_wr, R_TEST_MODE__step_wr__DEFAULT,
    step_rd, R_TEST_MODE__step_rd__DEFAULT,
    step_fetch, R_TEST_MODE__step_fetch__DEFAULT,
    mmu_test, R_TEST_MODE__mmu_test__DEFAULT,
    usb_test, R_TEST_MODE__usb_test__DEFAULT,
    scsi_timer_test, R_TEST_MODE__scsi_timer_test__DEFAULT,
    backoff, R_TEST_MODE__backoff__DEFAULT,
    snmp_test, R_TEST_MODE__snmp_test__DEFAULT,
    snmp_inc, R_TEST_MODE__snmp_inc__DEFAULT,
    ser_loop, R_TEST_MODE__ser_loop__DEFAULT,
    baudrate, R_TEST_MODE__baudrate__DEFAULT,
    timer, R_TEST_MODE__timer__DEFAULT,
    cache_test, R_TEST_MODE__cache_test__DEFAULT,
    tag_test, R_TEST_MODE__tag_test__DEFAULT,
    cache_enable, R_TEST_MODE__cache_enable__DEFAULT
  );
#endif

#if USE_GROUP__Timer_registers
  REG_SET__R_TIMER_CTRL(
    timerdiv1, R_TIMER_CTRL__timerdiv1__DEFAULT,
    timerdiv0, R_TIMER_CTRL__timerdiv0__DEFAULT,
    presc_timer1, R_TIMER_CTRL__presc_timer1__DEFAULT,
    i1, R_TIMER_CTRL__i1__DEFAULT,
    tm1, R_TIMER_CTRL__tm1__DEFAULT,
    clksel1, R_TIMER_CTRL__clksel1__DEFAULT,
    presc_ext, R_TIMER_CTRL__presc_ext__DEFAULT,
    i0, R_TIMER_CTRL__i0__DEFAULT,
    tm0, R_TIMER_CTRL__tm0__DEFAULT,
    clksel0, R_TIMER_CTRL__clksel0__DEFAULT
  );
#endif

#if USE_GROUP__Timer_registers
  REG_SET__R_TIMER_PRESCALE(
    tim_presc, R_TIMER_PRESCALE__tim_presc__DEFAULT
  );
#endif

#if USE_GROUP__USB_interface_control_registers
  REG_SET__R_USB_IRQ_MASK_CLR(
    iso_eof, R_USB_IRQ_MASK_CLR__iso_eof__DEFAULT,
    intr_eof, R_USB_IRQ_MASK_CLR__intr_eof__DEFAULT,
    iso_eot, R_USB_IRQ_MASK_CLR__iso_eot__DEFAULT,
    intr_eot, R_USB_IRQ_MASK_CLR__intr_eot__DEFAULT,
    ctl_eot, R_USB_IRQ_MASK_CLR__ctl_eot__DEFAULT,
    bulk_eot, R_USB_IRQ_MASK_CLR__bulk_eot__DEFAULT,
    epid_attn, R_USB_IRQ_MASK_CLR__epid_attn__DEFAULT,
    sof, R_USB_IRQ_MASK_CLR__sof__DEFAULT,
    port_status, R_USB_IRQ_MASK_CLR__port_status__DEFAULT,
    ctl_status, R_USB_IRQ_MASK_CLR__ctl_status__DEFAULT
  );
#endif

#if USE_GROUP__USB_interface_control_registers
  REG_SET__R_USB_IRQ_MASK_CLR_DEV(
    out_eot, R_USB_IRQ_MASK_CLR_DEV__out_eot__DEFAULT,
    ep3_in_eot, R_USB_IRQ_MASK_CLR_DEV__ep3_in_eot__DEFAULT,
    ep2_in_eot, R_USB_IRQ_MASK_CLR_DEV__ep2_in_eot__DEFAULT,
    ep1_in_eot, R_USB_IRQ_MASK_CLR_DEV__ep1_in_eot__DEFAULT,
    ep0_in_eot, R_USB_IRQ_MASK_CLR_DEV__ep0_in_eot__DEFAULT,
    epid_attn, R_USB_IRQ_MASK_CLR_DEV__epid_attn__DEFAULT,
    sof, R_USB_IRQ_MASK_CLR_DEV__sof__DEFAULT,
    port_status, R_USB_IRQ_MASK_CLR_DEV__port_status__DEFAULT,
    ctl_status, R_USB_IRQ_MASK_CLR_DEV__ctl_status__DEFAULT
  );
#endif

#if USE_GROUP__USB_interface_control_registers
  REG_SET__R_USB_IRQ_MASK_SET(
    iso_eof, R_USB_IRQ_MASK_SET__iso_eof__DEFAULT,
    intr_eof, R_USB_IRQ_MASK_SET__intr_eof__DEFAULT,
    iso_eot, R_USB_IRQ_MASK_SET__iso_eot__DEFAULT,
    intr_eot, R_USB_IRQ_MASK_SET__intr_eot__DEFAULT,
    ctl_eot, R_USB_IRQ_MASK_SET__ctl_eot__DEFAULT,
    bulk_eot, R_USB_IRQ_MASK_SET__bulk_eot__DEFAULT,
    epid_attn, R_USB_IRQ_MASK_SET__epid_attn__DEFAULT,
    sof, R_USB_IRQ_MASK_SET__sof__DEFAULT,
    port_status, R_USB_IRQ_MASK_SET__port_status__DEFAULT,
    ctl_status, R_USB_IRQ_MASK_SET__ctl_status__DEFAULT
  );
#endif

#if USE_GROUP__USB_interface_control_registers
  REG_SET__R_USB_IRQ_MASK_SET_DEV(
    out_eot, R_USB_IRQ_MASK_SET_DEV__out_eot__DEFAULT,
    ep3_in_eot, R_USB_IRQ_MASK_SET_DEV__ep3_in_eot__DEFAULT,
    ep2_in_eot, R_USB_IRQ_MASK_SET_DEV__ep2_in_eot__DEFAULT,
    ep1_in_eot, R_USB_IRQ_MASK_SET_DEV__ep1_in_eot__DEFAULT,
    ep0_in_eot, R_USB_IRQ_MASK_SET_DEV__ep0_in_eot__DEFAULT,
    epid_attn, R_USB_IRQ_MASK_SET_DEV__epid_attn__DEFAULT,
    sof, R_USB_IRQ_MASK_SET_DEV__sof__DEFAULT,
    port_status, R_USB_IRQ_MASK_SET_DEV__port_status__DEFAULT,
    ctl_status, R_USB_IRQ_MASK_SET_DEV__ctl_status__DEFAULT
  );
#endif

#if USE_GROUP__USB_interface_control_registers
  REG_SET__R_USB_PORT1_DISABLE(
    disable, R_USB_PORT1_DISABLE__disable__DEFAULT
  );
#endif

#if USE_GROUP__USB_interface_control_registers
  REG_SET__R_USB_PORT2_DISABLE(
    disable, R_USB_PORT2_DISABLE__disable__DEFAULT
  );
#endif

#if USE_GROUP__Interrupt_mask_and_status_registers
  REG_SET__R_VECT_MASK_CLR(
    usb, R_VECT_MASK_CLR__usb__DEFAULT,
    dma9, R_VECT_MASK_CLR__dma9__DEFAULT,
    dma8, R_VECT_MASK_CLR__dma8__DEFAULT,
    dma7, R_VECT_MASK_CLR__dma7__DEFAULT,
    dma6, R_VECT_MASK_CLR__dma6__DEFAULT,
    dma5, R_VECT_MASK_CLR__dma5__DEFAULT,
    dma4, R_VECT_MASK_CLR__dma4__DEFAULT,
    dma3, R_VECT_MASK_CLR__dma3__DEFAULT,
    dma2, R_VECT_MASK_CLR__dma2__DEFAULT,
    dma1, R_VECT_MASK_CLR__dma1__DEFAULT,
    dma0, R_VECT_MASK_CLR__dma0__DEFAULT,
    ext_dma1, R_VECT_MASK_CLR__ext_dma1__DEFAULT,
    ext_dma0, R_VECT_MASK_CLR__ext_dma0__DEFAULT,
    pa, R_VECT_MASK_CLR__pa__DEFAULT,
    irq_intnr, R_VECT_MASK_CLR__irq_intnr__DEFAULT,
    sw, R_VECT_MASK_CLR__sw__DEFAULT,
    serial, R_VECT_MASK_CLR__serial__DEFAULT,
    snmp, R_VECT_MASK_CLR__snmp__DEFAULT,
    network, R_VECT_MASK_CLR__network__DEFAULT,
    scsi1, R_VECT_MASK_CLR__scsi1__DEFAULT,
    scsi0, R_VECT_MASK_CLR__scsi0__DEFAULT,
    timer1, R_VECT_MASK_CLR__timer1__DEFAULT,
    timer0, R_VECT_MASK_CLR__timer0__DEFAULT,
    nmi, R_VECT_MASK_CLR__nmi__DEFAULT,
    some, R_VECT_MASK_CLR__some__DEFAULT
  );
#endif

#if USE_GROUP__Interrupt_mask_and_status_registers
  REG_SET__R_VECT_MASK_SET(
    usb, R_VECT_MASK_SET__usb__DEFAULT,
    dma9, R_VECT_MASK_SET__dma9__DEFAULT,
    dma8, R_VECT_MASK_SET__dma8__DEFAULT,
    dma7, R_VECT_MASK_SET__dma7__DEFAULT,
    dma6, R_VECT_MASK_SET__dma6__DEFAULT,
    dma5, R_VECT_MASK_SET__dma5__DEFAULT,
    dma4, R_VECT_MASK_SET__dma4__DEFAULT,
    dma3, R_VECT_MASK_SET__dma3__DEFAULT,
    dma2, R_VECT_MASK_SET__dma2__DEFAULT,
    dma1, R_VECT_MASK_SET__dma1__DEFAULT,
    dma0, R_VECT_MASK_SET__dma0__DEFAULT,
    ext_dma1, R_VECT_MASK_SET__ext_dma1__DEFAULT,
    ext_dma0, R_VECT_MASK_SET__ext_dma0__DEFAULT,
    pa, R_VECT_MASK_SET__pa__DEFAULT,
    irq_intnr, R_VECT_MASK_SET__irq_intnr__DEFAULT,
    sw, R_VECT_MASK_SET__sw__DEFAULT,
    serial, R_VECT_MASK_SET__serial__DEFAULT,
    snmp, R_VECT_MASK_SET__snmp__DEFAULT,
    network, R_VECT_MASK_SET__network__DEFAULT,
    scsi1, R_VECT_MASK_SET__scsi1__DEFAULT,
    scsi0, R_VECT_MASK_SET__scsi0__DEFAULT,
    timer1, R_VECT_MASK_SET__timer1__DEFAULT,
    timer0, R_VECT_MASK_SET__timer0__DEFAULT,
    nmi, R_VECT_MASK_SET__nmi__DEFAULT,
    some, R_VECT_MASK_SET__some__DEFAULT
  );
#endif

#if USE_GROUP__Bus_interface_configuration_registers
  REG_SET__R_WAITSTATES(
    pcs4_7_zw, R_WAITSTATES__pcs4_7_zw__DEFAULT,
    pcs4_7_ew, R_WAITSTATES__pcs4_7_ew__DEFAULT,
    pcs4_7_lw, R_WAITSTATES__pcs4_7_lw__DEFAULT,
    pcs0_3_zw, R_WAITSTATES__pcs0_3_zw__DEFAULT,
    pcs0_3_ew, R_WAITSTATES__pcs0_3_ew__DEFAULT,
    pcs0_3_lw, R_WAITSTATES__pcs0_3_lw__DEFAULT,
    sram_zw, R_WAITSTATES__sram_zw__DEFAULT,
    sram_ew, R_WAITSTATES__sram_ew__DEFAULT,
    sram_lw, R_WAITSTATES__sram_lw__DEFAULT,
    flash_zw, R_WAITSTATES__flash_zw__DEFAULT,
    flash_ew, R_WAITSTATES__flash_ew__DEFAULT,
    flash_lw, R_WAITSTATES__flash_lw__DEFAULT
  );
#endif

#if USE_GROUP__Timer_registers
  REG_SET__R_WATCHDOG(
    key, R_WATCHDOG__key__DEFAULT,
    enable, R_WATCHDOG__enable__DEFAULT
  );
#endif
#endif
} /* init_shadow__hwregs */
